/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.chat.FunctionCall;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message
implements Serializable {
    private String role;
    private String content;
    private String name;
    @JsonProperty(value="function_call")
    private FunctionCall functionCall;

    public static Builder builder() {
        return new Builder();
    }

    public Message(String role, String content, String name, FunctionCall functionCall) {
        this.role = role;
        this.content = content;
        this.name = name;
        this.functionCall = functionCall;
    }

    public Message() {
    }

    private Message(Builder builder) {
        this.setRole(builder.role);
        this.setContent(builder.content);
        this.setName(builder.name);
        this.setFunctionCall(builder.functionCall);
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="function_call")
    public void setFunctionCall(FunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FunctionCall this$functionCall = this.getFunctionCall();
        FunctionCall other$functionCall = other.getFunctionCall();
        return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FunctionCall $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
        return result;
    }

    public String toString() {
        return "Message(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    public static final class Builder {
        private String role;
        private String content;
        private String name;
        private FunctionCall functionCall;

        public Builder role(Role role) {
            this.role = role.getName();
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder functionCall(FunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant"),
        FUNCTION("function");

        private String name;

        public String getName() {
            return this.name;
        }

        private Role(String name) {
            this.name = name;
        }
    }
}

