/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.unfbx.chatgpt.OpenAiApi;
import com.unfbx.chatgpt.entity.billing.BillingUsage;
import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.billing.Subscription;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.common.DeleteResponse;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.entity.completions.CompletionResponse;
import com.unfbx.chatgpt.entity.edits.Edit;
import com.unfbx.chatgpt.entity.edits.EditResponse;
import com.unfbx.chatgpt.entity.embeddings.Embedding;
import com.unfbx.chatgpt.entity.embeddings.EmbeddingResponse;
import com.unfbx.chatgpt.entity.engines.Engine;
import com.unfbx.chatgpt.entity.files.File;
import com.unfbx.chatgpt.entity.files.UploadFileResponse;
import com.unfbx.chatgpt.entity.fineTune.Event;
import com.unfbx.chatgpt.entity.fineTune.FineTune;
import com.unfbx.chatgpt.entity.fineTune.FineTuneDeleteResponse;
import com.unfbx.chatgpt.entity.fineTune.FineTuneResponse;
import com.unfbx.chatgpt.entity.images.Image;
import com.unfbx.chatgpt.entity.images.ImageEdit;
import com.unfbx.chatgpt.entity.images.ImageResponse;
import com.unfbx.chatgpt.entity.images.ImageVariations;
import com.unfbx.chatgpt.entity.images.Item;
import com.unfbx.chatgpt.entity.models.Model;
import com.unfbx.chatgpt.entity.models.ModelResponse;
import com.unfbx.chatgpt.entity.moderations.Moderation;
import com.unfbx.chatgpt.entity.moderations.ModerationResponse;
import com.unfbx.chatgpt.entity.whisper.Transcriptions;
import com.unfbx.chatgpt.entity.whisper.Translations;
import com.unfbx.chatgpt.entity.whisper.WhisperResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.function.KeyRandomStrategy;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import com.unfbx.chatgpt.interceptor.DefaultOpenAiAuthInterceptor;
import com.unfbx.chatgpt.interceptor.OpenAiAuthInterceptor;
import io.reactivex.Single;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    @NotNull
    private List<String> apiKey;
    private String apiHost;
    private OpenAiApi openAiApi;
    private OkHttpClient okHttpClient;
    private KeyStrategyFunction<List<String>, String> keyStrategy;
    private OpenAiAuthInterceptor authInterceptor;

    public static Builder builder() {
        return new Builder();
    }

    private OpenAiClient(Builder builder) {
        if (CollectionUtil.isEmpty((Collection)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (StrUtil.isBlank((CharSequence)builder.apiHost)) {
            builder.apiHost = "https://api.openai.com/";
        }
        this.apiHost = builder.apiHost;
        if (Objects.isNull(builder.keyStrategy)) {
            builder.keyStrategy = new KeyRandomStrategy();
        }
        this.keyStrategy = builder.keyStrategy;
        if (Objects.isNull(builder.authInterceptor)) {
            builder.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor = builder.authInterceptor;
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        if (Objects.isNull(builder.okHttpClient)) {
            builder.okHttpClient = this.okHttpClient();
        } else {
            builder.okHttpClient = builder.okHttpClient.newBuilder().addInterceptor((Interceptor)this.authInterceptor).build();
        }
        this.okHttpClient = builder.okHttpClient;
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    private OkHttpClient okHttpClient() {
        if (Objects.isNull(this.authInterceptor)) {
            this.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)this.authInterceptor).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    public List<Model> models() {
        Single<ModelResponse> models = this.openAiApi.models();
        List<Model> modelList = ((ModelResponse)models.blockingGet()).getData();
        return modelList;
    }

    public Model model(String id) {
        if (Objects.isNull(id) || "".equals(id)) {
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        Single<Model> model = this.openAiApi.model(id);
        return (Model)model.blockingGet();
    }

    public CompletionResponse completions(Completion completion) {
        Single<CompletionResponse> completions = this.openAiApi.completions(completion);
        return (CompletionResponse)completions.blockingGet();
    }

    public CompletionResponse completions(String question) {
        Completion q = Completion.builder().prompt(question).build();
        Single<CompletionResponse> completions = this.openAiApi.completions(q);
        return (CompletionResponse)completions.blockingGet();
    }

    public EditResponse edit(Edit edit) {
        Single<EditResponse> edits = this.openAiApi.edits(edit);
        return (EditResponse)edits.blockingGet();
    }

    public ImageResponse genImages(String prompt) {
        Image image = Image.builder().prompt(prompt).build();
        return this.genImages(image);
    }

    public ImageResponse genImages(Image image) {
        Single<ImageResponse> edits = this.openAiApi.genImages(image);
        return (ImageResponse)edits.blockingGet();
    }

    public List<Item> editImages(java.io.File image, String prompt) {
        ImageEdit imageEdit = ImageEdit.builder().prompt(prompt).build();
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, ImageEdit imageEdit) {
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, java.io.File mask, ImageEdit imageEdit) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        if (Objects.nonNull(mask)) {
            this.checkImageFormat(image);
            this.checkImageSize(image);
        }
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part imageMultipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        MultipartBody.Part maskMultipartBody = null;
        if (Objects.nonNull(mask)) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)mask);
            maskMultipartBody = MultipartBody.Part.createFormData((String)"mask", (String)image.getName(), (RequestBody)maskBody);
        }
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getPrompt()));
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getResponseFormat()));
        if (!Objects.isNull(imageEdit.getUser()) && !"".equals(imageEdit.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getUser()));
        }
        Single<ImageResponse> imageResponse = this.openAiApi.editImages(imageMultipartBody, maskMultipartBody, requestBodyMap);
        return ((ImageResponse)imageResponse.blockingGet()).getData();
    }

    public ImageResponse variationsImages(java.io.File image, ImageVariations imageVariations) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getResponseFormat()));
        if (!Objects.isNull(imageVariations.getUser()) && !"".equals(imageVariations.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getUser()));
        }
        Single<ImageResponse> variationsImages = this.openAiApi.variationsImages(multipartBody, requestBodyMap);
        return (ImageResponse)variationsImages.blockingGet();
    }

    public ImageResponse variationsImages(java.io.File image) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        ImageVariations imageVariations = ImageVariations.builder().build();
        return this.variationsImages(image, imageVariations);
    }

    private void checkImage(java.io.File image) {
        if (Objects.isNull(image)) {
            log.error("image\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageFormat(java.io.File image) {
        if (!image.getName().endsWith("png") && !image.getName().endsWith("PNG")) {
            log.error("image\u683c\u5f0f\u9519\u8bef");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageSize(java.io.File image) {
        if (image.length() > 0x400000L) {
            log.error("image\u6700\u5927\u652f\u63014MB");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    public EmbeddingResponse embeddings(String input) {
        ArrayList<String> inputs = new ArrayList<String>(1);
        inputs.add(input);
        Embedding embedding = Embedding.builder().input(inputs).build();
        return this.embeddings(embedding);
    }

    public EmbeddingResponse embeddings(List<String> input) {
        Embedding embedding = Embedding.builder().input(input).build();
        return this.embeddings(embedding);
    }

    public EmbeddingResponse embeddings(Embedding embedding) {
        Single<EmbeddingResponse> embeddings = this.openAiApi.embeddings(embedding);
        return (EmbeddingResponse)embeddings.blockingGet();
    }

    public List<File> files() {
        Single<OpenAiResponse<File>> files = this.openAiApi.files();
        return ((OpenAiResponse)files.blockingGet()).getData();
    }

    public DeleteResponse deleteFile(String fileId) {
        Single<DeleteResponse> deleteFile = this.openAiApi.deleteFile(fileId);
        return (DeleteResponse)deleteFile.blockingGet();
    }

    public UploadFileResponse uploadFile(String purpose, java.io.File file) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody purposeBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)purpose);
        Single<UploadFileResponse> uploadFileResponse = this.openAiApi.uploadFile(multipartBody, purposeBody);
        return (UploadFileResponse)uploadFileResponse.blockingGet();
    }

    public UploadFileResponse uploadFile(java.io.File file) {
        return this.uploadFile("fine-tune", file);
    }

    public File retrieveFile(String fileId) {
        Single<File> fileContent = this.openAiApi.retrieveFile(fileId);
        return (File)fileContent.blockingGet();
    }

    public ModerationResponse moderations(String input) {
        ArrayList<String> content = new ArrayList<String>(1);
        content.add(input);
        Moderation moderation = Moderation.builder().input(content).build();
        return this.moderations(moderation);
    }

    public ModerationResponse moderations(List<String> input) {
        Moderation moderation = Moderation.builder().input(input).build();
        return this.moderations(moderation);
    }

    public ModerationResponse moderations(Moderation moderation) {
        Single<ModerationResponse> moderations = this.openAiApi.moderations(moderation);
        return (ModerationResponse)moderations.blockingGet();
    }

    public FineTuneResponse fineTune(FineTune fineTune) {
        Single<FineTuneResponse> fineTuneResponse = this.openAiApi.fineTune(fineTune);
        return (FineTuneResponse)fineTuneResponse.blockingGet();
    }

    public FineTuneResponse fineTune(String trainingFileId) {
        FineTune fineTune = FineTune.builder().trainingFile(trainingFileId).build();
        return this.fineTune(fineTune);
    }

    public List<FineTuneResponse> fineTunes() {
        Single<OpenAiResponse<FineTuneResponse>> fineTunes = this.openAiApi.fineTunes();
        return ((OpenAiResponse)fineTunes.blockingGet()).getData();
    }

    public FineTuneResponse retrieveFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.retrieveFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    public FineTuneResponse cancelFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.cancelFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    public List<Event> fineTuneEvents(String fineTuneId) {
        Single<OpenAiResponse<Event>> events = this.openAiApi.fineTuneEvents(fineTuneId);
        return ((OpenAiResponse)events.blockingGet()).getData();
    }

    public FineTuneDeleteResponse deleteFineTuneModel(String model) {
        Single<FineTuneDeleteResponse> delete = this.openAiApi.deleteFineTuneModel(model);
        return (FineTuneDeleteResponse)delete.blockingGet();
    }

    @Deprecated
    public List<Engine> engines() {
        Single<OpenAiResponse<Engine>> engines = this.openAiApi.engines();
        return ((OpenAiResponse)engines.blockingGet()).getData();
    }

    @Deprecated
    public Engine engine(String engineId) {
        Single<Engine> engine = this.openAiApi.engine(engineId);
        return (Engine)engine.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) {
        Single<ChatCompletionResponse> chatCompletionResponse = this.openAiApi.chatCompletion(chatCompletion);
        return (ChatCompletionResponse)chatCompletionResponse.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(List<Message> messages) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).build();
        return this.chatCompletion(chatCompletion);
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file, Transcriptions transcriptions) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getLanguage())) {
            requestBodyMap.put("language", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getLanguage()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getResponseFormat()));
        }
        if (Objects.nonNull(transcriptions.getTemperature())) {
            requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(transcriptions.getTemperature())));
        }
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranscriptions(multipartBody, requestBodyMap);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file) {
        Transcriptions transcriptions = Transcriptions.builder().build();
        return this.speechToTextTranscriptions(file, transcriptions);
    }

    public WhisperResponse speechToTextTranslations(java.io.File file, Translations translations) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        if (StrUtil.isNotBlank((CharSequence)translations.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)translations.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)translations.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getResponseFormat()));
        }
        if (Objects.nonNull(translations.getTemperature())) {
            requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(translations.getTemperature())));
        }
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranslations(multipartBody, requestBodyMap);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranslations(java.io.File file) {
        Translations translations = Translations.builder().build();
        return this.speechToTextTranslations(file, translations);
    }

    private void checkSpeechFileSize(java.io.File file) {
        if (file.length() > 30822400L) {
            log.warn("2023-03-02\u5b98\u65b9\u6587\u6863\u63d0\u793a\uff1a\u6587\u4ef6\u4e0d\u80fd\u8d85\u51fa25MB");
        }
    }

    @Deprecated
    public CreditGrantsResponse creditGrants() {
        Single<CreditGrantsResponse> creditGrants = this.openAiApi.creditGrants();
        return (CreditGrantsResponse)creditGrants.blockingGet();
    }

    public Subscription subscription() {
        Single<Subscription> subscription = this.openAiApi.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        Single<BillingUsage> billingUsage = this.openAiApi.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }

    @NotNull
    public List<String> getApiKey() {
        return this.apiKey;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }

    public OpenAiAuthInterceptor getAuthInterceptor() {
        return this.authInterceptor;
    }

    public static final class Builder {
        @NotNull
        private List<String> apiKey;
        private String apiHost;
        private OkHttpClient okHttpClient;
        private KeyStrategyFunction keyStrategy;
        private OpenAiAuthInterceptor authInterceptor;

        public Builder apiHost(String val) {
            this.apiHost = val;
            return this;
        }

        public Builder apiKey(@NotNull List<String> val) {
            this.apiKey = val;
            return this;
        }

        public Builder keyStrategy(KeyStrategyFunction val) {
            this.keyStrategy = val;
            return this;
        }

        public Builder okHttpClient(OkHttpClient val) {
            this.okHttpClient = val;
            return this;
        }

        public Builder authInterceptor(OpenAiAuthInterceptor val) {
            this.authInterceptor = val;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }
    }
}

