/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.chat;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.chat.Functions;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.utils.TikTokensUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletion
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChatCompletion.class);
    @NonNull
    private String model;
    @NonNull
    private List<Message> messages;
    private List<Functions> functions;
    @JsonProperty(value="function_call")
    private Object functionCall;
    private double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    private Integer n;
    private boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;

    public long tokens() {
        if (CollectionUtil.isEmpty(this.messages) || StrUtil.isBlank((CharSequence)this.model)) {
            log.warn("\u53c2\u6570\u5f02\u5e38model\uff1a{}\uff0cprompt\uff1a{}", (Object)this.model, this.messages);
            return 0L;
        }
        return TikTokensUtil.tokens(this.model, this.messages);
    }

    private static String $default$model() {
        return Model.GPT_3_5_TURBO.getName();
    }

    private static double $default$temperature() {
        return 0.2;
    }

    private static Double $default$topP() {
        return 1.0;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static boolean $default$stream() {
        return false;
    }

    private static Integer $default$maxTokens() {
        return 2048;
    }

    private static double $default$presencePenalty() {
        return 0.0;
    }

    private static double $default$frequencyPenalty() {
        return 0.0;
    }

    public static ChatCompletionBuilder builder() {
        return new ChatCompletionBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<Message> getMessages() {
        return this.messages;
    }

    public List<Functions> getFunctions() {
        return this.functions;
    }

    public Object getFunctionCall() {
        return this.functionCall;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setFunctions(List<Functions> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="function_call")
    public void setFunctionCall(Object functionCall) {
        this.functionCall = functionCall;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<Functions> this$functions = this.getFunctions();
        List<Functions> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        Object this$functionCall = this.getFunctionCall();
        Object other$functionCall = other.getFunctionCall();
        if (this$functionCall == null ? other$functionCall != null : !this$functionCall.equals(other$functionCall)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<Functions> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        Object $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : $functionCall.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", functions=" + this.getFunctions() + ", functionCall=" + this.getFunctionCall() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public ChatCompletion() {
        this.model = ChatCompletion.$default$model();
        this.temperature = ChatCompletion.$default$temperature();
        this.topP = ChatCompletion.$default$topP();
        this.n = ChatCompletion.$default$n();
        this.stream = ChatCompletion.$default$stream();
        this.maxTokens = ChatCompletion.$default$maxTokens();
        this.presencePenalty = ChatCompletion.$default$presencePenalty();
        this.frequencyPenalty = ChatCompletion.$default$frequencyPenalty();
    }

    public ChatCompletion(@NonNull String model, @NonNull List<Message> messages, List<Functions> functions, Object functionCall, double temperature, Double topP, Integer n, boolean stream, List<String> stop, Integer maxTokens, double presencePenalty, double frequencyPenalty, Map logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.functions = functions;
        this.functionCall = functionCall;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static class ChatCompletionBuilder {
        private boolean model$set;
        private String model$value;
        private List<Message> messages;
        private List<Functions> functions;
        private Object functionCall;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private Double topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream$set;
        private boolean stream$value;
        private List<String> stop;
        private boolean maxTokens$set;
        private Integer maxTokens$value;
        private boolean presencePenalty$set;
        private double presencePenalty$value;
        private boolean frequencyPenalty$set;
        private double frequencyPenalty$value;
        private Map logitBias;
        private String user;

        ChatCompletionBuilder() {
        }

        public ChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public ChatCompletionBuilder messages(@NonNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public ChatCompletionBuilder functions(List<Functions> functions) {
            this.functions = functions;
            return this;
        }

        @JsonProperty(value="function_call")
        public ChatCompletionBuilder functionCall(Object functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ChatCompletionBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionBuilder topP(Double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public ChatCompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public ChatCompletionBuilder stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public ChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletion build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = ChatCompletion.$default$model();
            }
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatCompletion.$default$temperature();
            }
            Double topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatCompletion.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = ChatCompletion.$default$n();
            }
            boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = ChatCompletion.$default$stream();
            }
            Integer maxTokens$value = this.maxTokens$value;
            if (!this.maxTokens$set) {
                maxTokens$value = ChatCompletion.$default$maxTokens();
            }
            double presencePenalty$value = this.presencePenalty$value;
            if (!this.presencePenalty$set) {
                presencePenalty$value = ChatCompletion.$default$presencePenalty();
            }
            double frequencyPenalty$value = this.frequencyPenalty$value;
            if (!this.frequencyPenalty$set) {
                frequencyPenalty$value = ChatCompletion.$default$frequencyPenalty();
            }
            return new ChatCompletion(model$value, this.messages, this.functions, this.functionCall, temperature$value, topP$value, n$value, stream$value, this.stop, maxTokens$value, presencePenalty$value, frequencyPenalty$value, this.logitBias, this.user);
        }

        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(model$value=" + this.model$value + ", messages=" + this.messages + ", functions=" + this.functions + ", functionCall=" + this.functionCall + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens$value=" + this.maxTokens$value + ", presencePenalty$value=" + this.presencePenalty$value + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301"),
        GPT_3_5_TURBO_0613("gpt-3.5-turbo-0613"),
        GPT_3_5_TURBO_16K("gpt-3.5-turbo-16k"),
        GPT_3_5_TURBO_16K_0613("gpt-3.5-turbo-16k-0613"),
        GPT_4("gpt-4"),
        GPT_4_0314("gpt-4-0314"),
        GPT_4_32K("gpt-4-32k"),
        GPT_4_32K_0314("gpt-4-32k-0314"),
        GPT_4_0613("gpt-4-0613"),
        GPT_4_32K_0613("gpt-4-32k-0613");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

