/*
 * Decompiled with CFR 0.152.
 */
package com.unittesters.mule.munit.tools.testcontainers.db;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.ContainerLessJdbcDelegate;

public class MuleTestContainerHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleTestContainerHolder.class);
    Connection connection;

    public void startContainer(String url, String username, String password) {
        this.startContainer(url, username, password, null);
    }

    public void startContainer(String url, String username, String password, String tcInitScriptPath) {
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.runInitScriptIfRequired(tcInitScriptPath);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void runInitScriptIfRequired(String tcInitScriptPath) {
        Objects.requireNonNull(this.connection, "Database connection is not initialized. Container must be started first.");
        if (tcInitScriptPath == null) {
            return;
        }
        try {
            this.runSqlScript(tcInitScriptPath);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopContainer() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error while stopping the container: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void runSqlScript(String sqlScriptPath) throws SQLException {
        Objects.requireNonNull(this.connection, "Database connection is not initialized. Container must be started first.");
        Objects.requireNonNull(sqlScriptPath, "SQL Scrit path cannot be null");
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(sqlScriptPath);
            if (resource == null) {
                LOGGER.warn(String.format("Could not load classpath init script: %s", sqlScriptPath));
                throw new SQLException("Could not load classpath init script: " + sqlScriptPath + ". Resource not found.");
            }
            String sql = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            ContainerLessJdbcDelegate delegate = new ContainerLessJdbcDelegate(this.connection);
            ScriptUtils.executeDatabaseScript((DatabaseDelegate)delegate, (String)sqlScriptPath, (String)sql);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Could not load classpath init script: %s", sqlScriptPath));
            throw new SQLException("Could not load classpath init script: " + sqlScriptPath, e);
        }
        catch (ScriptException e) {
            LOGGER.error(String.format("Error while executing init script: %s", sqlScriptPath), (Throwable)e);
            throw new SQLException("Error while executing init script: " + sqlScriptPath, e);
        }
    }
}

