/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adqualitysdk.sdk;

import android.text.TextUtils;
import com.ironsource.adqualitysdk.sdk.i.kd;
import com.ironsource.adqualitysdk.sdk.i.m;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ISAdQualitySegment {
    private final String \uff92;
    private final int \uff4b;
    private final String \ufed0;
    private final int \ufedb;
    private final AtomicBoolean \uff87;
    private final long \ufc5f;
    private double \ufe99;
    private final Map<String, String> \ufc61;

    private ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map<String, String> map) {
        this.\uff92 = string;
        this.\uff4b = n2;
        this.\ufed0 = string2;
        this.\ufedb = n3;
        this.\uff87 = atomicBoolean;
        this.\ufe99 = d2;
        this.\ufc5f = l2;
        this.\ufc61 = map;
    }

    public String getName() {
        return this.\uff92;
    }

    public int getAge() {
        return this.\uff4b;
    }

    public String getGender() {
        return this.\ufed0;
    }

    public int getLevel() {
        return this.\ufedb;
    }

    public AtomicBoolean getIsPaying() {
        return this.\uff87;
    }

    public double getInAppPurchasesTotal() {
        return this.\ufe99;
    }

    public long getUserCreationDate() {
        return this.\ufc5f;
    }

    public Map<String, String> getCustomData() {
        return this.\ufc61;
    }

    /* synthetic */ ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map map, byte by2) {
        this(string, n2, string2, n3, atomicBoolean, d2, l2, map);
    }

    public static class Builder {
        private double \uff87 = 999999.99;
        private String \ufed0;
        private int \ufedb = -1;
        private String \uff4b;
        private int \uff92 = -1;
        private AtomicBoolean \ufb90 = null;
        private long \ufc5f = 0L;
        private double \ufc61 = -1.0;
        private Map<String, String> \ufecf = new HashMap<String, String>();

        public Builder setSegmentName(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (kd.\ufed0(string) && kd.\uff92(string, 32)) {
                this.\ufed0 = string;
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setSegmentName( " + string + " ) segment name must be alphanumeric and 1-32 in length");
            }
            return this;
        }

        public Builder setAge(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 <= 199) {
                this.\ufedb = n2;
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setAge( " + n2 + " ) age must be between 1-199");
            }
            return this;
        }

        public Builder setGender(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (string.toLowerCase(Locale.ENGLISH).equals("male") || string.toLowerCase(Locale.ENGLISH).equals("female")) {
                this.\uff4b = string.toLowerCase(Locale.ENGLISH);
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setGender( " + string + " ) is invalid");
            }
            return this;
        }

        public Builder setLevel(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 < 999999) {
                this.\uff92 = n2;
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setLevel( " + n2 + " ) level must be between 1-999999");
            }
            return this;
        }

        public Builder setIsPaying(boolean bl2) {
            if (this.\ufb90 == null) {
                this.\ufb90 = new AtomicBoolean();
            }
            this.\ufb90.set(bl2);
            return this;
        }

        public Builder setInAppPurchasesTotal(double d2) {
            if (d2 >= 0.0 && d2 < this.\uff87) {
                this.\ufc61 = Math.floor(d2 * 100.0) / 100.0;
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setIAPTotal( " + d2 + " ) iapt must be between 0-" + this.\uff87);
            }
            return this;
        }

        public Builder setUserCreationDate(long l2) {
            if (l2 == 0L) {
                return this;
            }
            if (l2 > 0L) {
                this.\ufc5f = l2;
            } else {
                m.\uff92("ISAdQualitySegment Builder", "setUserCreationDate( " + l2 + " ) is an invalid timestamp");
            }
            return this;
        }

        public Builder setCustomData(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return this;
            }
            try {
                if (this.\ufecf.size() < 5) {
                    if (kd.\ufed0(string) && kd.\ufed0(string2) && kd.\uff92(string, 32) && kd.\uff92(string2, 32)) {
                        string = "sgct_".concat(String.valueOf(string));
                        this.\ufecf.put(string, string2);
                    } else {
                        m.\uff92("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) key and value must be alphanumeric and 1-32 in length");
                    }
                } else {
                    m.\uff92("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) limited to 5 custom values. Ignoring custom value.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this;
        }

        public ISAdQualitySegment build() {
            return new ISAdQualitySegment(this.\ufed0, this.\ufedb, this.\uff4b, this.\uff92, this.\ufb90, this.\ufc61, this.\ufc5f, new HashMap<String, String>(this.\ufecf), 0);
        }
    }
}

