/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adqualitysdk.sdk;

import android.text.TextUtils;
import com.ironsource.adqualitysdk.sdk.i.kb;
import com.ironsource.adqualitysdk.sdk.i.n;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ISAdQualitySegment {
    private final String \uff4b;
    private final int \ufed0;
    private final String \ufedb;
    private final int \uff87;
    private final AtomicBoolean \uff92;
    private final long \ufc5f;
    private double \ufecf;
    private final Map<String, String> \ufb90;

    private ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map<String, String> map) {
        this.\uff4b = string;
        this.\ufed0 = n2;
        this.\ufedb = string2;
        this.\uff87 = n3;
        this.\uff92 = atomicBoolean;
        this.\ufecf = d2;
        this.\ufc5f = l2;
        this.\ufb90 = map;
    }

    public String getName() {
        return this.\uff4b;
    }

    public int getAge() {
        return this.\ufed0;
    }

    public String getGender() {
        return this.\ufedb;
    }

    public int getLevel() {
        return this.\uff87;
    }

    public AtomicBoolean getIsPaying() {
        return this.\uff92;
    }

    public double getInAppPurchasesTotal() {
        return this.\ufecf;
    }

    public long getUserCreationDate() {
        return this.\ufc5f;
    }

    public Map<String, String> getCustomData() {
        return this.\ufb90;
    }

    /* synthetic */ ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map map, byte by2) {
        this(string, n2, string2, n3, atomicBoolean, d2, l2, map);
    }

    public static class Builder {
        private double \uff4b = 999999.99;
        private String \uff87;
        private int \ufedb = -1;
        private String \uff92;
        private int \ufed0 = -1;
        private AtomicBoolean \ufc61 = null;
        private long \ufecf = 0L;
        private double \ufc5f = -1.0;
        private Map<String, String> \ufe99 = new HashMap<String, String>();

        public Builder setSegmentName(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (kb.\uff87(string) && kb.\uff87(string, 32)) {
                this.\uff87 = string;
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setSegmentName( " + string + " ) segment name must be alphanumeric and 1-32 in length");
            }
            return this;
        }

        public Builder setAge(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 <= 199) {
                this.\ufedb = n2;
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setAge( " + n2 + " ) age must be between 1-199");
            }
            return this;
        }

        public Builder setGender(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (string.toLowerCase(Locale.ENGLISH).equals("male") || string.toLowerCase(Locale.ENGLISH).equals("female")) {
                this.\uff92 = string.toLowerCase(Locale.ENGLISH);
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setGender( " + string + " ) is invalid");
            }
            return this;
        }

        public Builder setLevel(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 < 999999) {
                this.\ufed0 = n2;
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setLevel( " + n2 + " ) level must be between 1-999999");
            }
            return this;
        }

        public Builder setIsPaying(boolean bl2) {
            if (this.\ufc61 == null) {
                this.\ufc61 = new AtomicBoolean();
            }
            this.\ufc61.set(bl2);
            return this;
        }

        public Builder setInAppPurchasesTotal(double d2) {
            if (d2 >= 0.0 && d2 < this.\uff4b) {
                this.\ufc5f = Math.floor(d2 * 100.0) / 100.0;
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setIAPTotal( " + d2 + " ) iapt must be between 0-" + this.\uff4b);
            }
            return this;
        }

        public Builder setUserCreationDate(long l2) {
            if (l2 == 0L) {
                return this;
            }
            if (l2 > 0L) {
                this.\ufecf = l2;
            } else {
                n.\uff4b("ISAdQualitySegment Builder", "setUserCreationDate( " + l2 + " ) is an invalid timestamp");
            }
            return this;
        }

        public Builder setCustomData(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return this;
            }
            try {
                if (this.\ufe99.size() < 5) {
                    if (kb.\uff87(string) && kb.\uff87(string2) && kb.\uff87(string, 32) && kb.\uff87(string2, 32)) {
                        string = "sgct_".concat(String.valueOf(string));
                        this.\ufe99.put(string, string2);
                    } else {
                        n.\uff4b("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) key and value must be alphanumeric and 1-32 in length");
                    }
                } else {
                    n.\uff4b("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) limited to 5 custom values. Ignoring custom value.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this;
        }

        public ISAdQualitySegment build() {
            return new ISAdQualitySegment(this.\uff87, this.\ufedb, this.\uff92, this.\ufed0, this.\ufc61, this.\ufc5f, this.\ufecf, new HashMap<String, String>(this.\ufe99), 0);
        }
    }
}

