/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adqualitysdk.sdk;

import android.text.TextUtils;
import com.ironsource.adqualitysdk.sdk.i.k;
import com.ironsource.adqualitysdk.sdk.i.ka;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ISAdQualitySegment {
    private final String \ufed0;
    private final int \uff87;
    private final String \ufedb;
    private final int \uff92;
    private final AtomicBoolean \uff4b;
    private final long \ufc5f;
    private double \ufe99;
    private final Map<String, String> \ufecf;

    private ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map<String, String> map) {
        this.\ufed0 = string;
        this.\uff87 = n2;
        this.\ufedb = string2;
        this.\uff92 = n3;
        this.\uff4b = atomicBoolean;
        this.\ufe99 = d2;
        this.\ufc5f = l2;
        this.\ufecf = map;
    }

    public String getName() {
        return this.\ufed0;
    }

    public int getAge() {
        return this.\uff87;
    }

    public String getGender() {
        return this.\ufedb;
    }

    public int getLevel() {
        return this.\uff92;
    }

    public AtomicBoolean getIsPaying() {
        return this.\uff4b;
    }

    public double getInAppPurchasesTotal() {
        return this.\ufe99;
    }

    public long getUserCreationDate() {
        return this.\ufc5f;
    }

    public Map<String, String> getCustomData() {
        return this.\ufecf;
    }

    /* synthetic */ ISAdQualitySegment(String string, int n2, String string2, int n3, AtomicBoolean atomicBoolean, double d2, long l2, Map map, byte by2) {
        this(string, n2, string2, n3, atomicBoolean, d2, l2, map);
    }

    public static class Builder {
        private double \uff87 = 999999.99;
        private String \uff92;
        private int \ufedb = -1;
        private String \uff4b;
        private int \ufed0 = -1;
        private AtomicBoolean \ufc61 = null;
        private long \ufc5f = 0L;
        private double \ufecf = -1.0;
        private Map<String, String> \ufe99 = new HashMap<String, String>();

        public Builder setSegmentName(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (ka.\ufedb(string) && ka.\ufedb(string, 32)) {
                this.\uff92 = string;
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setSegmentName( " + string + " ) segment name must be alphanumeric and 1-32 in length");
            }
            return this;
        }

        public Builder setAge(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 <= 199) {
                this.\ufedb = n2;
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setAge( " + n2 + " ) age must be between 1-199");
            }
            return this;
        }

        public Builder setGender(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return this;
            }
            if (string.toLowerCase(Locale.ENGLISH).equals("male") || string.toLowerCase(Locale.ENGLISH).equals("female")) {
                this.\uff4b = string.toLowerCase(Locale.ENGLISH);
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setGender( " + string + " ) is invalid");
            }
            return this;
        }

        public Builder setLevel(int n2) {
            if (n2 == 0) {
                return this;
            }
            if (n2 > 0 && n2 < 999999) {
                this.\ufed0 = n2;
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setLevel( " + n2 + " ) level must be between 1-999999");
            }
            return this;
        }

        public Builder setIsPaying(boolean bl2) {
            if (this.\ufc61 == null) {
                this.\ufc61 = new AtomicBoolean();
            }
            this.\ufc61.set(bl2);
            return this;
        }

        public Builder setInAppPurchasesTotal(double d2) {
            if (d2 >= 0.0 && d2 < this.\uff87) {
                this.\ufecf = Math.floor(d2 * 100.0) / 100.0;
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setIAPTotal( " + d2 + " ) iapt must be between 0-" + this.\uff87);
            }
            return this;
        }

        public Builder setUserCreationDate(long l2) {
            if (l2 == 0L) {
                return this;
            }
            if (l2 > 0L) {
                this.\ufc5f = l2;
            } else {
                k.\ufedb("ISAdQualitySegment Builder", "setUserCreationDate( " + l2 + " ) is an invalid timestamp");
            }
            return this;
        }

        public Builder setCustomData(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return this;
            }
            try {
                if (this.\ufe99.size() < 5) {
                    if (ka.\ufedb(string) && ka.\ufedb(string2) && ka.\ufedb(string, 32) && ka.\ufedb(string2, 32)) {
                        string = "sgct_".concat(String.valueOf(string));
                        this.\ufe99.put(string, string2);
                    } else {
                        k.\ufedb("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) key and value must be alphanumeric and 1-32 in length");
                    }
                } else {
                    k.\ufedb("ISAdQualitySegment Builder", "setCustomData( " + string + " , " + string2 + " ) limited to 5 custom values. Ignoring custom value.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this;
        }

        public ISAdQualitySegment build() {
            return new ISAdQualitySegment(this.\uff92, this.\ufedb, this.\uff4b, this.\ufed0, this.\ufc61, this.\ufecf, this.\ufc5f, new HashMap<String, String>(this.\ufe99), 0);
        }
    }
}

