/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;

public class AdapterUtils {
    public static final int MIN_TABLET_DP_SIZE = 600;

    public static boolean isLargeScreen(Context context) {
        if (context == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "AdapterUtils isLargeScreen - context is null", 3);
            return false;
        }
        return context.getResources().getConfiguration().smallestScreenWidthDp >= 600;
    }

    public static String getScreenSizeParams(Context context) {
        float f10;
        Context context2 = context;
        context = context2.getResources().getDisplayMetrics();
        float f11 = context.density;
        float f12 = (float)context.heightPixels / f11;
        f11 = Math.min((float)context.widthPixels / f11, f12);
        f12 = context.xdpi;
        float f13 = context.ydpi;
        float f14 = (float)context.widthPixels / f12;
        float f15 = f10 = (float)context.heightPixels / f13;
        double d10 = Math.sqrt(f14 * f14 + f15 * f15);
        return "smallestWidth = " + f11 + " diagonalInches = " + d10 + " smallScreenDpApi =  " + context2.getResources().getConfiguration().smallestScreenWidthDp;
    }

    public static int dpToPixels(Context context, int n10) {
        if (context == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "AdapterUtils dpToPixels - context is null, returning dpSize", 3);
            return n10;
        }
        float f10 = n10;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f10, (DisplayMetrics)displayMetrics);
    }
}

