/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.adquality;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.ironsource.A5;
import com.ironsource.K6;
import com.ironsource.adqualitysdk.sdk.ISAdQualityConfig;
import com.ironsource.adqualitysdk.sdk.ISAdQualityDeviceIdType;
import com.ironsource.adqualitysdk.sdk.ISAdQualityInitError;
import com.ironsource.adqualitysdk.sdk.ISAdQualityInitListener;
import com.ironsource.adqualitysdk.sdk.ISAdQualityLogLevel;
import com.ironsource.adqualitysdk.sdk.ISAdQualitySegment;
import com.ironsource.adqualitysdk.sdk.IronSourceAdQuality;
import com.ironsource.h0;
import com.ironsource.mediationsdk.IronSourceSegment;
import com.ironsource.mediationsdk.adquality.a;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.q4;
import com.ironsource.sb;
import com.ironsource.z5;
import java.util.Iterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public final class AdQualityBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static Boolean isGetVersionMethodExist;

    public AdQualityBridge(@NotNull Context context, @NotNull String string, @Nullable String object, @NotNull h0 h02, int n10) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)h02, (String)"adQualityDataProvider");
        AdQualityBridge adQualityBridge = new ISAdQualityConfig.Builder().setInitializationSource("LevelPlay").setLogLevel(adQualityBridge.convertToAdQualityLogLevel(n10)).setAdQualityInitListener(new ISAdQualityInitListener(){

            public void adQualitySdkInitSuccess() {
                com.ironsource.mediationsdk.adquality.AdQualityBridge$Companion.logEvent$default(AdQualityBridge.Companion, A5.A, null, null, 6, null);
            }

            public void adQualitySdkInitFailed(@NotNull ISAdQualityInitError iSAdQualityInitError, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)iSAdQualityInitError, (String)"isAdQualityInitError");
                Intrinsics.checkNotNullParameter((Object)string, (String)"message");
                Object object = A5.C;
                if (iSAdQualityInitError == ISAdQualityInitError.AD_QUALITY_ALREADY_INITIALIZED) {
                    object = A5.B;
                }
                com.ironsource.mediationsdk.adquality.AdQualityBridge$Companion.access$logEvent(AdQualityBridge.Companion, (A5)((Object)object), iSAdQualityInitError.getValue(), string);
                object = IronSourceLogger.IronSourceTag.API;
                IronSourceLoggerManager.getLogger().log((IronSourceLogger.IronSourceTag)((Object)object), "Ad Quality failed to initialize: " + string, 3);
            }
        }).setCoppa(adQualityBridge.getCoppaValue()).setDeviceIdType(adQualityBridge.getDeviceIdType());
        if (!TextUtils.isEmpty((CharSequence)object)) {
            adQualityBridge.setUserId((String)object);
        }
        if (((Companion)(object = AdQualityBridge.Companion)).versionCompare(((Companion)object).getAdQualitySdkVersion(), "7.14.1") >= 0 && (h02 = h02.a()).length() > 0) {
            adQualityBridge.setMetaData((JSONObject)h02);
        }
        com.ironsource.mediationsdk.adquality.AdQualityBridge$Companion.logEvent$default((Companion)object, A5.z, null, null, 6, null);
        adQualityBridge = adQualityBridge.build();
        IronSourceAdQuality.getInstance().initialize(context, string, (ISAdQualityConfig)adQualityBridge);
    }

    private final ISAdQualityLogLevel convertToAdQualityLogLevel(int n10) {
        return switch (n10) {
            default -> ISAdQualityLogLevel.INFO;
            case 3 -> ISAdQualityLogLevel.ERROR;
            case 2 -> ISAdQualityLogLevel.WARNING;
            case 1 -> ISAdQualityLogLevel.INFO;
            case 0 -> ISAdQualityLogLevel.VERBOSE;
        };
    }

    private final ISAdQualityDeviceIdType getDeviceIdType() {
        AdQualityBridge adQualityBridge = ISAdQualityDeviceIdType.GAID;
        if (!TextUtils.isEmpty((CharSequence)K6.a().a("AdvIdOptOutReason"))) {
            adQualityBridge = ISAdQualityDeviceIdType.NONE;
        }
        return adQualityBridge;
    }

    private final boolean getCoppaValue() {
        String string = K6.a().a("is_coppa");
        return string != null && Boolean.parseBoolean(string);
    }

    @JvmStatic
    public static final boolean adQualityAvailable() {
        return Companion.adQualityAvailable();
    }

    @JvmStatic
    @NotNull
    public static final String getAdQualitySdkVersion() {
        return Companion.getAdQualitySdkVersion();
    }

    @JvmStatic
    private static final boolean isGetVersionMethodExist() {
        return AdQualityBridge.Companion.isGetVersionMethodExist();
    }

    @JvmStatic
    private static final int versionCompare(String string, String string2) {
        return AdQualityBridge.Companion.versionCompare(string, string2);
    }

    @JvmStatic
    private static final void logEvent(A5 a52, Integer n10, String string) {
        AdQualityBridge.Companion.logEvent(a52, n10, string);
    }

    public final void changeUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"userId");
        IronSourceAdQuality.getInstance().changeUserId(string);
    }

    public final void setSegment(@NotNull IronSourceSegment object) {
        ISAdQualitySegment.Builder builder;
        Iterator<Pair<String, String>> iterator = object;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"segment");
        AdQualityBridge adQualityBridge = builder;
        builder = new ISAdQualitySegment.Builder();
        if (((IronSourceSegment)((Object)iterator)).getSegmentName() != null) {
            adQualityBridge.setSegmentName(((IronSourceSegment)((Object)object)).getSegmentName());
        }
        if (((IronSourceSegment)((Object)object)).getAge() > -1) {
            adQualityBridge.setAge(((IronSourceSegment)((Object)object)).getAge());
        }
        if (((IronSourceSegment)((Object)object)).getGender() != null) {
            adQualityBridge.setGender(((IronSourceSegment)((Object)object)).getGender());
        }
        if (((IronSourceSegment)((Object)object)).getLevel() > -1) {
            adQualityBridge.setLevel(((IronSourceSegment)((Object)object)).getLevel());
        }
        if (((IronSourceSegment)((Object)object)).getIsPaying() != null) {
            adQualityBridge.setIsPaying(((IronSourceSegment)((Object)object)).getIsPaying().get());
        }
        if (((IronSourceSegment)((Object)object)).getIapt() > -1.0) {
            adQualityBridge.setInAppPurchasesTotal(((IronSourceSegment)((Object)object)).getIapt());
        }
        if (((IronSourceSegment)((Object)object)).getUcd() > 0L) {
            adQualityBridge.setUserCreationDate(((IronSourceSegment)((Object)object)).getUcd());
        }
        for (Pair<String, String> pair : ((IronSourceSegment)((Object)object)).getSegmentData()) {
            String string = (String)pair.first;
            String object2 = (String)pair.second;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
            if (!StringsKt.startsWith$default((String)string, (String)"custom_", (boolean)false, (int)2, null)) continue;
            adQualityBridge.setCustomData(StringsKt.removePrefix((String)string, (CharSequence)"custom_"), object2);
        }
        IronSourceAdQuality.getInstance().setSegment(adQualityBridge.build());
    }

    @SourceDebugExtension(value={"SMAP\nAdQualityBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdQualityBridge.kt\ncom/ironsource/mediationsdk/adquality/AdQualityBridge$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,302:1\n37#2,2:303\n37#2,2:305\n*S KotlinDebug\n*F\n+ 1 AdQualityBridge.kt\ncom/ironsource/mediationsdk/adquality/AdQualityBridge$Companion\n*L\n166#1:303,2\n167#1:305,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void isGetVersionMethodExist$annotations() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        private final boolean isGetVersionMethodExist() {
            Throwable throwable2;
            block3: {
                try {
                    if (isGetVersionMethodExist != null) {
                        return Intrinsics.areEqual((Object)isGetVersionMethodExist, (Object)Boolean.TRUE);
                    }
                }
                catch (Throwable throwable2) {
                    break block3;
                }
                boolean bl = Class.forName("com.ironsource.adqualitysdk.sdk.IronSourceAdQuality").getDeclaredMethods().length >= 10;
                isGetVersionMethodExist = bl;
                return bl;
            }
            q4.d().a(throwable2);
            com.ironsource.mediationsdk.adquality.AdQualityBridge$Companion.logEvent$default(this, A5.D, null, null, 6, null);
            return false;
        }

        @JvmStatic
        private final int versionCompare(String stringArray, String string) {
            if (!TextUtils.isEmpty((CharSequence)stringArray) && !TextUtils.isEmpty((CharSequence)string)) {
                int n10;
                String[] stringArray2 = StringsKt.split$default((CharSequence)new Regex("[^0-9.]").replace((CharSequence)stringArray, ""), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                stringArray = StringsKt.split$default((CharSequence)new Regex("[^0-9.]").replace((CharSequence)string, ""), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                for (n10 = 0; n10 < stringArray2.length && n10 < stringArray.length && Intrinsics.areEqual((Object)stringArray2[n10], (Object)stringArray[n10]); ++n10) {
                }
                if (n10 < stringArray2.length && n10 < stringArray.length) {
                    int n11 = Integer.valueOf(stringArray2[n10]);
                    Integer n12 = Integer.valueOf(stringArray[n10]);
                    Intrinsics.checkNotNullExpressionValue((Object)n12, (String)"valueOf(vals2[i])");
                    return Integer.signum(Intrinsics.compare((int)n11, (int)n12));
                }
                return Integer.signum(stringArray2.length - stringArray.length);
            }
            return -1;
        }

        @JvmStatic
        private final void logEvent(A5 a52, Integer n10, String string) {
            Companion companion = IronSourceUtils.getMediationAdditionalData(false);
            if (n10 != null) {
                companion.put("errorCode", n10);
            }
            if (string != null) {
                companion.put("reason", string);
            }
            companion.put("ext1", a.a.a().b());
            sb.s.d().q().a(new z5(a52, (JSONObject)companion));
        }

        static /* synthetic */ void logEvent$default(Companion companion, A5 a52, Integer n10, String string, int n11, Object object) {
            if ((n11 & 2) != 0) {
                n10 = null;
            }
            if ((n11 & 4) != 0) {
                string = null;
            }
            companion.logEvent(a52, n10, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        public final boolean adQualityAvailable() {
            Companion companion = this;
            return companion.versionCompare(companion.getAdQualitySdkVersion(), "7.9.0") >= 0;
        }

        @JvmStatic
        @NotNull
        public final String getAdQualitySdkVersion() {
            if (this.isGetVersionMethodExist()) {
                String string = IronSourceAdQuality.getSDKVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSDKVersion()");
                return string;
            }
            return new String();
        }
    }
}

