/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import android.util.Pair;
import com.ironsource.environment.StringUtils;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.r8;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceSegment {
    public static final String AGE = "age";
    public static final String GENDER = "gen";
    public static final String LEVEL = "lvl";
    public static final String PAYING = "pay";
    public static final String IAPT = "iapt";
    public static final String USER_CREATION_DATE = "ucd";
    private static final String m = "segName";
    private String a;
    private int b = 999999;
    private double c = 999999.99;
    private final String d;
    private final int e;
    private int f = -1;
    private String g;
    private int h = -1;
    private AtomicBoolean i = null;
    private double j = -1.0;
    private long k = 0L;
    private ArrayList<Pair<String, String>> l;

    public IronSourceSegment() {
        ArrayList arrayList;
        ((IronSourceSegment)((Object)arrayList2)).d = "custom";
        ((IronSourceSegment)((Object)arrayList2)).e = 5;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.l = arrayList2;
    }

    private boolean a(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("^[a-zA-Z0-9]*$");
    }

    private boolean a(String string, int n10, int n11) {
        return string != null && string.length() >= n10 && string.length() <= n11;
    }

    public String getSegmentName() {
        return this.a;
    }

    public int getAge() {
        return this.f;
    }

    public String getGender() {
        return this.g;
    }

    public int getLevel() {
        return this.h;
    }

    public AtomicBoolean getIsPaying() {
        return this.i;
    }

    public double getIapt() {
        return this.j;
    }

    public long getUcd() {
        return this.k;
    }

    public void setAge(int n10) {
        if (n10 > 0 && n10 <= 199) {
            this.f = n10;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setAge( " + n10 + " ) age must be between 1-199", 2);
        }
    }

    public void setGender(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && (StringUtils.toLowerCase(string).equals("male") || StringUtils.toLowerCase(string).equals("female"))) {
            this.g = string;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setGender( " + string + " ) is invalid", 2);
        }
    }

    public void setLevel(int n10) {
        if (n10 > 0 && n10 < this.b) {
            this.h = n10;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setLevel( " + n10 + " ) level must be between 1-" + this.b, 2);
        }
    }

    public void setIsPaying(boolean bl2) {
        if (this.i == null) {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean();
            this.i = atomicBoolean2;
        }
        this.i.set(bl2);
    }

    public void setIAPTotal(double d10) {
        if (d10 > 0.0 && d10 < this.c) {
            this.j = Math.floor(d10 * 100.0) / 100.0;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setIAPTotal( " + d10 + " ) iapt must be between 0-" + this.c, 2);
        }
    }

    public void setUserCreationDate(long l10) {
        if (l10 > 0L) {
            this.k = l10;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setUserCreationDate( " + l10 + " ) is an invalid timestamp", 2);
        }
    }

    public void setSegmentName(String string) {
        if (this.a(string) && this.a(string, 1, 32)) {
            this.a = string;
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setSegmentName( " + string + " ) segment name must be alphanumeric and 1-32 in length", 2);
        }
    }

    public void setCustom(String string, String string2) {
        block12: {
            block10: {
                block11: {
                    if (!this.a(string)) break block10;
                    if (!this.a(string2)) break block10;
                    if (!this.a(string, 1, 32)) break block10;
                    if (!this.a(string2, 1, 32)) break block10;
                    IronSourceSegment ironSourceSegment = this;
                    string = "custom_" + string;
                    if (ironSourceSegment.l.size() < 5) break block11;
                    this.l.remove(0);
                }
                this.l.add((Pair<String, String>)new Pair((Object)string, (Object)string2));
                break block12;
            }
            try {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setCustom( " + string + " , " + string2 + " ) key and value must be alphanumeric and 1-32 in length", 2);
            }
            catch (Exception exception) {
                r8.d().a(exception);
                IronLog.INTERNAL.error(((Object)exception).toString());
            }
        }
    }

    public ArrayList<Pair<String, String>> getSegmentData() {
        Pair pair;
        ArrayList<Pair<String, String>> arrayList;
        ArrayList<Pair<String, String>> arrayList2 = arrayList;
        arrayList = new ArrayList<Pair<String, String>>();
        if (this.f != -1) {
            arrayList2.add(new Pair((Object)AGE, (Object)(this.f + "")));
        }
        if (!TextUtils.isEmpty((CharSequence)this.g)) {
            Pair pair2;
            pair = pair2;
            pair2 = new Pair((Object)GENDER, (Object)this.g);
            arrayList2.add(pair);
        }
        if (this.h != -1) {
            arrayList2.add(new Pair((Object)LEVEL, (Object)(this.h + "")));
        }
        if (this.i != null) {
            arrayList2.add(new Pair((Object)PAYING, (Object)(this.i + "")));
        }
        if (this.j != -1.0) {
            arrayList2.add((Pair<String, String>)new Pair((Object)IAPT, (Object)(this.j + "")));
        }
        if (this.k != 0L) {
            arrayList2.add((Pair<String, String>)new Pair((Object)USER_CREATION_DATE, (Object)(this.k + "")));
        }
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            Pair pair3;
            pair = pair3;
            pair3 = new Pair((Object)m, (Object)this.a);
            arrayList2.add((Pair<String, String>)pair);
        }
        ArrayList<Pair<String, String>> arrayList3 = arrayList2;
        arrayList3.addAll(this.l);
        return arrayList3;
    }

    public JSONObject toJson() {
        JSONObject jSONObject;
        IronSourceSegment ironSourceSegment = ironSourceSegment2;
        IronSourceSegment ironSourceSegment2 = jSONObject;
        jSONObject = new JSONObject();
        for (Pair<String, String> pair : ironSourceSegment.getSegmentData()) {
            String string;
            Pair<String, String> pair2;
            try {
                pair2 = pair;
                string = (String)pair.first;
            }
            catch (JSONException jSONException) {
                r8.d().a(jSONException);
                IronLog.INTERNAL.error("exception " + jSONException.getMessage());
                continue;
            }
            ironSourceSegment2.put(string, pair2.second);
        }
        return ironSourceSegment2;
    }
}

