/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.metadata;

import android.text.TextUtils;
import com.ironsource.environment.StringUtils;
import com.ironsource.mediationsdk.metadata.MetaData;
import com.ironsource.mediationsdk.metadata.a;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class MetaDataUtils {
    public static MetaData.MetaDataValueTypes getValueTypeForKey(String string) {
        if (!(string.equalsIgnoreCase("do_not_sell") || string.equalsIgnoreCase("is_child_directed") || string.equalsIgnoreCase("is_deviceid_optout") || string.equalsIgnoreCase("google_family_self_certified_sdks"))) {
            return MetaData.MetaDataValueTypes.META_DATA_VALUE_STRING;
        }
        return MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN;
    }

    public static boolean isKnownKey(String string) {
        return a.m.contains(string.toLowerCase(Locale.getDefault()));
    }

    public static boolean isMediationOnlyKey(String string) {
        return a.k.contains(string.toLowerCase(Locale.getDefault()));
    }

    public static boolean isMediationKeysBeforeInit(String string) {
        return a.l.contains(string.toLowerCase(Locale.getDefault()));
    }

    public static String formatValueForType(String string, MetaData.MetaDataValueTypes metaDataValueTypes) {
        if (metaDataValueTypes == MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN) {
            string = !string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("yes") ? (!string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no") ? "" : "false") : "true";
        }
        return string;
    }

    public static MetaData formatMetaData(String string, List<String> arrayList) {
        ArrayList<String> arrayList2;
        ArrayList<MetaData.MetaDataValueTypes> arrayList3;
        if (!MetaDataUtils.isKnownKey(string)) {
            return new MetaData(string, arrayList);
        }
        ArrayList<MetaData.MetaDataValueTypes> arrayList4 = arrayList;
        string = StringUtils.toLowerCase(string);
        arrayList = arrayList3;
        arrayList3 = new ArrayList<MetaData.MetaDataValueTypes>();
        ArrayList<String> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<String>();
        Iterator iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            MetaData.MetaDataValueTypes metaDataValueTypes = MetaDataUtils.getValueTypeForKey(string);
            String string2 = MetaDataUtils.formatValueForType((String)iterator.next(), metaDataValueTypes);
            arrayList.add(metaDataValueTypes);
            arrayList5.add(string2);
        }
        return new MetaData(string, arrayList5, arrayList);
    }

    public static String checkMetaDataKeyValidity(String string) {
        if (string != null && string.length() <= 2048) {
            return "";
        }
        return "The MetaData key you entered is invalid. Please enter a key of maximum 2048 characters.";
    }

    public static String checkMetaDataValueValidity(List<String> object) {
        if (object.isEmpty()) {
            return "The MetaData list should include at least one element.";
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string != null && string.length() <= 2048) continue;
            return "The MetaData value(s) you entered is invalid. Please enter a value of maximum 2048 characters.";
        }
        return "";
    }

    public static boolean isValidCCPAMetaData(String string, String string2) {
        return MetaDataUtils.isValidMetaData(string, "do_not_sell", string2);
    }

    public static boolean isValidMetaData(String string, String string2, String string3) {
        return string.equalsIgnoreCase(string2) && !TextUtils.isEmpty((CharSequence)string3);
    }

    public static boolean getMetaDataBooleanValue(String string) {
        return string.equals("false") ^ true;
    }
}

