/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.text.TextUtils;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class ErrorBuilder {
    public static IronSourceError buildNoConfigurationAvailableError(String string) {
        return new IronSourceError(501, "" + string + " Init Fail - Unable to retrieve configurations from the server");
    }

    public static IronSourceError buildInvalidConfigurationError(String string) {
        return new IronSourceError(501, "" + string + " Init Fail - Configurations from the server are not valid");
    }

    public static IronSourceError buildUsingCachedConfigurationError(String string, String string2) {
        return new IronSourceError(502, "Mediation - Unable to retrieve configurations from IronSource server, using cached configurations with appKey:" + string + " and userId:" + string2);
    }

    public static IronSourceError buildKeyNotSetError(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            return new IronSourceError(505, string3 + " Mediation - " + string + " is not set for " + string2);
        }
        return ErrorBuilder.a();
    }

    public static IronSourceError buildInvalidKeyValueError(String charSequence, String string) {
        IronSourceError ironSourceError;
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return ErrorBuilder.a();
        }
        int n10 = 506;
        charSequence = new StringBuilder().append("Mediation - ").append((String)charSequence).append(" value is not valid ");
        string = !TextUtils.isEmpty((CharSequence)string) ? " - " + string : "";
        IronSourceError ironSourceError2 = ironSourceError;
        ironSourceError2(n10, ((StringBuilder)charSequence).append(string).toString());
        return ironSourceError2;
    }

    public static IronSourceError buildInvalidCredentialsError(String charSequence, String string, String string2) {
        charSequence = new StringBuilder().append("Init Fail - ").append((String)charSequence).append(" value ").append(string).append(" is not valid");
        string = !TextUtils.isEmpty((CharSequence)string2) ? " - " + string2 : "";
        charSequence = ((StringBuilder)charSequence).append(string).toString();
        return new IronSourceError(506, (String)charSequence);
    }

    public static IronSourceError buildInitFailedError(String string, String string2) {
        string = TextUtils.isEmpty((CharSequence)string) ? string2 + " init failed due to an unknown error" : string2 + " - " + string;
        return new IronSourceError(508, string);
    }

    public static IronSourceError buildInitFailedError(String string) {
        StringBuilder stringBuilder = new StringBuilder().append("Init failed - ");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "unknown error";
        }
        string = stringBuilder.append(string).toString();
        return new IronSourceError(508, string);
    }

    public static IronSourceError buildNoAdsToShowError(String string) {
        return new IronSourceError(509, string + " Show Fail - No ads to show");
    }

    public static IronSourceError buildShowFailedError(String string, String string2) {
        return new IronSourceError(509, string + " Show Fail - " + string2);
    }

    public static IronSourceError buildLoadFailedError(String charSequence, String string, String string2) {
        charSequence = new StringBuilder().append("").append((String)charSequence).append(" Load Fail");
        string = !TextUtils.isEmpty((CharSequence)string) ? " " + string : "";
        charSequence = ((StringBuilder)charSequence).append(string).append(" - ").toString();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "unknown error";
        }
        charSequence = (String)charSequence + string2;
        return new IronSourceError(510, (String)charSequence);
    }

    public static IronSourceError buildGenericError(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "An error occurred";
        }
        return new IronSourceError(510, string);
    }

    public static IronSourceError buildNoInternetConnectionInitFailError(String string) {
        return new IronSourceError(520, "" + string + " Init Fail - No Internet connection");
    }

    public static IronSourceError buildNoInternetConnectionLoadFailError(String string) {
        return new IronSourceError(520, "" + string + " Load Fail - No Internet connection");
    }

    public static IronSourceError buildNoInternetConnectionShowFailError(String string) {
        return new IronSourceError(520, "" + string + " Show Fail - No Internet connection");
    }

    public static IronSourceError buildCappedPerPlacementError(String string) {
        return new IronSourceError(524, string);
    }

    public static IronSourceError buildCappedPerSessionError(String string) {
        return new IronSourceError(526, string + " Show Fail - Networks have reached their cap per session");
    }

    public static IronSourceError buildNonExistentInstanceError(String string) {
        return new IronSourceError(527, string + " The requested instance does not exist");
    }

    private static IronSourceError a() {
        return ErrorBuilder.buildGenericError("Mediation - wrong configuration");
    }

    public static IronSourceError buildLoadFailedError(String string) {
        string = TextUtils.isEmpty((CharSequence)string) ? "Load failed due to an unknown error" : "Load failed - " + string;
        return new IronSourceError(510, string);
    }

    public static IronSourceError unsupportedBannerSize(String string) {
        return new IronSourceError(616, string + " unsupported banner size");
    }

    public static IronSourceError adContainerIsNull(String string) {
        return new IronSourceError(617, string + " banner container is null");
    }
}

