/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import com.ironsource.mediationsdk.d;
import com.ironsource.mediationsdk.logger.IronLog;
import java.util.HashMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public interface IronSourceLoadParameters {
    @NotNull
    public HashMap<String, String> value();

    public boolean demandOnly();

    @NotNull
    public JSONObject config();

    public static final class Base
    implements IronSourceLoadParameters {
        @NotNull
        private final JSONObject loadConfig;
        @Nullable
        private final String serverData;

        public Base(@NotNull JSONObject jSONObject, @Nullable String string) {
            Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"loadConfig");
            this.loadConfig = jSONObject;
            this.serverData = string;
        }

        public /* synthetic */ Base(JSONObject jSONObject, String string, int n10, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n10 & 2) != 0) {
                string = null;
            }
            this(jSONObject, string);
        }

        @Override
        public boolean demandOnly() {
            return this.loadConfig.optBoolean("demandOnly", false);
        }

        @Override
        @NotNull
        public JSONObject config() {
            return this.loadConfig;
        }

        @Override
        @NotNull
        public HashMap<String, String> value() {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap2();
            hashMap.put("isOneFlow", String.valueOf(this.loadConfig.optBoolean("isOneFlow")));
            if (this.serverData != null) {
                HashMap<String, String> hashMap3 = hashMap2;
                String string = d.b().a(this.serverData);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().getAdmFromServerData(serverData)");
                hashMap3.put("adm", string);
                hashMap3.putAll(d.b().b(this.serverData));
            }
            return hashMap2;
        }
    }

    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String ADM_KEY = "adm";
        @NotNull
        public static final String ONE_FLOW_KEY = "isOneFlow";
        @NotNull
        public static final String DEMAND_ONLY = "demandOnly";

        private Constants() {
        }
    }

    public static final class WithLog
    implements IronSourceLoadParameters {
        @NotNull
        private final IronSourceLoadParameters loadParameters;

        public WithLog(@NotNull IronSourceLoadParameters ironSourceLoadParameters) {
            Intrinsics.checkNotNullParameter((Object)ironSourceLoadParameters, (String)"loadParameters");
            this.loadParameters = ironSourceLoadParameters;
        }

        @Override
        @NotNull
        public HashMap<String, String> value() {
            HashMap<String, String> hashMap = ((WithLog)((Object)hashMap)).loadParameters.value();
            if (!hashMap.isEmpty()) {
                IronLog.ADAPTER_API.verbose("instance extra params:");
                for (String string : hashMap.keySet()) {
                    IronLog.ADAPTER_API.verbose(string + "=" + hashMap.get(string));
                }
            }
            return hashMap;
        }

        @Override
        public boolean demandOnly() {
            return this.loadParameters.demandOnly();
        }

        @Override
        @NotNull
        public JSONObject config() {
            return this.loadParameters.config();
        }
    }
}

