package com.unity3d.ads.core.data.datasource

import ByteStringStoreOuterClass.ByteStringStore
import androidx.datastore.core.DataMigration
import com.google.protobuf.ByteString
import com.unity3d.ads.core.domain.GetOpenGLRendererInfo

class FetchGLInfoDataMigration(private val getOpenGLRendererInfo: GetOpenGLRendererInfo) : DataMigration<ByteStringStore> {
    override suspend fun cleanUp() {
        // nothing to cleanup
    }

    override suspend fun shouldMigrate(currentData: ByteStringStore): Boolean {
        return currentData.data.isEmpty
    }

    override suspend fun migrate(currentData: ByteStringStore): ByteStringStore {
        val renderer: ByteString = try {
            gatherOpenGLRendererInfo()
        } catch (e: Exception) {
            ByteString.EMPTY
        }

        return ByteStringStore.newBuilder()
            .setData(renderer)
            .build()
    }

    private fun gatherOpenGLRendererInfo(): ByteString = getOpenGLRendererInfo()
}