package com.unity3d.ads.core.data.datasource

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.DataStore
import com.google.protobuf.ByteString
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_UNIVERSAL_REQUEST
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.first




class UniversalRequestDataSource(
    private val universalRequestStore: DataStore<UniversalRequestStoreOuterClass.UniversalRequestStore>
) {
    suspend fun get(): UniversalRequestStoreOuterClass.UniversalRequestStore =
        universalRequestStore.data.catch { exception ->
            if (exception is CorruptionException) {
                emit(UniversalRequestStoreOuterClass.UniversalRequestStore.getDefaultInstance())
            } else {
                throw exception
            }
        }.first()

    suspend fun set(key: String, data: ByteString) {
        universalRequestStore.updateData { currentData ->
            val dataBuilder = currentData.toBuilder()
            dataBuilder.putUniversalRequestMap(key, data)
            dataBuilder.build()
        }
    }

    suspend fun remove(key: String) {
        universalRequestStore.updateData { currentData ->
            val dataBuilder = currentData.toBuilder()
            dataBuilder.removeUniversalRequestMap(key)
            dataBuilder.build()
        }
    }
}