package com.unity3d.ads.core.domain

import com.google.protobuf.kotlin.toByteStringUtf8
import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.data.repository.TcfRepository
import gatewayprotocol.v1.HeaderBiddingTokenOuterClass.HeaderBiddingToken
import gatewayprotocol.v1.headerBiddingToken
import gatewayprotocol.v1.tokenCounters

internal class AndroidBuildHeaderBiddingToken(
    private val generateId: GetByteStringId,
    private val getClientInfo: GetClientInfo,
    private val getTimestamps: GetSharedDataTimestamps,
    private val getLimitedSessionToken: GetLimitedSessionToken,
    private val getInitializationData: GetInitializationData,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val campaignRepository: CampaignRepository,
    private val tcfRepository: TcfRepository,
    private val testDataInfo: AndroidTestDataInfo
) : BuildHeaderBiddingToken {
    override suspend fun invoke(scarSignalsCollected: Boolean): HeaderBiddingToken {
        val currentTokenCounters = sessionRepository.tokenCounters
        val sToken = sessionRepository.sessionToken

        sessionRepository.incrementTokenSequenceNumber()

        return headerBiddingToken {
            // Common fields
            tokenId = generateId()
            tokenNumber = sessionRepository.headerBiddingTokenCounter
            clientInfo = getClientInfo()
            timestamps = getTimestamps()
            sessionCounters = sessionRepository.sessionCounters
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            val piiData = deviceInfoRepository.piiData
            if (!piiData.advertisingId.isEmpty || !piiData.openAdvertisingTrackingId.isEmpty) pii = piiData
            campaignState = campaignRepository.getCampaignState()
            tcfRepository.tcfString?.let { tcf = it.toByteStringUtf8() }
            this.scarSignalsCollected = scarSignalsCollected
            // Specific fields
            if (sToken.isEmpty) {
                if (sessionRepository.gameId?.isNotEmpty() == true) {
                    // Init Token
                    initializationData = getInitializationData()
                } else {
                    // Limited Token
                    limitedSessionToken = getLimitedSessionToken()
                }
                staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            } else {
                // Full Session
                sessionToken = sessionRepository.sessionToken
                staticDeviceInfo = deviceInfoRepository.cachedStaticDeviceInfo()
            }
            testData = testDataInfo()
            tokenCounters = tokenCounters {
                seq = currentTokenCounters.seq
                wins = currentTokenCounters.wins
                starts = currentTokenCounters.starts
            }
        }
    }
}