package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.manager.SDKPropertiesManager
import com.unity3d.ads.core.data.model.InitializationState
import com.unity3d.ads.core.data.model.toLegacy
import com.unity3d.ads.core.data.repository.SessionRepository


class CommonSetInitializationState(
    private val sessionRepository: SessionRepository,
    private val sdkPropertiesManager: SDKPropertiesManager
) : SetInitializationState {
    override fun invoke(state: InitializationState, legacy: Boolean) {
        if (legacy) {
            sdkPropertiesManager.setInitializeState(state.toLegacy())
        } else {
            sessionRepository.initializationState = state
        }
    }
}