package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.ExposedFunctionLocation.ATTRIBUTION_REGISTER_CLICK
import com.unity3d.ads.adplayer.ExposedFunctionLocation.ATTRIBUTION_REGISTER_VIEW
import com.unity3d.ads.adplayer.ExposedFunctionLocation.DOWNLOAD
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_AD_CONTEXT
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_ALLOWED_PII
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_CONNECTION_TYPE
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_DEVICE_MAX_VOLUME
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_DEVICE_VOLUME
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_PRIVACY
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_PRIVACY_FSM
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_SCREEN_HEIGHT
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_SCREEN_WIDTH
import com.unity3d.ads.adplayer.ExposedFunctionLocation.GET_SESSION_TOKEN
import com.unity3d.ads.adplayer.ExposedFunctionLocation.HEADER_BIDDING_TOKEN_INCREMENT_STARTS
import com.unity3d.ads.adplayer.ExposedFunctionLocation.HEADER_BIDDING_TOKEN_INCREMENT_WINS
import com.unity3d.ads.adplayer.ExposedFunctionLocation.HEADER_BIDDING_TOKEN_RESET
import com.unity3d.ads.adplayer.ExposedFunctionLocation.INCREMENT_BANNER_IMPRESSION_COUNT
import com.unity3d.ads.adplayer.ExposedFunctionLocation.IS_ATTRIBUTION_AVAILABLE
import com.unity3d.ads.adplayer.ExposedFunctionLocation.IS_FILE_CACHED
import com.unity3d.ads.adplayer.ExposedFunctionLocation.LOAD_SCAR_AD
import com.unity3d.ads.adplayer.ExposedFunctionLocation.MARK_CAMPAIGN_STATE_SHOWN
import com.unity3d.ads.adplayer.ExposedFunctionLocation.OM_FINISH_SESSION
import com.unity3d.ads.adplayer.ExposedFunctionLocation.OM_GET_DATA
import com.unity3d.ads.adplayer.ExposedFunctionLocation.OM_IMPRESSION
import com.unity3d.ads.adplayer.ExposedFunctionLocation.OM_START_SESSION
import com.unity3d.ads.adplayer.ExposedFunctionLocation.OPEN_URL
import com.unity3d.ads.adplayer.ExposedFunctionLocation.REFRESH_AD_DATA
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SEND_DIAGNOSTIC_EVENT
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SEND_OPERATIVE_EVENT
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SEND_PRIVACY_UPDATE_REQUEST
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SET_ALLOWED_PII
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SET_ORIENTATION
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SET_PRIVACY
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SET_PRIVACY_FSM
import com.unity3d.ads.adplayer.ExposedFunctionLocation.SHOW_SCAR_AD
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_CLEAR
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_DELETE
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_GET
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_GET_KEYS
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_READ
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_SET
import com.unity3d.ads.adplayer.ExposedFunctionLocation.STORAGE_WRITE
import com.unity3d.ads.adplayer.ExposedFunctionLocation.UPDATE_TRACKING_TOKEN
import com.unity3d.ads.adplayer.Invocation
import com.unity3d.ads.core.data.model.AdData
import com.unity3d.ads.core.data.model.AdDataRefreshToken
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.ImpressionConfig
import com.unity3d.ads.core.domain.exposure.attributionRegisterClick
import com.unity3d.ads.core.domain.exposure.attributionRegisterView
import com.unity3d.ads.core.domain.exposure.clearStorage
import com.unity3d.ads.core.domain.exposure.deleteStorage
import com.unity3d.ads.core.domain.exposure.download
import com.unity3d.ads.core.domain.exposure.getAdContext
import com.unity3d.ads.core.domain.exposure.getAllowedPii
import com.unity3d.ads.core.domain.exposure.getConnectionType
import com.unity3d.ads.core.domain.exposure.getDeviceMaxVolume
import com.unity3d.ads.core.domain.exposure.getDeviceVolume
import com.unity3d.ads.core.domain.exposure.getKeysStorage
import com.unity3d.ads.core.domain.exposure.getPrivacy
import com.unity3d.ads.core.domain.exposure.getPrivacyFsm
import com.unity3d.ads.core.domain.exposure.getScreenHeight
import com.unity3d.ads.core.domain.exposure.getScreenWidth
import com.unity3d.ads.core.domain.exposure.getSessionToken
import com.unity3d.ads.core.domain.exposure.getStorage
import com.unity3d.ads.core.domain.exposure.hbTokenIncrementStarts
import com.unity3d.ads.core.domain.exposure.hbTokenIncrementWins
import com.unity3d.ads.core.domain.exposure.hbTokenReset
import com.unity3d.ads.core.domain.exposure.incrementBannerImpressionCount
import com.unity3d.ads.core.domain.exposure.isAttributionAvailable
import com.unity3d.ads.core.domain.exposure.isFileCached
import com.unity3d.ads.core.domain.exposure.loadScarAd
import com.unity3d.ads.core.domain.exposure.markCampaignStateShown
import com.unity3d.ads.core.domain.exposure.omFinishSession
import com.unity3d.ads.core.domain.exposure.omGetData
import com.unity3d.ads.core.domain.exposure.omImpression
import com.unity3d.ads.core.domain.exposure.omStartSession
import com.unity3d.ads.core.domain.exposure.openUrl
import com.unity3d.ads.core.domain.exposure.readStorage
import com.unity3d.ads.core.domain.exposure.refreshAdData
import com.unity3d.ads.core.domain.exposure.sendDiagnosticEvent
import com.unity3d.ads.core.domain.exposure.sendOperativeEvent
import com.unity3d.ads.core.domain.exposure.sendPrivacyUpdateRequest
import com.unity3d.ads.core.domain.exposure.setAllowedPii
import com.unity3d.ads.core.domain.exposure.setOrientation
import com.unity3d.ads.core.domain.exposure.setPrivacy
import com.unity3d.ads.core.domain.exposure.setPrivacyFsm
import com.unity3d.ads.core.domain.exposure.setStorage
import com.unity3d.ads.core.domain.exposure.showScarAd
import com.unity3d.ads.core.domain.exposure.updateTrackingToken
import com.unity3d.ads.core.domain.exposure.writeStorage
import com.unity3d.services.core.di.IServiceComponent
import com.unity3d.services.core.di.get
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.flow.onSubscription

internal class HandleInvocationsFromAdViewer : IServiceComponent {
    suspend operator fun invoke(
        onInvocations: SharedFlow<Invocation>,
        adData: String,
        adDataRefreshToken: String,
        impressionConfig: String,
        adObject: AdObject,
        onSubscription: suspend () -> Unit,
    ): Flow<Invocation> {
        val adDataObject = AdData(adData)
        val impressionConfigObject = ImpressionConfig(impressionConfig)
        val adDataRefreshTokenObject = AdDataRefreshToken(adDataRefreshToken)

        val definition = mapOf(
            GET_AD_CONTEXT to { getAdContext(get(),adDataObject,impressionConfigObject,adDataRefreshTokenObject,get(),adObject) },
            GET_CONNECTION_TYPE to { getConnectionType(get()) },
            GET_DEVICE_VOLUME to { getDeviceVolume(get()) },
            GET_DEVICE_MAX_VOLUME to { getDeviceMaxVolume(get()) },
            GET_SCREEN_HEIGHT to { getScreenHeight(get()) },
            GET_SCREEN_WIDTH to { getScreenWidth(get()) },
            OPEN_URL to { openUrl(get()) },
            SET_ORIENTATION to { setOrientation(adObject) },
            SEND_OPERATIVE_EVENT to { sendOperativeEvent(get(),adObject) },
            STORAGE_WRITE to { writeStorage() },
            STORAGE_READ to { readStorage() },
            STORAGE_DELETE to { deleteStorage() },
            STORAGE_CLEAR to { clearStorage() },
            STORAGE_GET_KEYS to { getKeysStorage() },
            STORAGE_GET to { getStorage() },
            STORAGE_SET to { setStorage() },
            GET_PRIVACY_FSM to { getPrivacyFsm(get()) },
            SET_PRIVACY_FSM to { setPrivacyFsm(get()) },
            GET_PRIVACY to { getPrivacy(get()) },
            SET_PRIVACY to { setPrivacy(get()) },
            GET_ALLOWED_PII to { getAllowedPii(get()) },
            SET_ALLOWED_PII to { setAllowedPii(get()) },
            GET_SESSION_TOKEN to { getSessionToken(get()) },
            MARK_CAMPAIGN_STATE_SHOWN to { markCampaignStateShown(get(),adObject) },
            REFRESH_AD_DATA to { refreshAdData(get(),adObject) },
            UPDATE_TRACKING_TOKEN to { updateTrackingToken(adObject) },
            SEND_PRIVACY_UPDATE_REQUEST to { sendPrivacyUpdateRequest(get()) },
            SEND_DIAGNOSTIC_EVENT to { sendDiagnosticEvent(get(),adObject) },
            INCREMENT_BANNER_IMPRESSION_COUNT to { incrementBannerImpressionCount(get()) },
            DOWNLOAD to { download(get(),adObject) },
            IS_FILE_CACHED to { isFileCached(get()) },
            OM_START_SESSION to { omStartSession(get(),adObject) },
            OM_FINISH_SESSION to { omFinishSession(get(),adObject) },
            OM_IMPRESSION to { omImpression(get(),adObject) },
            OM_GET_DATA to { omGetData(get()) },
            IS_ATTRIBUTION_AVAILABLE to { isAttributionAvailable(get()) },
            ATTRIBUTION_REGISTER_VIEW to { attributionRegisterView(get(),adObject) },
            ATTRIBUTION_REGISTER_CLICK to { attributionRegisterClick(get(),adObject) },
            LOAD_SCAR_AD to { loadScarAd(get(), adObject) },
            SHOW_SCAR_AD to { showScarAd() },
            HEADER_BIDDING_TOKEN_INCREMENT_WINS to { hbTokenIncrementWins(get()) },
            HEADER_BIDDING_TOKEN_INCREMENT_STARTS to { hbTokenIncrementStarts(get()) },
            HEADER_BIDDING_TOKEN_RESET to { hbTokenReset(get()) },
        )

        return onInvocations
            .onSubscription { onSubscription() }
            .onEach {
                val exposedFunction = definition[it.location]?.invoke() ?: return@onEach

                it.handle { exposedFunction(it.parameters) }
            }
    }

    companion object {
        const val KEY_AD_DATA = "adData"
        const val KEY_AD_DATA_REFRESH_TOKEN = "adDataRefreshToken"
        const val KEY_TRACKING_TOKEN = "trackingToken"
        const val KEY_IMPRESSION_CONFIG = "impressionConfig"
        const val KEY_NATIVE_CONTEXT = "nativeContext"
        const val KEY_LOAD_OPTIONS = "loadOptions"
        const val KEY_PACKAGE_NAME = "packageName"
        const val KEY_DOWNLOAD_URL = "url"
        const val KEY_DOWNLOAD_PRIORITY = "priority"
        const val KEY_OMID = "openMeasurement"
        const val KEY_OMJS_SESSION = "sessionFilePath"
        const val KEY_OMJS_SERVICE = "serviceFilePath"
        const val KEY_OM_VERSION = "version"
        const val KEY_OM_PARTNER = "partnerName"
        const val KEY_OM_PARTNER_VERSION = "partnerVersion"
        const val KEY_PRIVACY_UPDATE_CONTENT = "content"
        const val KEY_PRIVACY_UPDATE_VERSION = "version"
        const val KEY_AD_TYPE = "type"
        const val KEY_PLACEMENT_ID = "placementId"
        const val KEY_AD_UNIT_ID = "adUnitId"
        const val KEY_AD_STRING = "adString"
        const val KEY_QUERY_ID = "queryId"
        const val KEY_VIDEO_LENGTH = "videoLength"
        const val KEY_IS_HEADER_BIDDING = "isHeaderBidding"
    }
}