/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.core.configuration.AlternativeFlowReader;
import com.unity3d.ads.core.data.model.Listeners;
import com.unity3d.services.UnityAdsSDK;
import com.unity3d.services.UnityServices;
import com.unity3d.services.ads.IUnityAds;
import com.unity3d.services.ads.gmascar.managers.BiddingBaseManager;
import com.unity3d.services.ads.gmascar.managers.BiddingManagerFactory;
import com.unity3d.services.ads.operation.load.LoadModule;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.ads.operation.show.ShowModule;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInvoker;
import org.jetbrains.annotations.NotNull;

public final class UnityAdsImplementation
implements IUnityAds {
    private static Configuration configuration = null;
    private static final WebViewBridgeInvoker webViewBridgeInvoker = new WebViewBridgeInvoker();
    private static IUnityAds instance;

    public static IUnityAds getInstance() {
        if (instance == null) {
            instance = new UnityAdsImplementation();
        }
        return instance;
    }

    @Override
    public void initialize(Context context, String gameId, boolean testMode, IUnityAdsInitializationListener initializationListener) {
        DeviceLog.entered();
        if (this.hasInvalidContext(context)) {
            DeviceLog.error("Error while initializing Unity Services: null context, halting Unity Ads init");
            if (initializationListener != null) {
                Utilities.wrapCustomerListener(() -> initializationListener.onInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to invalid context"));
            }
            return;
        }
        UnityServices.initialize(context, gameId, testMode, initializationListener);
    }

    @Override
    public boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    @Override
    public boolean isSupported() {
        return UnityServices.isSupported();
    }

    @Override
    public String getVersion() {
        return UnityServices.getVersion();
    }

    public void show(Activity activity, String placementId) {
        this.show(activity, placementId, new UnityAdsShowOptions(), null);
    }

    public void show(Activity activity, String placementId, IUnityAdsShowListener showListener) {
        this.show(activity, placementId, new UnityAdsShowOptions(), showListener);
    }

    @Override
    public void show(@Nullable Activity activity, @Nullable String placementId, @Nullable UnityAdsShowOptions showOptions, final @Nullable IUnityAdsShowListener showListener) {
        if (activity == null || this.hasInvalidContext((Context)activity)) {
            String showErrorMessage = "Activity must not be null";
            this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, showErrorMessage);
            return;
        }
        ClientProperties.setActivity(activity);
        AlternativeFlowReader alternativeFlowReader = (AlternativeFlowReader)Utilities.getService(AlternativeFlowReader.class);
        if (alternativeFlowReader.invoke()) {
            new UnityAdsSDK().show(activity, placementId, showOptions, new Listeners(){

                @Override
                public void onLeftApplication(@NotNull String placementId) {
                }

                @Override
                public void onError(@NotNull String placementId, @NotNull UnityAds.UnityAdsShowError error2, @NotNull String message) {
                    if (showListener != null) {
                        showListener.onUnityAdsShowFailure(placementId, error2, message);
                    }
                }

                @Override
                public void onStart(@NotNull String placementId) {
                    if (showListener != null) {
                        showListener.onUnityAdsShowStart(placementId);
                    }
                }

                @Override
                public void onClick(@NotNull String placementId) {
                    if (showListener != null) {
                        showListener.onUnityAdsShowClick(placementId);
                    }
                }

                @Override
                public void onComplete(@NotNull String placementId, @NotNull UnityAds.UnityAdsShowCompletionState state) {
                    if (showListener != null) {
                        showListener.onUnityAdsShowComplete(placementId, state);
                    }
                }
            });
        } else {
            if (!this.isSupported()) {
                String showErrorMessage = "Unity Ads is not supported for this device";
                this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
                return;
            }
            if (!this.isInitialized()) {
                this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, "[UnityAds] SDK not initialized");
                return;
            }
            if (activity == null) {
                String showErrorMessage = "Activity must not be null";
                this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, showErrorMessage);
                return;
            }
            if (placementId == null) {
                this.handleShowError(showListener, "", UnityAds.UnityAdsShowError.INVALID_ARGUMENT, "[UnityAds] Placement ID cannot be null");
                return;
            }
            Configuration config2 = configuration == null ? new Configuration() : configuration;
            ShowModule.getInstance().executeAdOperation(WebViewApp.getCurrentApp(), new ShowOperationState(placementId, showListener, activity, showOptions, config2));
        }
    }

    private void handleShowError(IUnityAdsShowListener showListener, String placementId, UnityAds.UnityAdsShowError error2, String message) {
        SDKMetricsSender sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
        sdkMetricsSender.sendMetricWithInitState(AdOperationMetric.newAdShowFailure(error2, (Long)0L));
        if (showListener == null) {
            return;
        }
        showListener.onUnityAdsShowFailure(placementId, error2, message);
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        UnityServices.setDebugMode(debugMode);
    }

    @Override
    public boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    @Override
    public void load(@Nullable String placementId, @NonNull UnityAdsLoadOptions loadOptions, @Nullable IUnityAdsLoadListener listener2) {
        if (this.hasInvalidContext()) {
            DeviceLog.error("No valid Context for loading ads");
            if (listener2 != null) {
                Utilities.wrapCustomerListener(() -> listener2.onUnityAdsFailedToLoad(placementId, UnityAds.UnityAdsLoadError.INVALID_ARGUMENT, "Unity Ads SDK failed to load due to invalid context"));
            }
            return;
        }
        AlternativeFlowReader alternativeFlowReader = (AlternativeFlowReader)Utilities.getService(AlternativeFlowReader.class);
        if (alternativeFlowReader.invoke()) {
            new UnityAdsSDK().load(placementId, loadOptions, listener2, null);
        } else {
            Configuration config2 = configuration == null ? new Configuration() : configuration;
            LoadModule.getInstance().executeAdOperation(webViewBridgeInvoker, new LoadOperationState(placementId, listener2, loadOptions, config2));
        }
    }

    @Override
    @Nullable
    public String getToken() {
        if (this.hasInvalidContext()) {
            DeviceLog.error("No valid Context for getting token");
            return null;
        }
        AlternativeFlowReader alternativeFlowReader = (AlternativeFlowReader)Utilities.getService(AlternativeFlowReader.class);
        if (alternativeFlowReader.invoke()) {
            return new UnityAdsSDK().getToken();
        }
        TokenStorage tokenStorage = (TokenStorage)Utilities.getService(TokenStorage.class);
        String token2 = tokenStorage.getToken();
        if (token2 == null || token2.isEmpty()) {
            return null;
        }
        Configuration config2 = configuration == null ? new ConfigurationReader().getCurrentConfiguration() : configuration;
        BiddingBaseManager manager = BiddingManagerFactory.getInstance().createManager(null, config2.getExperiments());
        manager.start();
        return manager.getFormattedToken(token2);
    }

    @Override
    public void getToken(@Nullable IUnityAdsTokenListener listener2) {
        if (this.hasInvalidContext()) {
            DeviceLog.error("No valid Context for getting token");
            if (listener2 != null) {
                listener2.onUnityAdsTokenReady(null);
            }
            return;
        }
        AlternativeFlowReader alternativeFlowReader = (AlternativeFlowReader)Utilities.getService(AlternativeFlowReader.class);
        if (alternativeFlowReader.invoke()) {
            new UnityAdsSDK().getToken(listener2);
        } else {
            if (listener2 == null) {
                DeviceLog.info("Please provide non-null listener to UnityAds.GetToken method");
                return;
            }
            if (ClientProperties.getApplicationContext() == null) {
                Utilities.wrapCustomerListener(() -> listener2.onUnityAdsTokenReady(null));
                return;
            }
            AsyncTokenStorage asyncTokenStorage = (AsyncTokenStorage)Utilities.getService(AsyncTokenStorage.class);
            Configuration config2 = configuration == null ? new ConfigurationReader().getCurrentConfiguration() : configuration;
            BiddingBaseManager manager = BiddingManagerFactory.getInstance().createManager(listener2, config2.getExperiments());
            manager.start();
            asyncTokenStorage.getToken(manager);
        }
    }

    public static void setConfiguration(Configuration configuration) {
        UnityAdsImplementation.configuration = configuration;
    }

    private boolean hasInvalidContext(Context context) {
        if (ClientProperties.getApplicationContext() != null) {
            return false;
        }
        if (context == null) {
            return true;
        }
        if (context instanceof Application) {
            Application application = (Application)context;
            ClientProperties.setApplicationContext(context);
            ClientProperties.setApplication(application);
            return false;
        }
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            if (activity.getApplication() != null && activity.getApplicationContext() != null) {
                ClientProperties.setApplicationContext(context.getApplicationContext());
                ClientProperties.setApplication(activity.getApplication());
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean hasInvalidContext() {
        return this.hasInvalidContext(null);
    }
}

