package com.unity3d.ads.core.domain.events

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.GetByteStringId
import gatewayprotocol.v1.InitializationResponseOuterClass.AdFormat
import gatewayprotocol.v1.OperativeEventRequestOuterClass.OperativeEventRequest
import gatewayprotocol.v1.OperativeEventRequestOuterClass.OperativeEventType
import gatewayprotocol.v1.operativeEventRequest



internal class GetOperativeEventRequest(
    private val generateByteStringId: GetByteStringId,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val campaignRepository: CampaignRepository) {

    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        loadTrackingToken: ByteString,
        opportunityId: ByteString,
        additionalEventData: ByteString,
        playerServerId: String?,
        adFormat: AdFormat?
    ) : OperativeEventRequest {
        return operativeEventRequest {
            eventId = generateByteStringId()
            eventType = operativeEventType
            impressionOpportunityId = opportunityId
            trackingToken = loadTrackingToken
            additionalData = additionalEventData
            playerServerId?.let { sid = it }
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            sessionCounters = sessionRepository.sessionCounters
            campaignState = campaignRepository.getCampaignState()
            adFormat?.let { this.adFormat = it }
        }
    }
}