package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest

internal class AndroidSendDiagnosticEvent(
    private val diagnosticEventRepository: DiagnosticEventRepository,
    private val getDiagnosticEventRequest: GetDiagnosticEventRequest,
) : SendDiagnosticEvent {
    override operator fun invoke(
        event: String,
        value: Double?,
        tags: Map<String, String>?,
        intTags: Map<String, Int>?,
        adObject: AdObject?,
        tokenNumber: Int?,
    ) {
        val hb = adObject?.isHeaderBidding
        val opportunityId = adObject?.opportunityId
        val placementId = adObject?.placementId
        val adType = adObject?.adType
        val tagsWithScar = (tags?.toMutableMap() ?: mutableMapOf()).apply {
            if (adObject?.isScarAd == true) put("scar", "true")
            if (adObject?.isOfferwallAd == true) put("offerwall", "true")
        }

        val diagnosticEventRequest = getDiagnosticEventRequest(
            eventName = event,
            tags = tagsWithScar,
            intTags = intTags,
            value = value,
            hb = hb,
            opportunityId = opportunityId,
            placement = placementId,
            adType = adType,
            tokenNumber = tokenNumber,
        )
        diagnosticEventRepository.addDiagnosticEvent(diagnosticEventRequest)
    }
}