/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain.attribution;

import android.adservices.AdServicesState;
import android.adservices.measurement.MeasurementManager;
import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.os.ext.SdkExtensions;
import android.view.InputEvent;
import com.unity3d.ads.core.data.model.AdObject;
import com.unity3d.ads.core.data.repository.SessionRepository;
import com.unity3d.ads.core.extensions.ProtobufExtensionsKt;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.domain.ISDKDispatchers;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0011\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/unity3d/ads/core/domain/attribution/AndroidAttribution;", "", "context", "Landroid/content/Context;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "sessionRepository", "Lcom/unity3d/ads/core/data/repository/SessionRepository;", "(Landroid/content/Context;Lcom/unity3d/services/core/domain/ISDKDispatchers;Lcom/unity3d/ads/core/data/repository/SessionRepository;)V", "measurementManager", "Landroid/adservices/measurement/MeasurementManager;", "getMeasurementManager", "()Landroid/adservices/measurement/MeasurementManager;", "measurementManager$delegate", "Lkotlin/Lazy;", "getUri", "Landroid/net/Uri;", "baseUrl", "", "adObject", "Lcom/unity3d/ads/core/data/model/AdObject;", "isAvailable", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerClick", "url", "(Ljava/lang/String;Lcom/unity3d/ads/core/data/model/AdObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerView", "unity-ads_release"})
@SuppressLint(value={"NewApi", "MissingPermission"})
@SourceDebugExtension(value={"SMAP\nAndroidAttribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidAttribution.kt\ncom/unity3d/ads/core/domain/attribution/AndroidAttribution\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,130:1\n29#2:131\n*S KotlinDebug\n*F\n+ 1 AndroidAttribution.kt\ncom/unity3d/ads/core/domain/attribution/AndroidAttribution\n*L\n124#1:131\n*E\n"})
public final class AndroidAttribution {
    @NotNull
    private final ISDKDispatchers dispatchers;
    @NotNull
    private final SessionRepository sessionRepository;
    @NotNull
    private final Lazy measurementManager$delegate;

    public AndroidAttribution(@NotNull Context context, @NotNull ISDKDispatchers dispatchers, @NotNull SessionRepository sessionRepository) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        this.dispatchers = dispatchers;
        this.sessionRepository = sessionRepository;
        this.measurementManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MeasurementManager>(this, context){
            final /* synthetic */ AndroidAttribution this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final MeasurementManager invoke() {
                return AndroidAttribution.access$getMeasurementManager(this.this$0, this.$context);
            }
        }));
    }

    private final MeasurementManager getMeasurementManager() {
        Lazy lazy = this.measurementManager$delegate;
        return (MeasurementManager)lazy.getValue();
    }

    @Nullable
    public final Object isAvailable(@NotNull Continuation<? super Boolean> $completion) {
        Unit unit;
        if (Device.getApiLevel() < 33) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (SdkExtensions.getExtensionVersion((int)1000000) < 4) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (this.getMeasurementManager() == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        if (!AdServicesState.isAdServicesStateEnabled()) {
            return Boxing.boxBoolean((boolean)false);
        }
        Continuation<? super Boolean> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        MeasurementManager measurementManager2 = this.getMeasurementManager();
        if (measurementManager2 != null) {
            measurementManager2.getMeasurementApiStatus(ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new OutcomeReceiver<Integer, Exception>((Continuation<? super Boolean>)continuation2){
                final /* synthetic */ Continuation<Boolean> $continuation;
                {
                    this.$continuation = $continuation;
                }

                public void onResult(int status) {
                    this.$continuation.resumeWith(Result.constructor-impl((Object)(status == 1 ? 1 : 0)));
                }

                public void onError(@NotNull Exception error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)false));
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            continuation2.resumeWith(Result.constructor-impl((Object)Boxing.boxBoolean((boolean)false)));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Nullable
    public final Object registerView(@NotNull String url, @NotNull AdObject adObject2, @NotNull Continuation<? super Boolean> $completion) {
        Unit unit;
        if (this.getMeasurementManager() == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        Continuation<? super Boolean> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        MeasurementManager measurementManager2 = this.getMeasurementManager();
        if (measurementManager2 != null) {
            measurementManager2.registerSource(this.getUri(url, adObject2), null, ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new OutcomeReceiver<Object, Exception>((Continuation<? super Boolean>)continuation2){
                final /* synthetic */ Continuation<Boolean> $continuation;
                {
                    this.$continuation = $continuation;
                }

                public void onResult(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)true));
                }

                public void onError(@NotNull Exception error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)false));
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            continuation2.resumeWith(Result.constructor-impl((Object)Boxing.boxBoolean((boolean)false)));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Nullable
    public final Object registerClick(@NotNull String url, @NotNull AdObject adObject2, @NotNull Continuation<? super Boolean> $completion) {
        Unit unit;
        if (this.getMeasurementManager() == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        Object object = adObject2.getAdPlayer();
        if (object == null || (object = object.getWebViewContainer()) == null || (object = object.getLastInputEvent()) == null || (object = (InputEvent)object.getValue()) == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        InputEvent lastInputEvent = object;
        Continuation<? super Boolean> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        MeasurementManager measurementManager2 = this.getMeasurementManager();
        if (measurementManager2 != null) {
            measurementManager2.registerSource(this.getUri(url, adObject2), lastInputEvent, ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new OutcomeReceiver<Object, Exception>((Continuation<? super Boolean>)continuation2){
                final /* synthetic */ Continuation<Boolean> $continuation;
                {
                    this.$continuation = $continuation;
                }

                public void onResult(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)true));
                }

                public void onError(@NotNull Exception error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)false));
                }
            });
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            continuation2.resumeWith(Result.constructor-impl((Object)Boxing.boxBoolean((boolean)false)));
        }
        Object object2 = safeContinuation.getOrThrow();
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object2;
    }

    private final MeasurementManager getMeasurementManager(Context context) {
        if (Device.getApiLevel() < 33) {
            return null;
        }
        if (SdkExtensions.getExtensionVersion((int)1000000) < 4) {
            return null;
        }
        return (MeasurementManager)context.getSystemService(MeasurementManager.class);
    }

    private final Uri getUri(String baseUrl, AdObject adObject2) {
        String $this$toUri$iv = baseUrl;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        Uri uri2 = uri.buildUpon().appendQueryParameter("sessionToken", ProtobufExtensionsKt.toBase64$default(this.sessionRepository.getSessionToken(), false, 1, null)).appendQueryParameter("trackingToken", ProtobufExtensionsKt.toBase64$default(adObject2.getTrackingToken(), false, 1, null)).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"baseUrl.toUri()\n        \u20264())\n            .build()");
        return uri2;
    }

    public static final /* synthetic */ MeasurementManager access$getMeasurementManager(AndroidAttribution $this, Context context) {
        return $this.getMeasurementManager(context);
    }
}

