/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.os.Build;
import com.unity3d.services.ads.webplayer.WebPlayerError;
import com.unity3d.services.ads.webplayer.WebPlayerEventBridge;
import com.unity3d.services.ads.webplayer.WebPlayerSettingsCache;
import com.unity3d.services.ads.webplayer.WebPlayerView;
import com.unity3d.services.ads.webplayer.WebPlayerViewCache;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebPlayer {
    @WebViewExposed
    public static void setUrl(final String url, String viewId, WebViewCallback callback2) {
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.loadUrl(url);
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setData(final String data, final String mimeType, final String encoding, String viewId, WebViewCallback callback2) {
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.loadData(data, mimeType, encoding);
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setDataWithUrl(final String baseUrl, final String data, final String mimeType, final String encoding, String viewId, WebViewCallback callback2) {
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, null);
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setSettings(final JSONObject webSettings, final JSONObject webPlayerSettings, String viewId, WebViewCallback callback2) {
        WebPlayerSettingsCache.getInstance().addWebSettings(viewId, webSettings);
        WebPlayerSettingsCache.getInstance().addWebPlayerSettings(viewId, webPlayerSettings);
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.setSettings(webSettings, webPlayerSettings);
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setEventSettings(final JSONObject eventSettings, String viewId, WebViewCallback callback2) {
        WebPlayerSettingsCache.getInstance().addWebPlayerEventSettings(viewId, eventSettings);
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.setEventSettings(eventSettings);
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void clearSettings(String viewId, WebViewCallback callback2) {
        WebPlayerSettingsCache webPlayerSettingsCache = WebPlayerSettingsCache.getInstance();
        webPlayerSettingsCache.removeWebSettings(viewId);
        webPlayerSettingsCache.removeWebPlayerSettings(viewId);
        webPlayerSettingsCache.removeWebPlayerEventSettings(viewId);
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    webPlayerView.setSettings(new JSONObject(), new JSONObject());
                    webPlayerView.setEventSettings(new JSONObject());
                }
            });
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getErroredSettings(String viewId, WebViewCallback callback2) {
        WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Map<String, String> errors = webPlayerView.getErroredSettings();
            JSONObject retObj = new JSONObject();
            try {
                for (Map.Entry<String, String> pair : errors.entrySet()) {
                    retObj.put(pair.getKey(), (Object)pair.getValue());
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error forming JSON object", e);
            }
            callback2.invoke(retObj);
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void sendEvent(JSONArray parameters, String viewId, WebViewCallback callback2) {
        WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            webPlayerView.sendEvent(parameters);
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(WebPlayerError.WEBPLAYER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getFrame(final String callId, final String viewId, WebViewCallback callback2) {
        callback2.invoke(new Object[0]);
        final WebPlayerView webPlayerView = WebPlayerViewCache.getInstance().getWebPlayer(viewId);
        if (webPlayerView != null) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    int[] location = new int[2];
                    webPlayerView.getLocationOnScreen(location);
                    int x = location[0];
                    int y = location[1];
                    int width = webPlayerView.getWidth();
                    int height = webPlayerView.getHeight();
                    float alpha = 1.0f;
                    if (Build.VERSION.SDK_INT >= 11) {
                        alpha = webPlayerView.getAlpha();
                    }
                    WebPlayerEventBridge.sendGetFrameResponse(callId, viewId, x, y, width, height, alpha);
                }
            });
        }
    }
}

