/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.topics;

import android.adservices.topics.GetTopicsResponse;
import android.adservices.topics.Topic;
import android.annotation.SuppressLint;
import android.os.OutcomeReceiver;
import com.unity3d.services.ads.topics.TopicsErrors;
import com.unity3d.services.ads.topics.TopicsEvents;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.IEventSender;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unity3d/services/ads/topics/TopicsReceiver;", "Landroid/os/OutcomeReceiver;", "Landroid/adservices/topics/GetTopicsResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "eventSender", "Lcom/unity3d/services/core/webview/bridge/IEventSender;", "(Lcom/unity3d/services/core/webview/bridge/IEventSender;)V", "formatTopic", "Lorg/json/JSONObject;", "topic", "Landroid/adservices/topics/Topic;", "onError", "", "error", "onResult", "result", "unity-ads_defaultRelease"})
@SuppressLint(value={"NewApi", "MissingPermission"})
@SourceDebugExtension(value={"SMAP\nTopicsReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopicsReceiver.kt\ncom/unity3d/services/ads/topics/TopicsReceiver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1855#2,2:37\n*S KotlinDebug\n*F\n+ 1 TopicsReceiver.kt\ncom/unity3d/services/ads/topics/TopicsReceiver\n*L\n17#1:37,2\n*E\n"})
public final class TopicsReceiver
implements OutcomeReceiver<GetTopicsResponse, Exception> {
    @NotNull
    private final IEventSender eventSender;

    public TopicsReceiver(@NotNull IEventSender eventSender) {
        Intrinsics.checkNotNullParameter((Object)eventSender, (String)"eventSender");
        this.eventSender = eventSender;
    }

    public void onResult(@NotNull GetTopicsResponse result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        JSONArray resultArray = new JSONArray();
        List list = result2.getTopics();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.topics");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Topic it = (Topic)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            resultArray.put((Object)this.formatTopic(it));
        }
        Enum enum_ = WebViewEventCategory.TOPICS;
        Enum enum_2 = TopicsEvents.TOPICS_AVAILABLE;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)resultArray.toString(), (String)"resultArray.toString()");
        this.eventSender.sendEvent(enum_, enum_2, objectArray);
    }

    public void onError(@NotNull Exception error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        DeviceLog.debug("GetTopics exception: " + error2);
        Object[] objectArray = new Object[]{TopicsErrors.ERROR_EXCEPTION, error2.toString()};
        this.eventSender.sendEvent(WebViewEventCategory.TOPICS, TopicsEvents.NOT_AVAILABLE, objectArray);
    }

    @NotNull
    public final JSONObject formatTopic(@NotNull Topic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        JSONObject resultObject = new JSONObject();
        resultObject.put("taxonomyVersion", topic.getTaxonomyVersion());
        resultObject.put("modelVersion", topic.getModelVersion());
        resultObject.put("topicId", topic.getTopicId());
        return resultObject;
    }
}

