/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.content.pm.PackageManager;
import android.hardware.Sensor;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.DeviceError;
import com.unity3d.services.core.device.VolumeChangeMonitor;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    private static final VolumeChangeMonitor volumeChangeMonitor = (VolumeChangeMonitor)Utilities.getService(VolumeChangeMonitor.class);

    @WebViewExposed
    public static void getAdvertisingTrackingId(WebViewCallback callback2) {
        callback2.invoke(Device.getAdvertisingTrackingId());
    }

    @WebViewExposed
    public static void getLimitAdTrackingFlag(WebViewCallback callback2) {
        callback2.invoke(Device.isLimitAdTrackingEnabled());
    }

    @WebViewExposed
    public static void getOpenAdvertisingTrackingId(WebViewCallback callback2) {
        callback2.invoke(Device.getOpenAdvertisingTrackingId());
    }

    @WebViewExposed
    public static void getLimitOpenAdTrackingFlag(WebViewCallback callback2) {
        callback2.invoke(Device.isLimitOpenAdTrackingEnabled());
    }

    @WebViewExposed
    public static void getApiLevel(WebViewCallback callback2) {
        callback2.invoke(Device.getApiLevel());
    }

    @WebViewExposed
    public static void getExtensionVersion(WebViewCallback callback2) {
        callback2.invoke(Device.getExtensionVersion());
    }

    @WebViewExposed
    public static void getOsVersion(WebViewCallback callback2) {
        callback2.invoke(Device.getOsVersion());
    }

    @WebViewExposed
    public static void getManufacturer(WebViewCallback callback2) {
        callback2.invoke(Device.getManufacturer());
    }

    @WebViewExposed
    public static void getModel(WebViewCallback callback2) {
        callback2.invoke(Device.getModel());
    }

    @WebViewExposed
    public static void getScreenLayout(WebViewCallback callback2) {
        callback2.invoke(Device.getScreenLayout());
    }

    @WebViewExposed
    public static void getDisplayMetricDensity(WebViewCallback callback2) {
        callback2.invoke(Float.valueOf(Device.getDisplayMetricDensity()));
    }

    @WebViewExposed
    public static void getScreenDensity(WebViewCallback callback2) {
        callback2.invoke(Device.getScreenDensity());
    }

    @WebViewExposed
    public static void getScreenWidth(WebViewCallback callback2) {
        callback2.invoke(Device.getScreenWidth());
    }

    @WebViewExposed
    public static void getScreenHeight(WebViewCallback callback2) {
        callback2.invoke(Device.getScreenHeight());
    }

    @WebViewExposed
    public static void getTimeZone(Boolean dst, WebViewCallback callback2) {
        callback2.invoke(TimeZone.getDefault().getDisplayName(dst, 0, Locale.US));
    }

    @WebViewExposed
    public static void getTimeZoneOffset(WebViewCallback callback2) {
        callback2.invoke(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000);
    }

    @WebViewExposed
    public static void getConnectionType(WebViewCallback callback2) {
        callback2.invoke(Device.getConnectionType());
    }

    @WebViewExposed
    public static void getNetworkType(WebViewCallback callback2) {
        callback2.invoke(Device.getNetworkType());
    }

    @WebViewExposed
    public static void getNetworkMetered(WebViewCallback callback2) {
        callback2.invoke(Device.getNetworkMetered());
    }

    @WebViewExposed
    public static void getNetworkOperator(WebViewCallback callback2) {
        callback2.invoke(Device.getNetworkOperator());
    }

    @WebViewExposed
    public static void getNetworkOperatorName(WebViewCallback callback2) {
        callback2.invoke(Device.getNetworkOperatorName());
    }

    @WebViewExposed
    public static void getNetworkCountryISO(WebViewCallback callback2) {
        callback2.invoke(Device.getNetworkCountryISO());
    }

    @WebViewExposed
    public static void isRooted(WebViewCallback callback2) {
        callback2.invoke(Device.isRooted());
    }

    @WebViewExposed
    public static void isAdbEnabled(WebViewCallback callback2) {
        Boolean adbEnabled = Device.isAdbEnabled();
        if (adbEnabled != null) {
            callback2.invoke(adbEnabled);
        } else {
            callback2.error(DeviceError.COULDNT_GET_ADB_STATUS, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getPackageInfo(WebViewCallback callback2) {
        if (ClientProperties.getApplicationContext() != null) {
            String appName = ClientProperties.getAppName();
            try {
                JSONObject data = Device.getPackageInfo(ClientProperties.getApplicationContext().getPackageManager());
                callback2.invoke(data);
            }
            catch (PackageManager.NameNotFoundException e) {
                callback2.error(DeviceError.APPLICATION_INFO_NOT_AVAILABLE, appName);
            }
            catch (JSONException e) {
                callback2.error(DeviceError.JSON_ERROR, e.getMessage());
            }
        } else {
            callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getUniqueEventId(WebViewCallback callback2) {
        callback2.invoke(Device.getUniqueEventId());
    }

    @WebViewExposed
    public static void getHeadset(WebViewCallback callback2) {
        callback2.invoke(Device.isWiredHeadsetOn());
    }

    @WebViewExposed
    public static void getSystemProperty(String propertyName, String defaultValue, WebViewCallback callback2) {
        callback2.invoke(Device.getSystemProperty(propertyName, defaultValue));
    }

    @WebViewExposed
    public static void getRingerMode(WebViewCallback callback2) {
        int ringerMode = Device.getRingerMode();
        if (ringerMode > -1) {
            callback2.invoke(ringerMode);
        } else {
            switch (ringerMode) {
                case -1: {
                    callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, ringerMode);
                    break;
                }
                case -2: {
                    callback2.error(DeviceError.AUDIOMANAGER_NULL, ringerMode);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled ringerMode error: " + ringerMode);
                }
            }
        }
    }

    @WebViewExposed
    public static void getSystemLanguage(WebViewCallback callback2) {
        callback2.invoke(Locale.getDefault().toString());
    }

    @WebViewExposed
    public static void getDeviceVolume(Integer streamType, WebViewCallback callback2) {
        int volume = Device.getStreamVolume(streamType);
        if (volume > -1) {
            callback2.invoke(volume);
        } else {
            switch (volume) {
                case -1: {
                    callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, volume);
                    break;
                }
                case -2: {
                    callback2.error(DeviceError.AUDIOMANAGER_NULL, volume);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled deviceVolume error: " + volume);
                }
            }
        }
    }

    @WebViewExposed
    public static void getDeviceMaxVolume(Integer streamType, WebViewCallback callback2) {
        int maxVolume = Device.getStreamMaxVolume(streamType);
        if (maxVolume > -1) {
            callback2.invoke(maxVolume);
        } else {
            switch (maxVolume) {
                case -1: {
                    callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, maxVolume);
                    break;
                }
                case -2: {
                    callback2.error(DeviceError.AUDIOMANAGER_NULL, maxVolume);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled deviceMaxVolume error: " + maxVolume);
                }
            }
        }
    }

    @WebViewExposed
    public static void registerVolumeChangeListener(Integer streamType, WebViewCallback callback2) {
        volumeChangeMonitor.registerVolumeChangeListener(streamType);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void unregisterVolumeChangeListener(Integer streamType, WebViewCallback callback2) {
        volumeChangeMonitor.unregisterVolumeChangeListener(streamType);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getScreenBrightness(WebViewCallback callback2) {
        int screenBrightness = Device.getScreenBrightness();
        if (screenBrightness > -1) {
            callback2.invoke(screenBrightness);
        } else {
            switch (screenBrightness) {
                case -1: {
                    callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, screenBrightness);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled screenBrightness error: " + screenBrightness);
                }
            }
        }
    }

    private static StorageType getStorageTypeFromString(String storageType) {
        StorageType storage;
        try {
            storage = StorageType.valueOf(storageType);
        }
        catch (IllegalArgumentException e) {
            DeviceLog.exception("Illegal argument: " + storageType, e);
            return null;
        }
        return storage;
    }

    private static File getFileForStorageType(StorageType storageType) {
        switch (storageType) {
            case INTERNAL: {
                return ClientProperties.getApplicationContext().getCacheDir();
            }
            case EXTERNAL: {
                return ClientProperties.getApplicationContext().getExternalCacheDir();
            }
        }
        DeviceLog.error("Unhandled storagetype: " + (Object)((Object)storageType));
        return null;
    }

    @WebViewExposed
    public static void getFreeSpace(String storageType, WebViewCallback callback2) {
        StorageType storage = DeviceInfo.getStorageTypeFromString(storageType);
        if (storage == null) {
            callback2.error(DeviceError.INVALID_STORAGETYPE, storageType);
            return;
        }
        long space = Device.getFreeSpace(DeviceInfo.getFileForStorageType(storage));
        if (space > -1L) {
            callback2.invoke(space);
        } else {
            callback2.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, space);
        }
    }

    @WebViewExposed
    public static void getTotalSpace(String storageType, WebViewCallback callback2) {
        StorageType storage = DeviceInfo.getStorageTypeFromString(storageType);
        if (storage == null) {
            callback2.error(DeviceError.INVALID_STORAGETYPE, storageType);
            return;
        }
        long space = Device.getTotalSpace(DeviceInfo.getFileForStorageType(storage));
        if (space > -1L) {
            callback2.invoke(space);
        } else {
            callback2.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, space);
        }
    }

    @WebViewExposed
    public static void getBatteryLevel(WebViewCallback callback2) {
        callback2.invoke(Float.valueOf(Device.getBatteryLevel()));
    }

    @WebViewExposed
    public static void getBatteryStatus(WebViewCallback callback2) {
        callback2.invoke(Device.getBatteryStatus());
    }

    @WebViewExposed
    public static void getFreeMemory(WebViewCallback callback2) {
        callback2.invoke(Device.getFreeMemory());
    }

    @WebViewExposed
    public static void getTotalMemory(WebViewCallback callback2) {
        callback2.invoke(Device.getTotalMemory());
    }

    @WebViewExposed
    public static void getGLVersion(WebViewCallback callback2) {
        String glVersion = Device.getGLVersion();
        if (glVersion != null) {
            callback2.invoke(glVersion);
        } else {
            callback2.error(DeviceError.COULDNT_GET_GL_VERSION, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getApkDigest(WebViewCallback callback2) {
        try {
            callback2.invoke(Device.getApkDigest());
        }
        catch (Exception e) {
            callback2.error(DeviceError.COULDNT_GET_DIGEST, e.toString());
        }
    }

    @WebViewExposed
    public static void getCertificateFingerprint(WebViewCallback callback2) {
        String fingerprint = Device.getCertificateFingerprint();
        if (fingerprint != null) {
            callback2.invoke(fingerprint);
        } else {
            callback2.error(DeviceError.COULDNT_GET_FINGERPRINT, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getBoard(WebViewCallback callback2) {
        callback2.invoke(Device.getBoard());
    }

    @WebViewExposed
    public static void getBootloader(WebViewCallback callback2) {
        callback2.invoke(Device.getBootloader());
    }

    @WebViewExposed
    public static void getBrand(WebViewCallback callback2) {
        callback2.invoke(Device.getBrand());
    }

    @WebViewExposed
    public static void getDevice(WebViewCallback callback2) {
        callback2.invoke(Device.getDevice());
    }

    @WebViewExposed
    public static void getHardware(WebViewCallback callback2) {
        callback2.invoke(Device.getHardware());
    }

    @WebViewExposed
    public static void getHost(WebViewCallback callback2) {
        callback2.invoke(Device.getHost());
    }

    @WebViewExposed
    public static void getProduct(WebViewCallback callback2) {
        callback2.invoke(Device.getProduct());
    }

    @WebViewExposed
    public static void getFingerprint(WebViewCallback callback2) {
        callback2.invoke(Device.getFingerprint());
    }

    @WebViewExposed
    public static void getSupportedAbis(WebViewCallback callback2) {
        JSONArray abis = new JSONArray();
        for (String abi : Device.getSupportedAbis()) {
            abis.put((Object)abi);
        }
        callback2.invoke(abis);
    }

    @WebViewExposed
    public static void getSensorList(WebViewCallback callback2) {
        JSONArray sensors = new JSONArray();
        List<Sensor> sensorList = Device.getSensorList();
        if (sensorList != null) {
            for (Sensor sensor : sensorList) {
                JSONObject sensorInfo = new JSONObject();
                try {
                    sensorInfo.put("name", (Object)sensor.getName());
                    sensorInfo.put("type", sensor.getType());
                    sensorInfo.put("vendor", (Object)sensor.getVendor());
                    sensorInfo.put("maximumRange", (double)sensor.getMaximumRange());
                    sensorInfo.put("power", (double)sensor.getPower());
                    sensorInfo.put("version", sensor.getVersion());
                    sensorInfo.put("resolution", (double)sensor.getResolution());
                    sensorInfo.put("minDelay", sensor.getMinDelay());
                }
                catch (JSONException e) {
                    callback2.error(DeviceError.JSON_ERROR, e.getMessage());
                    return;
                }
                sensors.put((Object)sensorInfo);
            }
        }
        callback2.invoke(sensors);
    }

    @WebViewExposed
    public static void getProcessInfo(WebViewCallback callback2) {
        JSONObject retObj = new JSONObject();
        Map<String, String> processInfo = Device.getProcessInfo();
        if (processInfo != null) {
            try {
                if (processInfo.containsKey("stat")) {
                    retObj.put("stat", (Object)processInfo.get("stat"));
                }
                if (processInfo.containsKey("uptime")) {
                    retObj.put("uptime", (Object)processInfo.get("uptime"));
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error while constructing process info", e);
            }
        }
        callback2.invoke(retObj);
    }

    @WebViewExposed
    public static void isUSBConnected(WebViewCallback callback2) {
        callback2.invoke(Device.isUSBConnected());
    }

    @WebViewExposed
    public static void getCPUCount(WebViewCallback callback2) {
        callback2.invoke(Device.getCPUCount());
    }

    @WebViewExposed
    public static void getUptime(WebViewCallback callback2) {
        callback2.invoke(Device.getUptime());
    }

    @WebViewExposed
    public static void getElapsedRealtime(WebViewCallback callback2) {
        callback2.invoke(Device.getElapsedRealtime());
    }

    @WebViewExposed
    public static void getBuildId(WebViewCallback callback2) {
        callback2.invoke(Device.getBuildId());
    }

    @WebViewExposed
    public static void getBuildVersionIncremental(WebViewCallback callback2) {
        callback2.invoke(Device.getBuildVersionIncremental());
    }

    @WebViewExposed
    public static void hasX264HWDecoder(WebViewCallback callback2) {
        callback2.invoke(Device.hasX264Decoder());
    }

    @WebViewExposed
    public static void hasX265HWDecoder(WebViewCallback callback2) {
        callback2.invoke(Device.hasX265Decoder());
    }

    @WebViewExposed
    public static void hasAV1HWDecoder(WebViewCallback callback2) {
        callback2.invoke(Device.hasAV1Decoder());
    }

    public static enum StorageType {
        EXTERNAL,
        INTERNAL;

    }
}

