/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.data.datasource;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.os.SystemClock;
import android.os.ext.SdkExtensions;
import android.telephony.TelephonyManager;
import android.webkit.WebSettings;
import com.google.protobuf.kotlin.DslList;
import com.unity3d.ads.core.data.datasource.AnalyticsDataSource;
import com.unity3d.ads.core.data.datasource.AndroidStaticDeviceInfoDataSource;
import com.unity3d.ads.core.data.datasource.ByteStringDataSource;
import com.unity3d.ads.core.data.datasource.StaticDeviceInfoDataSource;
import com.unity3d.ads.core.data.datasource.StoreDataSource;
import com.unity3d.ads.core.data.datasource.UnityBootConfigDataSource;
import com.unity3d.ads.core.data.model.StorageType;
import com.unity3d.ads.core.utils.GetMemoryValueFromStringKt;
import com.unity3d.ads.datastore.ByteStringStoreOuterClass;
import com.unity3d.services.core.device.AdvertisingId;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.OpenAdvertisingId;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.preferences.AndroidPreferences;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.MadeWithUnityDetector;
import com.unity3d.services.core.properties.SdkProperties;
import gatewayprotocol.v1.StaticDeviceInfoKt;
import gatewayprotocol.v1.StaticDeviceInfoOuterClass;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 n2\u00020\u0001:\u0001nB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0006\u0010\u001e\u001a\u00020\u0010J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0010H\u0002J\u0013\u0010%\u001a\u0004\u0018\u00010\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0010J\u0006\u0010(\u001a\u00020\u0010J\u0006\u0010)\u001a\u00020\u0010J\b\u0010*\u001a\u0004\u0018\u00010\u0010J\b\u0010+\u001a\u0004\u0018\u00010\u0010J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020\u0010H\u0002J\b\u0010.\u001a\u00020\u0010H\u0003J\u0006\u0010/\u001a\u00020\u0010J\u0006\u00100\u001a\u00020\u0010J\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020 H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u0010H\u0002J\u0013\u00109\u001a\u0004\u0018\u00010\u0010H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\b\u0010:\u001a\u00020\u0010H\u0002J\u0006\u0010;\u001a\u00020\u0010J\u0006\u0010<\u001a\u00020\u0010J\u0011\u0010=\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\b\u0010>\u001a\u00020\u0010H\u0003J\b\u0010?\u001a\u00020\u0010H\u0016J\u0010\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020\u0010H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00100EH\u0003J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J\b\u0010G\u001a\u00020\u0010H\u0002J\b\u0010H\u001a\u00020\u0010H\u0016J\b\u0010I\u001a\u00020 H\u0002J\b\u0010J\u001a\u00020\u0010H\u0002J\u0006\u0010K\u001a\u00020\u0010J\b\u0010L\u001a\u00020 H\u0002J\b\u0010M\u001a\u00020 H\u0002J\b\u0010N\u001a\u00020 H\u0002J\b\u0010O\u001a\u00020 H\u0002J\f\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u0019J\b\u0010R\u001a\u00020\u0010H\u0002J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019J\b\u0010U\u001a\u00020#H\u0016J\u0006\u0010V\u001a\u00020#J\u0010\u0010W\u001a\u00020#2\b\u0010X\u001a\u0004\u0018\u000105J\u0013\u0010Y\u001a\u0004\u0018\u00010\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\b\u0010Z\u001a\u00020 H\u0002J\b\u0010[\u001a\u00020\u0010H\u0002J\b\u0010\\\u001a\u00020\u0010H\u0002J\u0006\u0010]\u001a\u00020^J\u0006\u0010_\u001a\u00020^J\b\u0010`\u001a\u00020^H\u0002J\u001a\u0010a\u001a\u00020^2\u0006\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010e\u001a\u00020^2\u0006\u0010b\u001a\u00020cH\u0003J\u0006\u0010f\u001a\u00020^J\b\u0010g\u001a\u00020^H\u0002J\u001a\u0010h\u001a\u00020^2\u0006\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010i\u001a\u00020^2\u0006\u0010b\u001a\u00020cH\u0003J\b\u0010j\u001a\u00020^H\u0002J\u0010\u0010k\u001a\u00020^2\u0006\u0010l\u001a\u00020\u0010H\u0002J\u0018\u0010m\u001a\b\u0012\u0004\u0012\u00020c0\u00192\b\u0010d\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006o"}, d2={"Lcom/unity3d/ads/core/data/datasource/AndroidStaticDeviceInfoDataSource;", "Lcom/unity3d/ads/core/data/datasource/StaticDeviceInfoDataSource;", "context", "Landroid/content/Context;", "glInfoStore", "Lcom/unity3d/ads/core/data/datasource/ByteStringDataSource;", "analyticsDataSource", "Lcom/unity3d/ads/core/data/datasource/AnalyticsDataSource;", "storeDataSource", "Lcom/unity3d/ads/core/data/datasource/StoreDataSource;", "unityBootConfigDataSource", "Lcom/unity3d/ads/core/data/datasource/UnityBootConfigDataSource;", "(Landroid/content/Context;Lcom/unity3d/ads/core/data/datasource/ByteStringDataSource;Lcom/unity3d/ads/core/data/datasource/AnalyticsDataSource;Lcom/unity3d/ads/core/data/datasource/StoreDataSource;Lcom/unity3d/ads/core/data/datasource/UnityBootConfigDataSource;)V", "DEBUG_CERT", "Ljavax/security/auth/x500/X500Principal;", "analyticsUserId", "", "getAnalyticsUserId", "()Ljava/lang/String;", "getContext", "()Landroid/content/Context;", "staticDeviceInfo", "Lgatewayprotocol/v1/StaticDeviceInfoOuterClass$StaticDeviceInfo;", "fetch", "additionalStores", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchAndroidStaticDeviceInfo", "Lgatewayprotocol/v1/StaticDeviceInfoOuterClass$StaticDeviceInfo$Android;", "fetchCached", "getAdvertisingTrackingId", "getApiLevel", "", "getAppName", "getAppStartTime", "", "getAppVersion", "getAuid", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBoard", "getBootloader", "getBrand", "getBuildId", "getBuildVersionIncremental", "getCPUCount", "getCPUModel", "getCertificateFingerprint", "getDevice", "getDisplay", "getDisplayMetricDensity", "", "getExtensionVersion", "getFileForStorageType", "Ljava/io/File;", "storageType", "Lcom/unity3d/ads/core/data/model/StorageType;", "getFingerprint", "getGPUModel", "getGameId", "getHardware", "getHost", "getIdfi", "getInstallerPackageName", "getManufacturer", "getMemoryInfo", "infoType", "Lcom/unity3d/services/core/device/Device$MemoryInfoType;", "getModel", "getNewAbiList", "Ljava/util/ArrayList;", "getOldAbiList", "getOpenAdvertisingTrackingId", "getOsVersion", "getPhoneType", "getPlatform", "getProduct", "getScreenDensity", "getScreenHeight", "getScreenLayout", "getScreenWidth", "getSensorList", "Landroid/hardware/Sensor;", "getSimOperator", "getStores", "getSupportedAbis", "getSystemBootTime", "getTotalMemory", "getTotalSpace", "file", "getUnityBuildGuid", "getVersionCode", "getVersionName", "getWebViewUserAgent", "hasX264Decoder", "", "hasX265Decoder", "isAppDebuggable", "isHardwareAccelerated", "codecInfo", "Landroid/media/MediaCodecInfo;", "mimeType", "isHardwareAcceleratedV29", "isLimitOpenAdTrackingEnabled", "isRooted", "isSoftwareOnly", "isSoftwareOnlyV29", "isTestMode", "searchPathForBinary", "binary", "selectAllDecodeCodecs", "Companion", "unity-ads_defaultRelease"})
@SourceDebugExtension(value={"SMAP\nAndroidStaticDeviceInfoDataSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidStaticDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidStaticDeviceInfoDataSource\n+ 2 StaticDeviceInfoKt.kt\ngatewayprotocol/v1/StaticDeviceInfoKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 StaticDeviceInfoKt.kt\ngatewayprotocol/v1/StaticDeviceInfoKt$Dsl\n+ 5 StaticDeviceInfoKt.kt\ngatewayprotocol/v1/StaticDeviceInfoKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,846:1\n10#2:847\n1444#2:851\n1#3:848\n1#3:852\n1#3:856\n1#3:857\n369#4,2:849\n369#4,2:853\n589#5:855\n731#6,9:858\n37#7,2:867\n*S KotlinDebug\n*F\n+ 1 AndroidStaticDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidStaticDeviceInfoDataSource\n*L\n72#1:847\n103#1:851\n72#1:848\n103#1:852\n118#1:856\n85#1:849,2\n106#1:853,2\n118#1:855\n314#1:858,9\n315#1:867,2\n*E\n"})
public final class AndroidStaticDeviceInfoDataSource
implements StaticDeviceInfoDataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ByteStringDataSource glInfoStore;
    @NotNull
    private final AnalyticsDataSource analyticsDataSource;
    @NotNull
    private final StoreDataSource storeDataSource;
    @NotNull
    private final UnityBootConfigDataSource unityBootConfigDataSource;
    @NotNull
    private final X500Principal DEBUG_CERT;
    @NotNull
    private StaticDeviceInfoOuterClass.StaticDeviceInfo staticDeviceInfo;
    @NotNull
    public static final String ALGORITHM_SHA1 = "SHA-1";
    @NotNull
    public static final String CERTIFICATE_TYPE_X509 = "X.509";
    @NotNull
    public static final String STORE_GOOGLE = "google";
    @NotNull
    public static final String PLATFORM_ANDROID = "android";
    @NotNull
    public static final String APP_VERSION_FAKE = "FakeVersionName";
    @NotNull
    public static final String BINARY_SU = "su";
    @NotNull
    public static final String ENVIRONMENT_VARIABLE_PATH = "PATH";

    /*
     * WARNING - void declaration
     */
    public AndroidStaticDeviceInfoDataSource(@NotNull Context context, @NotNull ByteStringDataSource glInfoStore, @NotNull AnalyticsDataSource analyticsDataSource, @NotNull StoreDataSource storeDataSource, @NotNull UnityBootConfigDataSource unityBootConfigDataSource) {
        void $this$plusAssign$iv;
        void this_$iv;
        void $this$_init__u24lambda_u240;
        StaticDeviceInfoKt.Dsl dsl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)glInfoStore, (String)"glInfoStore");
        Intrinsics.checkNotNullParameter((Object)analyticsDataSource, (String)"analyticsDataSource");
        Intrinsics.checkNotNullParameter((Object)storeDataSource, (String)"storeDataSource");
        Intrinsics.checkNotNullParameter((Object)unityBootConfigDataSource, (String)"unityBootConfigDataSource");
        this.context = context;
        this.glInfoStore = glInfoStore;
        this.analyticsDataSource = analyticsDataSource;
        this.storeDataSource = storeDataSource;
        this.unityBootConfigDataSource = unityBootConfigDataSource;
        this.DEBUG_CERT = new X500Principal("CN=Android Debug,O=Android,C=US");
        boolean bl = false;
        StaticDeviceInfoOuterClass.StaticDeviceInfo.Builder builder = StaticDeviceInfoOuterClass.StaticDeviceInfo.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        StaticDeviceInfoKt.Dsl $this$staticDeviceInfo_u24lambda_u240$iv = dsl = StaticDeviceInfoKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        StaticDeviceInfoKt.Dsl dsl2 = $this$staticDeviceInfo_u24lambda_u240$iv;
        AndroidStaticDeviceInfoDataSource androidStaticDeviceInfoDataSource = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u240.setBundleId(this.getAppName());
        $this$_init__u24lambda_u240.setBundleVersion(this.getAppVersion());
        $this$_init__u24lambda_u240.setAppDebuggable(this.isAppDebuggable());
        $this$_init__u24lambda_u240.setRooted(this.isRooted());
        $this$_init__u24lambda_u240.setOsVersion(this.getOsVersion());
        $this$_init__u24lambda_u240.setDeviceMake(this.getManufacturer());
        $this$_init__u24lambda_u240.setDeviceModel(this.getModel());
        $this$_init__u24lambda_u240.setWebviewUa(this.getWebViewUserAgent());
        $this$_init__u24lambda_u240.setScreenDensity(this.getScreenDensity());
        $this$_init__u24lambda_u240.setScreenWidth(this.getScreenWidth());
        $this$_init__u24lambda_u240.setScreenHeight(this.getScreenHeight());
        $this$_init__u24lambda_u240.setScreenSize(this.getScreenLayout());
        void var12_13 = $this$_init__u24lambda_u240;
        DslList<String, StaticDeviceInfoKt.Dsl.StoresProxy> dslList = $this$_init__u24lambda_u240.getStores();
        Iterable values$iv = AndroidStaticDeviceInfoDataSource.getStores$default(this, null, 1, null);
        boolean $i$f$plusAssignAllStores = false;
        this_$iv.addAllStores((DslList)$this$plusAssign$iv, values$iv);
        $this$_init__u24lambda_u240.setTotalDiskSpace(this.getTotalSpace(this.getFileForStorageType(StorageType.EXTERNAL)));
        $this$_init__u24lambda_u240.setTotalRamMemory(this.getTotalMemory());
        $this$_init__u24lambda_u240.setCpuModel(this.getCPUModel());
        $this$_init__u24lambda_u240.setCpuCount(this.getCPUCount());
        $this$_init__u24lambda_u240.setAndroid(this.fetchAndroidStaticDeviceInfo());
        $this$_init__u24lambda_u240.setMadeWithUnity(MadeWithUnityDetector.isMadeWithUnity());
        androidStaticDeviceInfoDataSource.staticDeviceInfo = dsl._build();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetch(@NotNull List<String> var1_1, @NotNull Continuation<? super StaticDeviceInfoOuterClass.StaticDeviceInfo> var2_2) {
        if (!(var2_2 instanceof fetch.1)) ** GOTO lbl-1000
        var17_3 = var2_2;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AndroidStaticDeviceInfoDataSource this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch(null, (Continuation<? super StaticDeviceInfoOuterClass.StaticDeviceInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = this.staticDeviceInfo.getGpuModel();
                if (!(var3_6 == null || var3_6.length() == 0)) {
                    return this.staticDeviceInfo;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = additionalStores;
                $continuation.label = 1;
                v0 = this.getGPUModel((Continuation<? super String>)$continuation);
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                additionalStores = (List)$continuation.L$1;
                this = (AndroidStaticDeviceInfoDataSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((var4_7 = (CharSequence)(gpu = (String)v0)) == null || var4_7.length() == 0) {
                    return this.staticDeviceInfo;
                }
                $this$copy$iv = this.staticDeviceInfo;
                $i$f$copy = false;
                v1 = $this$copy$iv.toBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this.toBuilder()");
                $this$copy_u24lambda_u241$iv = var6_9 = StaticDeviceInfoKt.Dsl.Companion._create((StaticDeviceInfoOuterClass.StaticDeviceInfo.Builder)v1);
                $i$a$-apply-StaticDeviceInfoKtKt$copy$1$iv = false;
                var9_12 = $this$copy_u24lambda_u241$iv;
                var15_13 = this;
                $i$a$-copy-AndroidStaticDeviceInfoDataSource$fetch$2 = false;
                $this$fetch_u24lambda_u241.setGpuModel(gpu);
                $this$fetch_u24lambda_u241.clearStores($this$fetch_u24lambda_u241.getStores());
                var11_15 = $this$fetch_u24lambda_u241;
                var12_16 = $this$fetch_u24lambda_u241.getStores();
                values$iv = this.getStores(additionalStores);
                $i$f$plusAssignAllStores = false;
                this_$iv.addAllStores((DslList)$this$plusAssign$iv, values$iv);
                var15_13.staticDeviceInfo = var6_9._build();
                return this.staticDeviceInfo;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public StaticDeviceInfoOuterClass.StaticDeviceInfo fetchCached() {
        return this.staticDeviceInfo;
    }

    private final StaticDeviceInfoOuterClass.StaticDeviceInfo.Android fetchAndroidStaticDeviceInfo() {
        StaticDeviceInfoKt.AndroidKt.Dsl dsl;
        StaticDeviceInfoKt this_$iv = StaticDeviceInfoKt.INSTANCE;
        boolean bl = false;
        StaticDeviceInfoOuterClass.StaticDeviceInfo.Android.Builder builder = StaticDeviceInfoOuterClass.StaticDeviceInfo.Android.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        StaticDeviceInfoKt.AndroidKt.Dsl $this$android_u24lambda_u240$iv = dsl = StaticDeviceInfoKt.AndroidKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        StaticDeviceInfoKt.AndroidKt.Dsl $this$fetchAndroidStaticDeviceInfo_u24lambda_u243 = $this$android_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setApiLevel(this.getApiLevel());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setVersionCode(this.getVersionCode());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setAndroidFingerprint(this.getFingerprint());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setAppInstaller(this.getInstallerPackageName());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setApkDeveloperSigningCertificateHash(this.getCertificateFingerprint());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildBoard(this.getBoard());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildBrand(this.getBrand());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildDevice(this.getDevice());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildDisplay(this.getDisplay());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildFingerprint(this.getFingerprint());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildHardware(this.getHardware());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildHost(this.getHost());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildBootloader(this.getBootloader());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildProduct(this.getProduct());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setExtensionVersion(this.getExtensionVersion());
        String string = this.getBuildId();
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setBuildId(it);
        }
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setPhoneType(this.getPhoneType());
        $this$fetchAndroidStaticDeviceInfo_u24lambda_u243.setSimOperator(this.getSimOperator());
        return dsl._build();
    }

    private final int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    @NotNull
    public String getOsVersion() {
        String string = Build.VERSION.RELEASE;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getManufacturer() {
        String string = Build.MANUFACTURER;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getModel() {
        String string = Build.MODEL;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final int getScreenLayout() {
        return this.context.getResources().getConfiguration().screenLayout;
    }

    @NotNull
    public final String getAdvertisingTrackingId() {
        String string = AdvertisingId.getAdvertisingTrackingId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getOpenAdvertisingTrackingId() {
        String string = OpenAdvertisingId.getOpenAdvertisingTrackingId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final boolean isLimitOpenAdTrackingEnabled() {
        return OpenAdvertisingId.getLimitedOpenAdTracking();
    }

    @Override
    @Nullable
    public Object getIdfi(@NotNull Continuation<? super String> $completion) {
        String idfi;
        String string = AndroidPreferences.getString("unityads-installinfo", "unityads-idfi");
        if (string == null) {
            string = null;
        }
        if ((idfi = string) == null) {
            idfi = UUID.randomUUID().toString();
            AndroidPreferences.setString("unityads-installinfo", "unityads-idfi", idfi);
        }
        return idfi;
    }

    @Override
    @Nullable
    public String getAnalyticsUserId() {
        return this.analyticsDataSource.getUserId();
    }

    @Override
    public long getSystemBootTime() {
        return (System.currentTimeMillis() - SystemClock.elapsedRealtime()) / (long)1000;
    }

    @Override
    @Nullable
    public Object getAuid(@NotNull Continuation<? super String> $completion) {
        String string = AndroidPreferences.getString("supersonic_shared_preferen", "auid");
        if (string == null) {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Object getUnityBuildGuid(@NotNull Continuation<? super String> $completion) {
        return this.unityBootConfigDataSource.getValue("build-guid");
    }

    private final float getDisplayMetricDensity() {
        Resources resources = this.context.getResources();
        return resources != null && (resources = resources.getDisplayMetrics()) != null ? resources.density : 0.0f;
    }

    private final int getScreenDensity() {
        Resources resources = this.context.getResources();
        return resources != null && (resources = resources.getDisplayMetrics()) != null ? resources.densityDpi : -1;
    }

    private final int getScreenWidth() {
        Resources resources = this.context.getResources();
        return resources != null && (resources = resources.getDisplayMetrics()) != null ? resources.widthPixels : -1;
    }

    private final int getScreenHeight() {
        Resources resources = this.context.getResources();
        return resources != null && (resources = resources.getDisplayMetrics()) != null ? resources.heightPixels : -1;
    }

    private final boolean isRooted() {
        boolean bl;
        try {
            bl = this.searchPathForBinary(BINARY_SU);
        }
        catch (Exception e) {
            DeviceLog.exception("Rooted check failed", e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean searchPathForBinary(String binary) {
        String[] $this$dropLastWhile$iv;
        block9: {
            block8: {
                void $this$toTypedArray$iv;
                Object object;
                int n;
                Object object2;
                Regex regex;
                String[] stringArray;
                String string = System.getenv(ENVIRONMENT_VARIABLE_PATH);
                if (string == null || (stringArray = (regex = new Regex(":")).split((CharSequence)(object2 = (CharSequence)string), n = 0)) == null) break block8;
                $this$dropLastWhile$iv = stringArray;
                boolean $i$f$dropLastWhile22 = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        object = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    object = object2 = CollectionsKt.emptyList();
                }
                if (object2 == null) break block8;
                Collection $i$f$dropLastWhile22 = (Collection)object2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                $this$dropLastWhile$iv = thisCollection$iv.toArray(new String[0]);
                if ($this$dropLastWhile$iv != null) break block9;
            }
            return false;
        }
        for (String path : $this$dropLastWhile$iv) {
            File[] pathDirFiles;
            File pathDir = new File(path);
            if (!pathDir.exists() || !pathDir.isDirectory() || (pathDirFiles = pathDir.listFiles()) == null) continue;
            for (File fileInPath : pathDirFiles) {
                if (!Intrinsics.areEqual((Object)fileInPath.getName(), (Object)binary)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated(message="This constant was deprecated in API level 28. Use GET_SIGNING_CERTIFICATES instead")
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final String getCertificateFingerprint() {
        PackageManager pm = this.context.getPackageManager();
        String pkgName = this.context.getPackageName();
        try {
            PackageInfo pinfo = pm.getPackageInfo(pkgName, 64);
            Signature[] signatures = pinfo.signatures;
            if (signatures != null && !(signatures.length == 0)) {
                CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE_X509);
                ByteArrayInputStream stream = new ByteArrayInputStream(signatures[0].toByteArray());
                Certificate certificate = cf.generateCertificate(stream);
                Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                X509Certificate cert = (X509Certificate)certificate;
                MessageDigest messageDigest = MessageDigest.getInstance(ALGORITHM_SHA1);
                byte[] publicKey = messageDigest.digest(cert.getEncoded());
                String string = Utilities.toHexString(publicKey);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(publicKey)");
                return string;
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Exception when signing certificate fingerprint", e);
        }
        return "";
    }

    @NotNull
    public final String getBoard() {
        String string = Build.BOARD;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getBootloader() {
        String string = Build.BOOTLOADER;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getBrand() {
        String string = Build.BRAND;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getDisplay() {
        String string = Build.DISPLAY;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getDevice() {
        String string = Build.DEVICE;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getHardware() {
        String string = Build.HARDWARE;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getHost() {
        String string = Build.HOST;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getProduct() {
        String string = Build.PRODUCT;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getFingerprint() {
        String string = Build.FINGERPRINT;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Deprecated(message="This method was deprecated in API level 30. use getInstallSourceInfo")
    private final String getInstallerPackageName() {
        String string = this.context.getPackageManager().getInstallerPackageName(this.context.getPackageName());
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final List<String> getSupportedAbis() {
        return this.getApiLevel() < 21 ? this.getOldAbiList() : (List)this.getNewAbiList();
    }

    @NotNull
    public final List<Sensor> getSensorList() {
        Object object = this.context.getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        SensorManager sensorManager = (SensorManager)object;
        List list = sensorManager.getSensorList(-1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sensorManager.getSensorList(Sensor.TYPE_ALL)");
        return list;
    }

    private final String getCPUModel() {
        String string;
        if (Build.VERSION.SDK_INT >= 31) {
            String string2 = Build.SOC_MODEL;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Build.SOC_MODEL\n        }");
        } else {
            String string3;
            try {
                string3 = (String)CollectionsKt.last((List)FilesKt.readLines$default((File)new File("/proc/cpuinfo"), null, (int)1, null));
            }
            catch (FileNotFoundException e) {
                DeviceLog.exception("Error reading CPU model", e);
                string3 = "";
            }
            string = string3;
        }
        return string;
    }

    private final long getCPUCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    /*
     * Unable to fully structure code
     */
    private final Object getGPUModel(Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof getGPUModel.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ AndroidStaticDeviceInfoDataSource this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AndroidStaticDeviceInfoDataSource.access$getGPUModel(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.glInfoStore.get((Continuation<? super ByteStringStoreOuterClass.ByteStringStore>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return ((ByteStringStoreOuterClass.ByteStringStore)v0).getData().toString(Charsets.UTF_8);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final String getBuildId() {
        return Build.ID;
    }

    @Nullable
    public final String getBuildVersionIncremental() {
        return Build.VERSION.INCREMENTAL;
    }

    private final List<String> getOldAbiList() {
        List abiList = new ArrayList();
        String string = Build.CPU_ABI;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CPU_ABI");
        abiList.add(string);
        String string2 = Build.CPU_ABI2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CPU_ABI2");
        abiList.add(string2);
        return abiList;
    }

    @TargetApi(value=21)
    private final ArrayList<String> getNewAbiList() {
        ArrayList<String> abiList = new ArrayList<String>();
        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
        String[] stringArray = Build.SUPPORTED_ABIS;
        abiList.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
        return abiList;
    }

    private final String getWebViewUserAgent() {
        String string;
        try {
            String string2 = WebSettings.getDefaultUserAgent((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        WebSettings.ge\u2026tUserAgent(context)\n    }");
            string = string2;
        }
        catch (Exception e) {
            DeviceLog.exception("Exception getting webview user agent", e);
            string = "";
        }
        return string;
    }

    private final int getVersionCode() {
        return 41604;
    }

    private final List<String> getStores(List<String> additionalStores) {
        return this.storeDataSource.fetchStores(additionalStores);
    }

    static /* synthetic */ List getStores$default(AndroidStaticDeviceInfoDataSource androidStaticDeviceInfoDataSource, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return androidStaticDeviceInfoDataSource.getStores(list);
    }

    private final long getAppStartTime() {
        return SdkProperties.getInitializationTimeEpoch();
    }

    private final String getVersionName() {
        return "4.16.4";
    }

    private final boolean isTestMode() {
        return SdkProperties.isTestMode();
    }

    private final String getPlatform() {
        return PLATFORM_ANDROID;
    }

    private final String getGameId() {
        String string = ClientProperties.getGameId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long getTotalMemory() {
        return this.getMemoryInfo(Device.MemoryInfoType.TOTAL_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getMemoryInfo(Device.MemoryInfoType infoType) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[infoType.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int lineNumber = n;
        String line = null;
        try {
            Closeable closeable = new RandomAccessFile("/proc/meminfo", "r");
            Throwable throwable = null;
            try {
                RandomAccessFile it = (RandomAccessFile)closeable;
                boolean bl = false;
                for (int i = 0; i < lineNumber; ++i) {
                    line = it.readLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (FileNotFoundException e) {
            DeviceLog.exception("Error reading memory info", e);
        }
        return GetMemoryValueFromStringKt.getMemoryValueFromString(line);
    }

    public final long getTotalSpace(@Nullable File file) {
        return file != null && file.exists() ? (long)MathKt.roundToInt((float)(file.getTotalSpace() / (long)1024)) : -1L;
    }

    private final File getFileForStorageType(StorageType storageType) {
        File file;
        switch (WhenMappings.$EnumSwitchMapping$1[storageType.ordinal()]) {
            case 1: {
                file = this.context.getCacheDir();
                break;
            }
            case 2: {
                file = this.context.getExternalCacheDir();
                break;
            }
            default: {
                DeviceLog.error("Unhandled storagetype: " + (Object)((Object)storageType));
                file = null;
            }
        }
        return file;
    }

    @Override
    @NotNull
    public String getAppName() {
        String string = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        return string;
    }

    private final String getAppVersion() {
        String string;
        String pkgName = this.context.getPackageName();
        PackageManager pm = this.context.getPackageManager();
        try {
            String string2 = pm.getPackageInfo((String)pkgName, (int)0).versionName == null ? APP_VERSION_FAKE : pm.getPackageInfo((String)pkgName, (int)0).versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            if (pm.get\u2026e\n            }\n        }");
            string = string2;
        }
        catch (PackageManager.NameNotFoundException e) {
            DeviceLog.exception("Error getting package info", (Exception)((Object)e));
            string = "";
        }
        return string;
    }

    private final boolean isAppDebuggable() {
        boolean debuggable = false;
        boolean couldNotGetApplicationInfo = false;
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        PackageManager pm = packageManager;
        String string = this.context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        String pkgName = string;
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(pkgName, 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"pm.getApplicationInfo(pkgName, 0)");
            ApplicationInfo appinfo = applicationInfo;
            int it = 2;
            boolean bl = false;
            appinfo.flags &= it;
            if (appinfo.flags != 0) {
                debuggable = true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            DeviceLog.exception("Could not find name", (Exception)((Object)e));
            couldNotGetApplicationInfo = true;
        }
        if (couldNotGetApplicationInfo) {
            try {
                PackageInfo pinfo = pm.getPackageInfo(pkgName, 64);
                Signature[] signatures = pinfo.signatures;
                Intrinsics.checkNotNullExpressionValue((Object)signatures, (String)"signatures");
                for (Signature signature : signatures) {
                    CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE_X509);
                    ByteArrayInputStream stream = new ByteArrayInputStream(signature.toByteArray());
                    Certificate certificate = cf.generateCertificate(stream);
                    Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                    X509Certificate cert = (X509Certificate)certificate;
                    debuggable = Intrinsics.areEqual((Object)cert.getSubjectX500Principal(), (Object)this.DEBUG_CERT);
                    if (!debuggable) {
                        continue;
                    }
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                DeviceLog.exception("Could not find name", (Exception)((Object)e));
            }
            catch (CertificateException e) {
                DeviceLog.exception("Certificate exception", e);
            }
        }
        return debuggable;
    }

    private final int getExtensionVersion() {
        return Build.VERSION.SDK_INT >= 30 ? SdkExtensions.getExtensionVersion((int)30) : -1;
    }

    public final boolean hasX264Decoder() {
        return !((Collection)this.selectAllDecodeCodecs("video/avc")).isEmpty();
    }

    public final boolean hasX265Decoder() {
        return !((Collection)this.selectAllDecodeCodecs("video/hevc")).isEmpty();
    }

    private final List<MediaCodecInfo> selectAllDecodeCodecs(String mimeType) {
        List result2 = new ArrayList();
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                if (!StringsKt.equals((String)types[j], (String)mimeType, (boolean)true)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)codecInfo, (String)"codecInfo");
                if (!this.isHardwareAccelerated(codecInfo, mimeType)) continue;
                result2.add(codecInfo);
            }
        }
        return result2;
    }

    private final boolean isHardwareAccelerated(MediaCodecInfo codecInfo, String mimeType) {
        return this.getApiLevel() >= 29 ? this.isHardwareAcceleratedV29(codecInfo) : !this.isSoftwareOnly(codecInfo, mimeType);
    }

    @TargetApi(value=29)
    private final boolean isHardwareAcceleratedV29(MediaCodecInfo codecInfo) {
        return codecInfo.isHardwareAccelerated();
    }

    private final boolean isSoftwareOnly(MediaCodecInfo codecInfo, String mimeType) {
        if (this.getApiLevel() >= 29) {
            return this.isSoftwareOnlyV29(codecInfo);
        }
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codecInfo.name");
        String string2 = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String codecName = string3;
        return StringsKt.startsWith$default((String)codecName, (String)"arc.", (boolean)false, (int)2, null) ? false : StringsKt.startsWith$default((String)codecName, (String)"omx.google.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.ffmpeg.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"omx.sec.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)codecName, (CharSequence)".sw.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)codecName, (Object)"omx.qcom.video.decoder.hevcswvdec") || StringsKt.startsWith$default((String)codecName, (String)"c2.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"c2.google.", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)codecName, (String)"omx.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)codecName, (String)"c2.", (boolean)false, (int)2, null);
    }

    @TargetApi(value=29)
    private final boolean isSoftwareOnlyV29(MediaCodecInfo codecInfo) {
        return codecInfo.isSoftwareOnly();
    }

    private final int getPhoneType() {
        Object object = this.context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager telephonyManager = (TelephonyManager)object;
        return telephonyManager.getPhoneType();
    }

    private final String getSimOperator() {
        Object object = this.context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        TelephonyManager telephonyManager = (TelephonyManager)object;
        String string = telephonyManager.getSimOperator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"telephonyManager.simOperator");
        return string;
    }

    public static final /* synthetic */ Object access$getGPUModel(AndroidStaticDeviceInfoDataSource $this, Continuation $completion) {
        return $this.getGPUModel((Continuation<? super String>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unity3d/ads/core/data/datasource/AndroidStaticDeviceInfoDataSource$Companion;", "", "()V", "ALGORITHM_SHA1", "", "APP_VERSION_FAKE", "BINARY_SU", "CERTIFICATE_TYPE_X509", "ENVIRONMENT_VARIABLE_PATH", "PLATFORM_ANDROID", "STORE_GOOGLE", "unity-ads_defaultRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Device.MemoryInfoType.values().length];
            try {
                nArray[Device.MemoryInfoType.TOTAL_MEMORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Device.MemoryInfoType.FREE_MEMORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.INTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.EXTERNAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

