/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.bridges.billingclient.common;

import android.content.Context;
import com.unity3d.services.core.reflection.GenericBridge;
import com.unity3d.services.store.gpbl.BillingResultResponseCode;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.billingclient.IBillingClient;
import com.unity3d.services.store.gpbl.proxies.BillingClientStateListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchaseHistoryResponseListenerProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class BillingClientBridgeCommon
extends GenericBridge
implements IBillingClient {
    protected static final String newBuilderMethodName = "newBuilder";
    protected static final String startConnectionMethodName = "startConnection";
    protected static final String endConnectionMethodName = "endConnection";
    protected static final String queryPurchaseHistoryAsyncMethodName = "queryPurchaseHistoryAsync";
    protected static final String isFeatureSupportedMethodName = "isFeatureSupported";
    protected static final String isReadyMethodName = "isReady";
    protected final Object _billingClientInternalInstance;
    private static final Map<String, Class<?>[]> staticMethods = new HashMap<String, Class<?>[]>(){
        {
            this.put(BillingClientBridgeCommon.newBuilderMethodName, new Class[]{Context.class});
        }
    };

    public BillingClientBridgeCommon(Object billingClientInternalInstance, Map<String, Class<?>[]> functionAndParameters) throws ClassNotFoundException {
        super(BillingClientBridgeCommon.appendFunctionAnParameters(functionAndParameters));
        this._billingClientInternalInstance = billingClientInternalInstance;
    }

    private static Map<String, Class<?>[]> appendFunctionAnParameters(Map<String, Class<?>[]> functionAndParameters) throws ClassNotFoundException {
        functionAndParameters.putAll((Map<String, Class<?>[]>)new HashMap<String, Class<?>[]>(){
            {
                this.put(BillingClientBridgeCommon.newBuilderMethodName, new Class[]{Context.class});
                this.put(BillingClientBridgeCommon.startConnectionMethodName, new Class[]{BillingClientStateListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridgeCommon.endConnectionMethodName, new Class[0]);
                this.put(BillingClientBridgeCommon.queryPurchaseHistoryAsyncMethodName, new Class[]{String.class, PurchaseHistoryResponseListenerProxy.getProxyListenerClass()});
                this.put(BillingClientBridgeCommon.isFeatureSupportedMethodName, new Class[]{String.class});
                this.put(BillingClientBridgeCommon.isReadyMethodName, new Class[0]);
            }
        });
        return functionAndParameters;
    }

    @Override
    protected String getClassName() {
        return "com.android.billingclient.api.BillingClient";
    }

    protected static Class<?> getClassForBridge() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.BillingClient");
    }

    @Override
    public void startConnection(BillingClientStateListenerProxy billingClientStateListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(startConnectionMethodName, this._billingClientInternalInstance, billingClientStateListenerProxy.getProxyInstance());
    }

    public void endConnection() {
        this.callVoidMethod(endConnectionMethodName, this._billingClientInternalInstance, new Object[0]);
    }

    @Override
    public BillingResultResponseCode isFeatureSupported(String purchaseType) {
        Object billingResult = this.callNonVoidMethod(isFeatureSupportedMethodName, this._billingClientInternalInstance, purchaseType);
        BillingResultBridge billingResultBridge = new BillingResultBridge(billingResult);
        return billingResultBridge.getResponseCode();
    }

    @Override
    public boolean isReady() {
        return (Boolean)this.callNonVoidMethod(isReadyMethodName, this._billingClientInternalInstance, new Object[0]);
    }

    @Override
    public void queryPurchaseHistoryAsync(String skuType, PurchaseHistoryResponseListenerProxy purchaseHistoryResponseListenerProxy) throws ClassNotFoundException {
        this.callVoidMethod(queryPurchaseHistoryAsyncMethodName, this._billingClientInternalInstance, skuType, purchaseHistoryResponseListenerProxy.getProxyInstance());
    }

    protected static Object callNonVoidStaticMethod(String methodName, Object ... parameters) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = BillingClientBridgeCommon.getClassForBridge().getMethod(methodName, staticMethods.get(methodName));
        return method.invoke(null, parameters);
    }
}

