package com.unity3d.services

import com.unity3d.ads.BuildConfig

object UnityAdsConstants {

    object Messages {
        const val MSG_UNITY_BASE = "[Unity Ads] "
        const val MSG_INTERNAL_ERROR = "Internal error"
    }

    object Timeout {
        const val INIT_TIMEOUT_MS = 10000L
    }

    object RequestPolicy {
        const val RETRY_MAX_DURATION = 15000
        const val RETRY_WAIT_BASE = 500
        const val RETRY_JITTER_PCT = 0.1f
        const val CONNECT_TIMEOUT_MS = 10000
        const val READ_TIMEOUT_MS = 10000
        const val WRITE_TIMEOUT_MS = 10000
        const val SHOULD_STORE_LOCALLY = false
    }

    object SharedFlow {
        const val REPLAY = 10
        const val EXTRA_CAPACITY = 10
    }

    object DefaultUrls {
        const val GATEWAY_URL = "https://gateway.unityads.unity3d.com/v1"
        const val WEBVIEW_DOMAIN = "config.unityads.unity3d.com"
        const val ASSET_DOMAIN = "cdn-creatives-cf-prd.acquire.unity3dusercontent.com"
        const val WEBVIEW_ASSET_PATH = "/unity-ads-sdk-webview/"
        const val AD_ASSET_PATH = "/"
        const val AD_MARKUP_URL = "https://gateway.unityads.unity3d.com/tools/convert_ad_response_to_ad_markup"
        const val AD_PLAYER_QUERY_PARAMS = "?platform=android&"
    }

    object ClientInfo {
        const val SDK_VERSION = BuildConfig.VERSION_CODE
        const val SDK_VERSION_NAME = BuildConfig.VERSION_NAME
    }
}
