/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.mediationadapter;

import androidx.annotation.Keep;
import androidx.annotation.VisibleForTesting;
import com.unity3d.mediation.logger.Logger;
import com.unity3d.mediation.mediationadapter.AdNetwork;
import com.unity3d.mediation.mediationadapter.AdapterSummary;
import com.unity3d.mediation.mediationadapter.IMediationInitializationAdapter;
import com.unity3d.mediation.mediationadapter.MediationAdaptersProvider;
import com.unity3d.mediation.mediationadapter.ad.banner.IMediationBannerAdapter;
import com.unity3d.mediation.mediationadapter.ad.interstitial.IMediationInterstitialAdapter;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationRewardedAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010\u001cJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lcom/unity3d/mediation/mediationadapter/MediationAdaptersManager;", "", "Lcom/unity3d/mediation/mediationadapter/AdNetwork;", "key", "Lcom/unity3d/mediation/mediationadapter/MediationAdaptersProvider;", "provider", "", "registerAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;Lcom/unity3d/mediation/mediationadapter/MediationAdaptersProvider;)V", "logAdapterInfo", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)V", "adNetwork", "Lcom/unity3d/mediation/mediationadapter/IMediationInitializationAdapter;", "getInitializationAdapterForAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)Lcom/unity3d/mediation/mediationadapter/IMediationInitializationAdapter;", "Lcom/unity3d/mediation/mediationadapter/ad/interstitial/IMediationInterstitialAdapter;", "getInterstitialAdAdapterForAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)Lcom/unity3d/mediation/mediationadapter/ad/interstitial/IMediationInterstitialAdapter;", "Lcom/unity3d/mediation/mediationadapter/ad/rewarded/IMediationRewardedAdapter;", "getRewardedAdAdapterForAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)Lcom/unity3d/mediation/mediationadapter/ad/rewarded/IMediationRewardedAdapter;", "Lcom/unity3d/mediation/mediationadapter/ad/banner/IMediationBannerAdapter;", "getBannerAdapterForAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)Lcom/unity3d/mediation/mediationadapter/ad/banner/IMediationBannerAdapter;", "Lcom/unity3d/mediation/mediationadapter/AdapterSummary;", "getInfoForAdNetwork", "(Lcom/unity3d/mediation/mediationadapter/AdNetwork;)Lcom/unity3d/mediation/mediationadapter/AdapterSummary;", "clear$mediation_adapter_release", "()V", "clear", "", "mediationSdkVersion", "Ljava/lang/String;", "getMediationSdkVersion", "()Ljava/lang/String;", "setMediationSdkVersion", "(Ljava/lang/String;)V", "", "adapterProviderMap", "Ljava/util/Map;", "<init>", "mediation-adapter_release"})
@Keep
public final class MediationAdaptersManager {
    @NotNull
    public static final MediationAdaptersManager INSTANCE = new MediationAdaptersManager();
    public static String mediationSdkVersion;
    @NotNull
    private static final Map<AdNetwork, MediationAdaptersProvider> adapterProviderMap;

    private MediationAdaptersManager() {
    }

    static {
        adapterProviderMap = new LinkedHashMap<AdNetwork, MediationAdaptersProvider>();
    }

    @NotNull
    public final String getMediationSdkVersion() {
        String string = mediationSdkVersion;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mediationSdkVersion");
        throw null;
    }

    public final void setMediationSdkVersion(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        mediationSdkVersion = string2;
    }

    public final synchronized void registerAdNetwork(@NotNull AdNetwork adNetwork, @NotNull MediationAdaptersProvider mediationAdaptersProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"key");
        Intrinsics.checkNotNullParameter((Object)mediationAdaptersProvider, (String)"provider");
        adapterProviderMap.put(adNetwork, mediationAdaptersProvider);
        this.logAdapterInfo(adNetwork);
    }

    public final void logAdapterInfo(@NotNull AdNetwork object) {
        AdNetwork adNetwork = object;
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"key");
        Object object2 = ((MediationAdaptersManager)object2).getInfoForAdNetwork(adNetwork);
        object = new StringBuilder().append("Adapter info -> AdNetwork: ").append(((Enum)object).name()).append(", Adapter version: ");
        String string = object2 == null ? null : ((AdapterSummary)object2).getAdapterSDKVersion();
        object = ((StringBuilder)object).append((Object)string).append(",  AdNetwork sdk version: ");
        object2 = object2 == null ? null : ((AdapterSummary)object2).getAdNetworkSDKVersion();
        Logger.info((String)((StringBuilder)object).append(object2).toString());
    }

    @NotNull
    public final synchronized IMediationInitializationAdapter getInitializationAdapterForAdNetwork(@NotNull AdNetwork object) {
        AdNetwork adNetwork = object;
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
        Object object2 = ((MediationAdaptersManager)object2).getInfoForAdNetwork(adNetwork);
        Object object3 = adapterProviderMap.get(object);
        if (object3 != null) {
            if ((object3 = ((MediationAdaptersProvider)object3).getInitializationAdapter()) == null) {
                object = new StringBuilder().append(object).append('-');
                object2 = object2 == null ? null : ((AdapterSummary)object2).getAdapterSDKVersion();
                Object object4 = object3;
                ((IllegalArgumentException)object4)(((StringBuilder)object).append(object2).append(": Adapter not configured for Header Bidding. No action required by publisher.").toString());
                throw object4;
            }
            return object3;
        }
        throw new IllegalArgumentException(object + " Adapter not imported into app, but is configured in the project dashboard.");
    }

    @NotNull
    public final synchronized IMediationInterstitialAdapter getInterstitialAdAdapterForAdNetwork(@NotNull AdNetwork adNetwork) {
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
        Object object = adapterProviderMap.get((Object)adNetwork);
        object = object == null ? null : ((MediationAdaptersProvider)object).getInterstitialAdAdapter();
        if (object != null) {
            return object;
        }
        throw new IllegalArgumentException((Object)((Object)adNetwork) + "-adNetwork: unrecognized");
    }

    @NotNull
    public final synchronized IMediationRewardedAdapter getRewardedAdAdapterForAdNetwork(@NotNull AdNetwork adNetwork) {
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
        Object object = adapterProviderMap.get((Object)adNetwork);
        object = object == null ? null : ((MediationAdaptersProvider)object).getRewardAdAdapter();
        if (object != null) {
            return object;
        }
        throw new IllegalArgumentException((Object)((Object)adNetwork) + "-adNetwork: unrecognized");
    }

    @NotNull
    public final synchronized IMediationBannerAdapter getBannerAdapterForAdNetwork(@NotNull AdNetwork adNetwork) {
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
        Object object = adapterProviderMap.get((Object)adNetwork);
        object = object == null ? null : ((MediationAdaptersProvider)object).getBannerAdAdapter();
        if (object != null) {
            return object;
        }
        throw new IllegalArgumentException((Object)((Object)adNetwork) + "-adNetwork: unrecognized");
    }

    @Nullable
    public final synchronized AdapterSummary getInfoForAdNetwork(@NotNull AdNetwork adNetwork) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
        Object object2 = adapterProviderMap.get((Object)adNetwork);
        if (object2 == null) {
            object = object2 = null;
        } else {
            AdapterSummary adapterSummary;
            object = adapterSummary;
            Object object3 = object2;
            object2 = ((MediationAdaptersProvider)object3).getAdapterVersion();
            String string = ((MediationAdaptersProvider)object3).getAdNetworkSdkVersion();
            adapterSummary = new AdapterSummary(adNetwork, (String)object2, string);
        }
        return object;
    }

    @VisibleForTesting
    public final void clear$mediation_adapter_release() {
        adapterProviderMap.clear();
    }
}

