/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter;

import android.content.Context;
import android.util.Size;
import androidx.annotation.NonNull;
import com.unity3d.mediation.mediationadapter.IMediationInitializationListener;
import com.unity3d.mediation.mediationadapter.MediationAdapterConfiguration;
import com.unity3d.mediation.mediationadapter.ad.banner.IMediationBannerAd;
import com.unity3d.mediation.mediationadapter.ad.banner.IMediationBannerAdapter;
import com.unity3d.mediation.mediationadapter.ad.banner.IMediationBannerListener;
import com.unity3d.mediation.mediationadapter.errors.AdapterInitializationError;
import com.unity3d.mediation.mediationadapter.errors.AdapterLoadError;
import com.unity3d.mediation.unityadsadapter.unity.IUnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.IUnityBannerAd;
import com.unity3d.mediation.unityadsadapter.unity.UnityAdsSdk;

public class UnityAdsBannerAdapter
implements IMediationBannerAdapter {
    private final IUnityAdsSdk unityAdsSdk;

    public UnityAdsBannerAdapter() {
        this(UnityAdsSdk.unityAdsSdk);
    }

    UnityAdsBannerAdapter(IUnityAdsSdk unityAdsSdk) {
        this.unityAdsSdk = unityAdsSdk;
    }

    @NonNull
    public IMediationBannerAd createBannerAd(final @NonNull Context context, @NonNull Size size, @NonNull MediationAdapterConfiguration parameters) {
        final String gameId = parameters.getAdapterParameter("gameId");
        final String placementId = parameters.getAdapterParameter("placementId");
        final boolean testMode = Boolean.parseBoolean(parameters.getAdapterParameter("testMode"));
        final boolean isCoppa = this.unityAdsSdk.isCoppa(parameters);
        final IUnityBannerAd bannerAd = this.unityAdsSdk.createBanner(context, placementId, size);
        return new IMediationBannerAd(){

            public void load(final @NonNull IMediationBannerListener listener) {
                if (UnityAdsBannerAdapter.this.unityAdsSdk.isInitialized()) {
                    bannerAd.loadAd(listener);
                } else {
                    IMediationInitializationListener initializationListener = new IMediationInitializationListener(){

                        public void onInitialized() {
                            bannerAd.loadAd(listener);
                        }

                        public void onFailed(AdapterInitializationError error, String msg) {
                            listener.onFailed(AdapterLoadError.INITIALIZATION_ERROR, "UnityAds experienced a load error: " + error + " : " + msg);
                        }
                    };
                    UnityAdsBannerAdapter.this.unityAdsSdk.initialize(context, gameId, testMode, isCoppa, initializationListener);
                }
            }

            @NonNull
            public String getAdSourceInstance() {
                return placementId;
            }

            public void getAdSourceView(@NonNull IMediationBannerAd.OnBannerViewReadyListener bannerReadyListener) {
                bannerReadyListener.onBannerViewReady(bannerAd.getAdView());
            }

            public void destroy() {
                bannerAd.destroy();
            }
        };
    }
}

