/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter;

import android.content.Context;
import androidx.annotation.NonNull;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.mediation.mediationadapter.AdUnitFormat;
import com.unity3d.mediation.mediationadapter.IHeaderBiddingTokenFetchListener;
import com.unity3d.mediation.mediationadapter.IMediationInitializationAdapter;
import com.unity3d.mediation.mediationadapter.IMediationInitializationListener;
import com.unity3d.mediation.mediationadapter.MediationAdapterConfiguration;
import com.unity3d.mediation.mediationadapter.errors.AdapterInitializationError;
import com.unity3d.mediation.mediationadapter.errors.HeaderBiddingTokenError;
import com.unity3d.mediation.unityadsadapter.unity.IUnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.UnityAdsSdk;

public class UnityAdsInitializationAdapter
implements IMediationInitializationAdapter {
    private static final String ADAPTER_VERSION = "1.1.0";
    private static final String ADAPTER_NAME = UnityAdsInitializationAdapter.class.getSimpleName();
    private final IUnityAdsSdk unityAdsSdk = UnityAdsSdk.unityAdsSdk;

    public void initialize(@NonNull Context context, final @NonNull IMediationInitializationListener listener, @NonNull MediationAdapterConfiguration parameters) {
        if (this.unityAdsSdk.isInitialized()) {
            listener.onInitialized();
            return;
        }
        this.setMediationMetadata(context);
        this.unityAdsSdk.setConsentMetaData(context, parameters);
        IMediationInitializationListener unityAdsInitializationListener = new IMediationInitializationListener(){

            public void onInitialized() {
                listener.onInitialized();
            }

            public void onFailed(AdapterInitializationError error, String msg) {
                listener.onFailed(AdapterInitializationError.ADAPTER_AD_NETWORK_ERROR, ADAPTER_NAME + ": " + error.toString() + "; " + msg);
            }
        };
        String gameId = parameters.getAdapterParameter("gameId");
        if (gameId == null || gameId.isEmpty()) {
            listener.onFailed(AdapterInitializationError.ADAPTER_PARAM_FAILURE, ADAPTER_NAME + ": Failed to initialize due to missing game Id.");
            return;
        }
        boolean isCoppa = this.unityAdsSdk.isCoppa(parameters);
        this.unityAdsSdk.initialize(context, gameId, false, isCoppa, unityAdsInitializationListener);
    }

    public void getHeaderBiddingToken(@NonNull Context context, @NonNull AdUnitFormat adUnitFormat, @NonNull IHeaderBiddingTokenFetchListener listener) {
        UnityAds.getToken(token -> {
            if (token != null && !token.isEmpty()) {
                listener.onHeaderBiddingTokenReceived(token);
            } else {
                listener.onHeaderBiddingTokenFailed(HeaderBiddingTokenError.NO_TOKEN, "Unity returned a null or empty token.");
            }
        });
    }

    private void setMediationMetadata(@NonNull Context context) {
        MediationMetaData mediationMetaData = new MediationMetaData(context);
        mediationMetaData.setName("UnityOpenMediation");
        mediationMetaData.set("adapter_version", (Object)ADAPTER_VERSION);
        mediationMetaData.commit();
    }
}

