/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter;

import android.content.Context;
import androidx.annotation.NonNull;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.mediation.mediationadapter.IMediationInitializationListener;
import com.unity3d.mediation.mediationadapter.MediationAdapterConfiguration;
import com.unity3d.mediation.mediationadapter.ad.interstitial.IMediationInterstitialAd;
import com.unity3d.mediation.mediationadapter.ad.interstitial.IMediationInterstitialAdapter;
import com.unity3d.mediation.mediationadapter.ad.interstitial.IMediationInterstitialLoadListener;
import com.unity3d.mediation.mediationadapter.ad.interstitial.IMediationInterstitialShowListener;
import com.unity3d.mediation.mediationadapter.errors.AdapterInitializationError;
import com.unity3d.mediation.mediationadapter.errors.AdapterLoadError;
import com.unity3d.mediation.unityadsadapter.unity.IUnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.UnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.UnityErrors;
import java.util.UUID;

public class UnityAdsInterstitialAdapter
implements IMediationInterstitialAdapter {
    private final IUnityAdsSdk unityAdsSdk;

    public UnityAdsInterstitialAdapter() {
        this(UnityAdsSdk.unityAdsSdk);
    }

    UnityAdsInterstitialAdapter(IUnityAdsSdk unityAdsSdk) {
        this.unityAdsSdk = unityAdsSdk;
    }

    @NonNull
    public IMediationInterstitialAd createAd(final @NonNull Context context, final @NonNull MediationAdapterConfiguration parameters) {
        final String gameId = parameters.getAdapterParameter("gameId");
        final String placementId = parameters.getAdapterParameter("placementId");
        final boolean testMode = Boolean.parseBoolean(parameters.getAdapterParameter("testMode"));
        final boolean isCoppa = this.unityAdsSdk.isCoppa(parameters);
        final String adMarkup = parameters.getAdapterParameter("adm");
        return new IMediationInterstitialAd(){
            final String objectId = UUID.randomUUID().toString();

            private void loadAd(UnityAdsLoadOptions loadOptions, final IMediationInterstitialLoadListener listener) {
                UnityAdsInterstitialAdapter.this.unityAdsSdk.load(placementId, loadOptions, new IUnityAdsLoadListener(){

                    public void onUnityAdsAdLoaded(String placementId) {
                        listener.onLoaded();
                    }

                    public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
                        listener.onFailed(UnityErrors.parseLoadError(error), UnityErrors.getLoadErrorMessage(error, message, placementId));
                    }
                });
            }

            public void load(final @NonNull IMediationInterstitialLoadListener listener) {
                if (placementId == null || placementId.isEmpty()) {
                    listener.onFailed(AdapterLoadError.ADAPTER_PARAM_FAILURE, "Unity experienced a load error: PlacementId is empty");
                    return;
                }
                final UnityAdsLoadOptions loadOptions = new UnityAdsLoadOptions();
                if (adMarkup != null && !adMarkup.isEmpty()) {
                    loadOptions.setAdMarkup(adMarkup);
                    loadOptions.set("objectId", this.objectId);
                }
                if (!UnityAdsInterstitialAdapter.this.unityAdsSdk.isInitialized()) {
                    IMediationInitializationListener initializationListener = new IMediationInitializationListener(){

                        public void onInitialized() {
                            this.loadAd(loadOptions, listener);
                        }

                        public void onFailed(AdapterInitializationError error, String msg) {
                            listener.onFailed(AdapterLoadError.INITIALIZATION_ERROR, error.toString() + ": " + msg);
                        }
                    };
                    UnityAdsInterstitialAdapter.this.unityAdsSdk.setConsentMetaData(context, parameters);
                    UnityAdsInterstitialAdapter.this.unityAdsSdk.initialize(context, gameId, testMode, isCoppa, initializationListener);
                } else {
                    this.loadAd(loadOptions, listener);
                }
            }

            public void show(@NonNull Context context2, final @NonNull IMediationInterstitialShowListener showListener) {
                UnityAdsShowOptions showOptions = new UnityAdsShowOptions();
                if (adMarkup != null && !adMarkup.isEmpty()) {
                    showOptions.setObjectId(this.objectId);
                }
                UnityAdsInterstitialAdapter.this.unityAdsSdk.show(context2, placementId, showOptions, new IUnityAdsShowListener(){

                    public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                        showListener.onFailed(UnityErrors.parseShowError(error), UnityErrors.getShowErrorMessage(error, message));
                    }

                    public void onUnityAdsShowStart(String placementId) {
                        showListener.onShown();
                        showListener.onImpression();
                    }

                    public void onUnityAdsShowClick(String placementId) {
                        showListener.onClicked();
                    }

                    public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                        showListener.onClosed();
                    }
                });
            }

            @NonNull
            public String getAdSourceInstance() {
                return placementId;
            }
        };
    }
}

