/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter;

import android.content.Context;
import androidx.annotation.NonNull;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.mediation.mediationadapter.IMediationInitializationListener;
import com.unity3d.mediation.mediationadapter.MediationAdapterConfiguration;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationReward;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationRewardedAd;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationRewardedAdapter;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationRewardedLoadListener;
import com.unity3d.mediation.mediationadapter.ad.rewarded.IMediationRewardedShowListener;
import com.unity3d.mediation.mediationadapter.errors.AdapterInitializationError;
import com.unity3d.mediation.mediationadapter.errors.AdapterLoadError;
import com.unity3d.mediation.unityadsadapter.unity.IUnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.UnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.UnityErrors;
import java.util.UUID;

public class UnityAdsRewardedAdapter
implements IMediationRewardedAdapter {
    private final IUnityAdsSdk unityAdsSdk;

    public UnityAdsRewardedAdapter() {
        this(UnityAdsSdk.unityAdsSdk);
    }

    public UnityAdsRewardedAdapter(IUnityAdsSdk unityAdsSdk) {
        this.unityAdsSdk = unityAdsSdk;
    }

    @NonNull
    public IMediationRewardedAd createAd(final @NonNull Context context, final @NonNull MediationAdapterConfiguration parameters) {
        final String gameId = parameters.getAdapterParameter("gameId");
        final String placementId = parameters.getAdapterParameter("placementId");
        final boolean testMode = Boolean.parseBoolean(parameters.getAdapterParameter("testMode"));
        final boolean isCoppa = this.unityAdsSdk.isCoppa(parameters);
        final String adMarkup = parameters.getAdapterParameter("adm");
        return new IMediationRewardedAd(){
            final String objectId = UUID.randomUUID().toString();

            private void loadAd(UnityAdsLoadOptions loadOptions, final IMediationRewardedLoadListener listener) {
                UnityAdsRewardedAdapter.this.unityAdsSdk.load(placementId, loadOptions, new IUnityAdsLoadListener(){

                    public void onUnityAdsAdLoaded(String placementId) {
                        listener.onLoaded();
                    }

                    public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
                        listener.onFailed(UnityErrors.parseLoadError(error), UnityErrors.getLoadErrorMessage(error, message, placementId));
                    }
                });
            }

            public void load(final @NonNull IMediationRewardedLoadListener listener) {
                if (placementId == null || placementId.isEmpty()) {
                    listener.onFailed(AdapterLoadError.ADAPTER_PARAM_FAILURE, "Unity experienced a load error: PlacementId is empty");
                    return;
                }
                final UnityAdsLoadOptions loadOptions = new UnityAdsLoadOptions();
                if (adMarkup != null && !adMarkup.isEmpty()) {
                    loadOptions.setAdMarkup(adMarkup);
                    loadOptions.set("objectId", this.objectId);
                }
                if (!UnityAdsRewardedAdapter.this.unityAdsSdk.isInitialized()) {
                    IMediationInitializationListener initializationListener = new IMediationInitializationListener(){

                        public void onInitialized() {
                            this.loadAd(loadOptions, listener);
                        }

                        public void onFailed(AdapterInitializationError error, String msg) {
                            listener.onFailed(AdapterLoadError.INITIALIZATION_ERROR, error.toString() + ": " + msg);
                        }
                    };
                    UnityAdsRewardedAdapter.this.unityAdsSdk.setConsentMetaData(context, parameters);
                    UnityAdsRewardedAdapter.this.unityAdsSdk.initialize(context, gameId, testMode, isCoppa, initializationListener);
                } else {
                    this.loadAd(loadOptions, listener);
                }
            }

            public void show(@NonNull Context context2, final @NonNull IMediationRewardedShowListener showListener) {
                UnityAdsShowOptions showOptions = new UnityAdsShowOptions();
                if (adMarkup != null && !adMarkup.isEmpty()) {
                    showOptions.setObjectId(this.objectId);
                }
                UnityAdsRewardedAdapter.this.unityAdsSdk.show(context2, placementId, showOptions, new IUnityAdsShowListener(){

                    public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                        showListener.onFailed(UnityErrors.parseShowError(error), UnityErrors.getShowErrorMessage(error, message));
                    }

                    public void onUnityAdsShowStart(String placementId) {
                        showListener.onShown();
                        showListener.onImpression();
                    }

                    public void onUnityAdsShowClick(String placementId) {
                        showListener.onClicked();
                    }

                    public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                        if (state == UnityAds.UnityAdsShowCompletionState.COMPLETED) {
                            showListener.onUserRewarded(new IMediationReward(){

                                @NonNull
                                public String getType() {
                                    return "Unity Reward";
                                }

                                @NonNull
                                public String getAmount() {
                                    return "No Amount";
                                }
                            });
                        }
                        showListener.onClosed();
                    }
                });
            }

            @NonNull
            public String getAdSourceInstance() {
                return placementId;
            }
        };
    }
}

