/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter.unity;

import android.app.Activity;
import android.content.Context;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.mediation.mediationadapter.IMediationInitializationListener;
import com.unity3d.mediation.mediationadapter.MediationAdapterConfiguration;
import com.unity3d.mediation.mediationadapter.errors.AdapterInitializationError;
import com.unity3d.mediation.mediationadapter.privacy.AdapterConsentStatus;
import com.unity3d.mediation.mediationadapter.privacy.AdapterDataPrivacyLaw;
import com.unity3d.mediation.unityadsadapter.unity.IUnityAdsSdk;
import com.unity3d.mediation.unityadsadapter.unity.IUnityBannerAd;
import com.unity3d.mediation.unityadsadapter.unity.UnityBannerAd;
import com.unity3d.mediation.unityadsadapter.unity.UnityKeys;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class UnityAdsSdk
implements IUnityAdsSdk {
    public static final IUnityAdsSdk unityAdsSdk = new UnityAdsSdk();
    private final AtomicReference<Boolean> initializing = new AtomicReference();
    private final ConcurrentLinkedQueue<IMediationInitializationListener> listenerList = new ConcurrentLinkedQueue();
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2);
    private AtomicBoolean isCoppaCached;

    @Override
    public void initialize(@NonNull Context context, @NonNull String gameId, boolean testMode, boolean isCoppa, IMediationInitializationListener initializationListener) {
        if (this.isInitialized()) {
            initializationListener.onInitialized();
            return;
        }
        this.listenerList.add(initializationListener);
        if (this.isInitializing()) {
            return;
        }
        this.initializing.set(true);
        this.constructCoppaMetaData(context, isCoppa).commit();
        UnityAds.initialize((Context)context, (String)gameId, (boolean)testMode, (IUnityAdsInitializationListener)new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                UnityAdsSdk.this.notifyInitializationSuccess();
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
                UnityAdsSdk.this.notifyInitializationError(error, message);
            }
        });
    }

    private boolean isInitializing() {
        Boolean initializing = this.initializing.get();
        return initializing != null && initializing != false;
    }

    @Override
    public boolean isInitialized() {
        return UnityAds.isInitialized();
    }

    private void notifyInitializationSuccess() {
        while (!this.listenerList.isEmpty()) {
            IMediationInitializationListener listener = this.listenerList.poll();
            if (listener == null) continue;
            listener.onInitialized();
        }
        this.initializing.set(false);
    }

    private void notifyInitializationError(UnityAds.UnityAdsInitializationError error, String message) {
        while (!this.listenerList.isEmpty()) {
            IMediationInitializationListener listener = this.listenerList.poll();
            if (listener == null) continue;
            listener.onFailed(AdapterInitializationError.ADAPTER_AD_NETWORK_ERROR, error.toString() + ": " + message);
        }
        this.initializing.set(false);
    }

    @Override
    @NonNull
    public String getVersion() {
        return UnityAds.getVersion();
    }

    @Override
    public void load(@NonNull String placementId, @NonNull UnityAdsLoadOptions loadOptions, @NonNull IUnityAdsLoadListener loadListener) {
        UnityAds.load((String)placementId, (UnityAdsLoadOptions)loadOptions, (IUnityAdsLoadListener)loadListener);
    }

    @Override
    public void show(@NonNull Context context, @NonNull String placementId, @NonNull UnityAdsShowOptions unityAdsShowOptions, @NonNull IUnityAdsShowListener unityListener) {
        UnityAds.show((Activity)((Activity)context), (String)placementId, (UnityAdsShowOptions)unityAdsShowOptions, (IUnityAdsShowListener)unityListener);
    }

    @Override
    public MetaData setConsentMetaData(@NonNull Context context, @NonNull MediationAdapterConfiguration parameters) {
        Map dataPrivacyLawConsentStatusMap = parameters.getPrivacyLawParameters();
        Boolean gdprConsent = this.getConsentStatus((AdapterConsentStatus)dataPrivacyLawConsentStatusMap.get(AdapterDataPrivacyLaw.GDPR));
        Boolean ccpaConsent = this.getConsentStatus((AdapterConsentStatus)dataPrivacyLawConsentStatusMap.get(AdapterDataPrivacyLaw.CCPA));
        MetaData consentMetaData = new MetaData(context);
        if (gdprConsent != null) {
            consentMetaData.set("gdpr.consent", (Object)gdprConsent);
        }
        if (ccpaConsent != null) {
            consentMetaData.set("privacy.consent", (Object)ccpaConsent);
        }
        consentMetaData.commit();
        return consentMetaData;
    }

    @Override
    public IUnityBannerAd createBanner(@NonNull Context context, @NonNull String placementId, @NonNull Size size) {
        return new UnityBannerAd(context, placementId, size);
    }

    @Override
    @NonNull
    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    private MetaData constructCoppaMetaData(@NonNull Context context, boolean isCoppa) {
        MetaData consentMetaData = new MetaData(context);
        String unityAdsPrivacyMode = this.getUnityAdsPrivacyMode(isCoppa);
        consentMetaData.set("privacy.mode", (Object)unityAdsPrivacyMode);
        return consentMetaData;
    }

    @Override
    public boolean isCoppa(@NonNull MediationAdapterConfiguration parameters) {
        String coppaString = parameters.getAdapterParameter("coppa");
        boolean isCoppa = Boolean.parseBoolean(coppaString);
        if (coppaString != null) {
            this.isCoppaCached = new AtomicBoolean(isCoppa);
            return isCoppa;
        }
        if (this.isCoppaCached != null) {
            return this.isCoppaCached.get();
        }
        return true;
    }

    private String getUnityAdsPrivacyMode(boolean isCoppa) {
        if (isCoppa) {
            return "app";
        }
        return "none";
    }

    @Nullable
    private Boolean getConsentStatus(@Nullable AdapterConsentStatus consentStatus) {
        if (consentStatus == null) {
            return null;
        }
        switch (consentStatus) {
            case GIVEN: {
                return UnityKeys.UNITYADS_METADATA_CONSENT_ACCEPTED;
            }
            case DENIED: {
                return UnityKeys.UNITYADS_METADATA_CONSENT_DENIED;
            }
        }
        return null;
    }
}

