/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.mediation.unityadsadapter.unity;

import android.app.Activity;
import android.content.Context;
import android.util.Size;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import com.unity3d.mediation.mediationadapter.ad.banner.IMediationBannerListener;
import com.unity3d.mediation.mediationadapter.errors.AdapterLoadError;
import com.unity3d.mediation.unityadsadapter.unity.IUnityBannerAd;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import java.util.concurrent.atomic.AtomicReference;

class UnityBannerAd
implements IUnityBannerAd {
    private final BannerView bannerView;
    private final AtomicReference<ViewTreeObserver.OnGlobalLayoutListener> layoutListener;

    public UnityBannerAd(@NonNull Context context, @NonNull String placementId, @NonNull Size size) {
        UnityBannerSize bannerSize = new UnityBannerSize(size.getWidth(), size.getHeight());
        this.bannerView = new BannerView((Activity)context, placementId, bannerSize);
        this.layoutListener = new AtomicReference();
    }

    @Override
    public void loadAd(final @NonNull IMediationBannerListener bannerListener) {
        this.bannerView.setListener(new BannerView.IListener(){

            public void onBannerLoaded(final BannerView bannerAdView) {
                bannerListener.onLoaded();
                ViewTreeObserver.OnGlobalLayoutListener listener = new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        bannerAdView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        bannerListener.onImpression();
                    }
                };
                ViewTreeObserver.OnGlobalLayoutListener toBeRemoved = UnityBannerAd.this.layoutListener.getAndSet(listener);
                if (toBeRemoved != null) {
                    bannerAdView.getViewTreeObserver().removeOnGlobalLayoutListener(toBeRemoved);
                }
                bannerAdView.getViewTreeObserver().addOnGlobalLayoutListener(listener);
            }

            public void onBannerClick(BannerView bannerAdView) {
                bannerListener.onClicked();
            }

            public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
                bannerListener.onFailed(AdapterLoadError.ADAPTER_AD_NETWORK_ERROR, "Unity Ads experienced a load error: " + errorInfo.errorCode + " : " + errorInfo.errorMessage);
            }

            public void onBannerLeftApplication(BannerView bannerView) {
            }
        });
        this.bannerView.load();
    }

    @Override
    @NonNull
    public View getAdView() {
        return this.bannerView;
    }

    @Override
    public void destroy() {
        this.bannerView.destroy();
    }
}

