/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import com.universalmediaserver.external.ArtifactItem;
import com.universalmediaserver.external.GullableHostnameVerifier;
import com.universalmediaserver.external.GullableTrustManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.digest.Md5Digester;
import org.codehaus.plexus.digest.Sha1Digester;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractExternalDependencyMojo
extends AbstractInstallMojo {
    protected RepositorySystem repositorySystem;
    protected ArrayList<ArtifactItem> artifactItems;
    protected ArtifactResolver artifactResolver;
    protected ArtifactInstaller installer;
    protected List<ArtifactRepository> remoteRepositories;
    protected WagonManager wagonManager;
    protected ArchiverManager archiverManager;
    protected MavenProject project;
    protected String userSettings;
    protected String globalSettings;
    protected ArtifactRepository localRepository;
    protected String stagingDirectory;
    protected boolean force;
    protected boolean centralChecksumVerification;
    protected boolean createChecksum;
    protected boolean disableSSLValidation;
    protected final String NEWLINE = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException, MojoFailureException {
        ((AbstractInstallMojo)this).localRepository = this.localRepository;
        if (this.disableSSLValidation) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new GullableTrustManager()}, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new GullableHostnameVerifier());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                this.getLog().warn((CharSequence)("Disabling of SSL verification failed: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
        }
    }

    protected Artifact createArtifact(ArtifactItem item) {
        Artifact artifact = null;
        artifact = this.repositorySystem.createArtifactWithClassifier(item.getGroupId(), item.getArtifactId(), item.getVersion(), item.getPackaging(), item.getClassifier());
        return artifact;
    }

    protected File generatePomFile(ArtifactItem artifact) throws MojoExecutionException {
        File file;
        Model model = this.generateModel(artifact);
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile(artifact.getGroupId() + "." + artifact.getArtifactId(), ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    protected Model generateModel(ArtifactItem artifact) {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(artifact.getGroupId());
        model.setArtifactId(artifact.getArtifactId());
        model.setVersion(artifact.getVersion());
        model.setPackaging(artifact.getPackaging());
        return model;
    }

    protected File getFullyQualifiedArtifactFilePath(ArtifactItem artifactItem) {
        String artifactStagingDirectory = artifactItem.getStagingDirectory();
        if (artifactStagingDirectory == null || artifactStagingDirectory.isEmpty()) {
            artifactStagingDirectory = this.stagingDirectory;
        }
        return new File(artifactStagingDirectory, artifactItem.getLocalFile());
    }

    protected boolean verifyChecksum(File targetFile, Digester digester, String checksum) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Calculating " + digester.getAlgorithm() + " checksum for " + targetFile));
        try {
            String calculatedChecksum = digester.calc(targetFile);
            this.getLog().debug((CharSequence)("Generated checksum : " + calculatedChecksum));
            this.getLog().debug((CharSequence)("Expected checksum  : " + checksum));
            return calculatedChecksum.equals(checksum);
        }
        catch (DigesterException e) {
            throw new MojoExecutionException("Failed to calculate " + digester.getAlgorithm() + " checksum for " + targetFile, (Exception)((Object)e));
        }
    }

    protected void verifyArtifactItemChecksum(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException {
        if (artifactItem.hasChecksum()) {
            this.getLog().info((CharSequence)String.format("Verifying checksum on downloaded file %s: %s", targetFile.getName(), artifactItem.getChecksum()));
            this.getLog().debug((CharSequence)("Testing for SHA1 checksum on artifact " + artifactItem.toString()));
            if (!this.verifyChecksum(targetFile, (Digester)new Sha1Digester(), artifactItem.getChecksum())) {
                this.getLog().debug((CharSequence)("Verification failed on SHA1 checksum for file: " + targetFile.getAbsolutePath()));
                this.getLog().debug((CharSequence)("Testing for MD5 checksum on artifact: " + artifactItem.toString()));
                if (!this.verifyChecksum(targetFile, (Digester)new Md5Digester(), artifactItem.getChecksum())) {
                    throw new MojoFailureException("Both SHA1 and MD5 checksum verification failed for: " + this.NEWLINE + "  groupId    : " + artifactItem.getGroupId() + this.NEWLINE + "  artifactId : " + artifactItem.getArtifactId() + this.NEWLINE + "  version    : " + artifactItem.getVersion() + this.NEWLINE + "  checksum   : " + artifactItem.getChecksum() + this.NEWLINE + "  file       : " + targetFile.getAbsolutePath());
                }
                this.getLog().info((CharSequence)("Verification passed on MD5 checksum for artifact: " + artifactItem.toString()));
            } else {
                this.getLog().info((CharSequence)("Verification passed on SHA1 checksum for artifact: " + artifactItem.toString()));
            }
        }
    }

    protected void verifyArtifactItemExtractFileChecksum(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException {
        if (artifactItem.hasExtractFileChecksum()) {
            this.getLog().info((CharSequence)String.format("Verifying checksum on extracted file %s: %s", targetFile.getName(), artifactItem.getExtractFileChecksum()));
            this.getLog().debug((CharSequence)("Testing for SHA1 checksum on artifact: " + artifactItem.toString()));
            if (!this.verifyChecksum(targetFile, (Digester)new Sha1Digester(), artifactItem.getExtractFileChecksum())) {
                this.getLog().debug((CharSequence)("Verification failed on SHA1 checksum for extracted file: " + targetFile.getAbsolutePath()));
                this.getLog().info((CharSequence)("Testing for MD5 checksum on artifact: " + artifactItem.toString()));
                if (!this.verifyChecksum(targetFile, (Digester)new Md5Digester(), artifactItem.getExtractFileChecksum())) {
                    throw new MojoFailureException("Both MD5 and SHA1 checksum verification failed for: " + this.NEWLINE + "  groupId        : " + artifactItem.getGroupId() + this.NEWLINE + "  artifactId     : " + artifactItem.getArtifactId() + this.NEWLINE + "  version        : " + artifactItem.getVersion() + this.NEWLINE + "  checksum       : " + artifactItem.getExtractFileChecksum() + this.NEWLINE + "  extracted file : " + targetFile.getAbsolutePath());
                }
                this.getLog().info((CharSequence)("Verification passed on MD5 checksum for artifact: " + artifactItem.toString()));
            } else {
                this.getLog().info((CharSequence)("Verification passed on SHA1 checksum for artifact: " + artifactItem.toString()));
            }
        }
    }

    private String getAttribute(Node node, String attributeName) {
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode != null) {
            return attributeNode.getTextContent();
        }
        return null;
    }

    private boolean hasAttribute(Node node, String attributeName) {
        return this.getAttribute(node, attributeName) != null;
    }

    protected void verifyArtifactItemChecksumByCentralLookup(ArtifactItem artifactItem, File targetFile) throws MojoExecutionException, MojoFailureException {
        Document document;
        DocumentBuilder builder;
        if (!this.centralChecksumVerification && !artifactItem.getCentralChecksumVerification()) {
            return;
        }
        boolean artifactMismatch = false;
        StringBuilder detectedArtifacts = new StringBuilder();
        this.digester.calculate(targetFile);
        String sha1Checksum = this.digester.getSha1();
        this.getLog().debug((CharSequence)("Performing Central Repository lookup on artifact SHA1 checksum: " + sha1Checksum));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            this.getLog().error((CharSequence)("Could not create XML Document parser: " + e1.getMessage()));
            this.getLog().info((CharSequence)"Skipping Central Repository checksum verification");
            this.getLog().debug((Throwable)e1);
            return;
        }
        try {
            document = builder.parse(String.format("http://search.maven.org/solrsearch/select?q=1:\"%s\"&rows=20&wt=xml", sha1Checksum));
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)("Could not parse Central Repository response: " + e.getMessage()));
            this.getLog().info((CharSequence)"Skipping Central Repository checksum verification");
            this.getLog().debug((Throwable)e);
            return;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not contact Central Repository: " + e.getMessage()));
            this.getLog().info((CharSequence)"Skipping Central Repository checksum verification");
            this.getLog().debug((Throwable)e);
            return;
        }
        NodeList artifactList = document.getElementsByTagName("doc");
        if (artifactList != null && artifactList.getLength() > 0) {
            int nodeCount = 0;
            NodeList resultNodes = document.getElementsByTagName("result");
            int resultNodesLength = resultNodes.getLength();
            for (int i = 0; i < resultNodesLength; ++i) {
                Node node = resultNodes.item(i);
                if (!this.hasAttribute(node, "name") || !this.hasAttribute(node, "numFound") || !this.getAttribute(node, "name").equalsIgnoreCase("response")) continue;
                try {
                    nodeCount = Integer.parseInt(this.getAttribute(node, "numFound"));
                    break;
                }
                catch (NumberFormatException e) {
                    nodeCount = 0;
                }
            }
            if (nodeCount == 0) {
                nodeCount = artifactList.getLength();
            }
            this.getLog().info((CharSequence)(nodeCount + " existing artifacts found in Central Repository checksum lookup, verifying artifact GAV"));
            int artifactListLength = artifactList.getLength();
            for (int index = 0; index < artifactListLength; ++index) {
                Node artifactNode = artifactList.item(index);
                if (artifactNode.hasChildNodes()) {
                    NodeList children = artifactNode.getChildNodes();
                    for (int loop = 0; loop < children.getLength(); ++loop) {
                        Node artifactProperty = children.item(loop);
                        if (!artifactProperty.getNodeName().equals("str") || !this.hasAttribute(artifactProperty, "name")) continue;
                        String propertyName = this.getAttribute(artifactProperty, "name");
                        detectedArtifacts.append("       " + propertyName + " : " + artifactProperty.getTextContent() + this.NEWLINE);
                        if (propertyName.equalsIgnoreCase("a")) {
                            if (artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getArtifactId())) continue;
                            this.getLog().error((CharSequence)("Artifact id found in Central Repository lookup does not match: " + artifactProperty.getTextContent() + " != " + artifactItem.getArtifactId()));
                            artifactMismatch = true;
                            continue;
                        }
                        if (propertyName.equalsIgnoreCase("g")) {
                            if (artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getGroupId())) continue;
                            this.getLog().error((CharSequence)("Artifact group id found in Central Repository lookup does not match: " + artifactProperty.getTextContent() + " != " + artifactItem.getGroupId()));
                            artifactMismatch = true;
                            continue;
                        }
                        if (!propertyName.equalsIgnoreCase("v") || artifactProperty.getTextContent().equalsIgnoreCase(artifactItem.getVersion())) continue;
                        this.getLog().error((CharSequence)("Artifact version found in Central Repository lookup does not match: " + artifactProperty.getTextContent() + " != " + artifactItem.getVersion()));
                        artifactMismatch = true;
                    }
                }
                detectedArtifacts.append(this.NEWLINE);
            }
        } else {
            this.getLog().info((CharSequence)"No existing artifact found in Central Repository checksum lookup, continuing artifact installation");
        }
        if (artifactMismatch) {
            throw new MojoFailureException("Central Repository artifact checksum verification failed on artifact defined in POM:" + this.NEWLINE + this.NEWLINE + "       groupId    : " + artifactItem.getGroupId() + this.NEWLINE + "       artifactId : " + artifactItem.getArtifactId() + this.NEWLINE + "       version    : " + artifactItem.getVersion() + this.NEWLINE + "       checksum   : " + sha1Checksum + this.NEWLINE + "       file       : " + targetFile.getAbsolutePath() + this.NEWLINE + this.NEWLINE + "The following artifact(s) were detected using the same checksum:" + this.NEWLINE + detectedArtifacts.toString() + this.NEWLINE + "Please verify that the GAV defined on the target artifact is correct." + this.NEWLINE);
        }
    }

    public SettingsBuilder getSettingsBuilder() {
        return new DefaultSettingsBuilderFactory().newInstance();
    }

    public SettingsBuildingRequest getSettingsBuildingRequest() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        if (this.userSettings != null) {
            request.setUserSettingsFile(new File(this.userSettings));
        }
        if (this.globalSettings != null) {
            request.setGlobalSettingsFile(new File(this.globalSettings));
        }
        return request;
    }

    protected boolean resolveArtifactItem(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setRemoteRepositories(this.remoteRepositories);
        request.setLocalRepository(this.localRepository);
        return this.artifactResolver.resolve(request).isSuccess();
    }

    protected void downloadArtifact(ArtifactItem artifactItem, Artifact artifact, File artifactFile, Map<URL, File> cachedDownloads) throws MojoExecutionException, MojoFailureException {
        if (artifactItem.getDownloadUrl() != null) {
            UnArchiver unarchiver;
            File tempDownloadFile;
            URL downloadUrl;
            try {
                downloadUrl = new URL(artifactItem.getDownloadUrl());
            }
            catch (MalformedURLException e1) {
                throw new MojoExecutionException("Could not interpret URL " + artifactItem.getDownloadUrl(), (Exception)e1);
            }
            if (cachedDownloads.containsKey(downloadUrl)) {
                tempDownloadFile = cachedDownloads.get(downloadUrl);
                this.getLog().info((CharSequence)String.format("Artifact %s is already downloaded from URL", artifactItem.getDownloadUrl()));
                this.getLog().debug((CharSequence)("Using cached download: " + tempDownloadFile.getAbsolutePath()));
            } else {
                Wagon wagon;
                try {
                    tempDownloadFile = File.createTempFile(artifactItem.getLocalFile(), "." + this.getExtension(downloadUrl));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not create temporary file", (Exception)e);
                }
                this.getLog().info((CharSequence)String.format("Downloading artifact %s from URL %s", artifactItem.toString(), artifactItem.getDownloadUrl()));
                this.getLog().debug((CharSequence)("Downloading artifact to temporary file: " + tempDownloadFile.getAbsolutePath()));
                String endPointUrl = downloadUrl.getProtocol() + "://" + downloadUrl.getAuthority();
                Repository repository = new Repository("additonal-configs", endPointUrl);
                try {
                    wagon = this.wagonManager.getWagon(repository);
                }
                catch (WagonConfigurationException | UnsupportedProtocolException e) {
                    throw new MojoExecutionException(String.format("Could not initialize protocol \"%s\": %s", downloadUrl.getProtocol(), e.getMessage()), (Exception)e);
                }
                if (this.getLog().isDebugEnabled()) {
                    Debug debug = new Debug();
                    wagon.addSessionListener((SessionListener)debug);
                    wagon.addTransferListener((TransferListener)debug);
                }
                wagon.setTimeout(artifactItem.getTimeout());
                ProxyInfo proxyInfo = this.getProxyInfo();
                try {
                    if (proxyInfo != null) {
                        wagon.connect(repository, this.wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
                    } else {
                        wagon.connect(repository, this.wagonManager.getAuthenticationInfo(repository.getId()));
                    }
                    wagon.get(downloadUrl.getPath().substring(1), tempDownloadFile);
                }
                catch (ConnectionException | ResourceDoesNotExistException | TransferFailedException | AuthenticationException | AuthorizationException e) {
                    throw new MojoExecutionException("Failed to download artifact " + artifactItem.toString() + ": " + e.getMessage(), (Exception)e);
                }
                this.getLog().debug((CharSequence)("Caching temporary file for later: " + tempDownloadFile));
                cachedDownloads.put(downloadUrl, tempDownloadFile);
            }
            this.verifyArtifactItemChecksum(artifactItem, tempDownloadFile);
            if (!artifactItem.hasExtractFile()) {
                this.getLog().info((CharSequence)("Copying downloaded artifact file to staging path: " + artifactFile.getAbsolutePath()));
                try {
                    FileUtils.copyFile((File)tempDownloadFile, (File)artifactFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy artifact " + artifactItem.toString() + " to staging path \"" + artifactFile.getAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
                }
            }
            this.getLog().info((CharSequence)("Extracting target file from downloaded compressed file: " + artifactItem.getExtractFile()));
            File tempOutputDir = FileUtils.createTempFile((String)tempDownloadFile.getName(), (String)".dir", null);
            if (!tempOutputDir.mkdirs()) {
                throw new MojoExecutionException("Could not create temporary folder: " + tempOutputDir.getAbsolutePath());
            }
            File extractedFile = new File(tempOutputDir, artifactItem.getExtractFile());
            try {
                unarchiver = this.archiverManager.getUnArchiver(tempDownloadFile);
            }
            catch (NoSuchArchiverException e) {
                if (tempDownloadFile.getName().endsWith(".gz")) {
                    try {
                        unarchiver = this.archiverManager.getUnArchiver("gzip");
                    }
                    catch (NoSuchArchiverException e1) {
                        throw new MojoExecutionException("No gzip unarchiver available for: " + tempDownloadFile.getAbsolutePath(), (Exception)((Object)e));
                    }
                    unarchiver.setDestFile(extractedFile);
                }
                throw new MojoExecutionException("No unarchiver available for archive type: " + tempDownloadFile.getAbsolutePath(), (Exception)((Object)e));
            }
            File parentDirectory = artifactFile.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists() && !artifactFile.getParentFile().mkdirs()) {
                throw new MojoExecutionException("Could not create folder: " + artifactFile.getParentFile().getAbsolutePath());
            }
            unarchiver.setSourceFile(tempDownloadFile);
            if (unarchiver.getDestFile() == null) {
                unarchiver.setDestDirectory(tempOutputDir);
            }
            unarchiver.extract();
            if (extractedFile.isFile()) {
                try {
                    FileUtils.copyFile((File)extractedFile, (File)artifactFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy \"" + extractedFile.getAbsolutePath() + "\" to \"" + artifactFile.getAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
                }
            }
            if (extractedFile.isDirectory() && artifactItem.isRepack()) {
                Archiver archiver;
                try {
                    archiver = this.archiverManager.getArchiver(artifactFile);
                }
                catch (NoSuchArchiverException e) {
                    throw new MojoExecutionException("No unarchiver available for archive type: " + artifactFile.getAbsolutePath(), (Exception)((Object)e));
                }
                archiver.setDestFile(artifactFile);
                archiver.addFileSet((FileSet)new DefaultFileSet(extractedFile));
                try {
                    archiver.createArchive();
                }
                catch (IOException | ArchiverException e) {
                    throw new MojoExecutionException("Failed to create archive \"" + artifactFile.getAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
                }
            }
            throw new MojoExecutionException("Could not find target artifact file to extract from downloaded resource:" + this.NEWLINE + "  groupId      : " + artifact.getGroupId() + this.NEWLINE + "  artifactId   : " + artifact.getArtifactId() + this.NEWLINE + "  version      : " + artifact.getVersion() + this.NEWLINE + "  extractFile  : " + artifactItem.getExtractFile() + this.NEWLINE + "  download URL : " + artifactItem.getDownloadUrl());
            this.getLog().info((CharSequence)("Extracted target file to staging path: " + artifactFile.getAbsolutePath()));
            try {
                artifactItem.setLocalFile(artifactFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to get canonical path for \"" + artifactFile.getAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
            }
        }
        throw new MojoExecutionException("Download URL for " + artifactItem.toString() + "must be specified");
    }

    protected String getExtension(URL downloadURL) {
        String path = downloadURL.getPath();
        if (path.endsWith(".tar.gz")) {
            return "tar.gz";
        }
        if (path.endsWith(".tar.bz2")) {
            return "tar.bz2";
        }
        return FileUtils.getExtension((String)path);
    }

    protected ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        try {
            Settings settings = this.getSettingsBuilder().build(this.getSettingsBuildingRequest()).getEffectiveSettings();
            if (settings != null && settings.getActiveProxy() != null) {
                Proxy settingsProxy = settings.getActiveProxy();
                proxyInfo = new ProxyInfo();
                proxyInfo.setHost(settingsProxy.getHost());
                proxyInfo.setType(settingsProxy.getProtocol());
                proxyInfo.setPort(settingsProxy.getPort());
                proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
                proxyInfo.setUserName(settingsProxy.getUsername());
                proxyInfo.setPassword(settingsProxy.getPassword());
            }
        }
        catch (SettingsBuildingException e) {
            this.getLog().warn((CharSequence)("Could not read Maven settings, skipping proxy configuration: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return null;
        }
        return proxyInfo;
    }

    protected void verifyArtifact(ArtifactItem artifactItem, File stagedArtifactFile) throws MojoExecutionException, MojoFailureException {
        if (artifactItem.hasExtractFile()) {
            if (artifactItem.hasExtractFileChecksum()) {
                this.verifyArtifactItemExtractFileChecksum(artifactItem, stagedArtifactFile);
            }
        } else {
            this.verifyArtifactItemChecksum(artifactItem, stagedArtifactFile);
        }
        this.verifyArtifactItemChecksumByCentralLookup(artifactItem, stagedArtifactFile);
    }

    protected void installArtifact(ArtifactItem artifactItem, Artifact artifact, File stagedArtifactFile) throws MojoExecutionException {
        File generatedPomFile = null;
        if (!"pom".equals(artifactItem.getPackaging())) {
            ProjectArtifactMetadata pomMetadata;
            if (artifactItem.getPomFile() != null) {
                pomMetadata = new ProjectArtifactMetadata(artifact, artifactItem.getPomFile());
                this.getLog().debug((CharSequence)("Installing defined POM file: " + artifactItem.getPomFile()));
                artifact.addMetadata((ArtifactMetadata)pomMetadata);
            } else {
                generatedPomFile = this.generatePomFile(artifactItem);
                pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                if (artifactItem.getGeneratePom()) {
                    this.getLog().debug((CharSequence)("installing generated POM file: " + generatedPomFile.getAbsolutePath()));
                    artifact.addMetadata((ArtifactMetadata)pomMetadata);
                }
            }
        }
        try {
            this.installer.install(stagedArtifactFile, artifact, this.localRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Could not install artifact " + artifact.toString() + " to local repository: " + e.getMessage(), (Exception)((Object)e));
        }
        boolean createChecksum = artifactItem.getCreateChecksum() != null ? artifactItem.getCreateChecksum() : this.createChecksum;
        this.installChecksums(artifact, createChecksum);
    }
}

