/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactItem {
    private String groupId;
    private String artifactId;
    private String version = null;
    private String classifier;
    private String localFile = "{artifactId}-{version}-{classifier}.{packaging}";
    private String stagingDirectory;
    private String downloadUrl;
    private Integer timeout;
    private String packaging = "jar";
    private boolean install = true;
    private boolean deploy = true;
    private boolean force = false;
    private File pomFile;
    private boolean generatePom = true;
    private Boolean createChecksum = null;
    private boolean centralChecksumVerification = false;
    private String checksum;
    private String extractFile;
    private String extractFileChecksum;
    private boolean repack = false;

    public ArtifactItem() {
    }

    public ArtifactItem(Artifact artifact) {
        this.setArtifactId(artifact.getArtifactId());
        this.setClassifier(artifact.getClassifier());
        this.setGroupId(artifact.getGroupId());
        this.setPackaging(artifact.getType());
        this.setVersion(artifact.getVersion());
    }

    private String filterEmptyString(String in) {
        if (in == null || in.equals("")) {
            return null;
        }
        return in;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifact) {
        this.artifactId = this.filterEmptyString(artifact);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = this.filterEmptyString(groupId);
    }

    public String getType() {
        return this.getPackaging();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = this.filterEmptyString(version);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = this.filterEmptyString(classifier);
    }

    public String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.packaging;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.classifier + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.packaging;
    }

    public String getLocalFile() {
        return this.replaceTokens(this.localFile);
    }

    public void setLocalFile(String localFile) {
        this.localFile = this.filterEmptyString(localFile);
    }

    public String getStagingDirectory() {
        return this.replaceTokens(this.stagingDirectory);
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = this.filterEmptyString(stagingDirectory);
    }

    public String getDownloadUrl() {
        return this.replaceTokens(this.downloadUrl);
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = this.filterEmptyString(downloadUrl);
    }

    public int getTimeout() {
        return this.timeout == null || this.timeout <= 0 ? 5000 : this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = this.filterEmptyString(packaging);
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean getInstall() {
        return this.install;
    }

    public void setInstall(boolean install) {
        this.install = install;
    }

    public boolean getDeploy() {
        return this.deploy;
    }

    public void setDeploy(boolean deploy) {
        this.deploy = deploy;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    public boolean getGeneratePom() {
        return this.generatePom;
    }

    public void setGeneratePom(boolean generatePom) {
        this.generatePom = generatePom;
    }

    public Boolean getCreateChecksum() {
        return this.createChecksum;
    }

    public void setCreateChecksum(boolean createChecksum) {
        this.createChecksum = createChecksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean hasChecksum() {
        return this.checksum != null && !this.checksum.isEmpty();
    }

    public boolean hasExtractFileChecksum() {
        return this.hasChecksum() && this.extractFileChecksum != null && !this.extractFileChecksum.isEmpty();
    }

    public String getExtractFileChecksum() {
        return this.extractFileChecksum;
    }

    public void setExtractFileChecksum(String extractFileChecksum) {
        this.extractFileChecksum = this.filterEmptyString(extractFileChecksum);
    }

    public void setChecksum(String checksum) {
        this.checksum = this.filterEmptyString(checksum);
    }

    public boolean getCentralChecksumVerification() {
        return this.centralChecksumVerification;
    }

    public void setCentralChecksumVerification(boolean centralChecksumVerification) {
        this.centralChecksumVerification = centralChecksumVerification;
    }

    public String getExtractFile() {
        return this.replaceTokens(this.extractFile);
    }

    public boolean hasExtractFile() {
        return this.extractFile != null && !this.extractFile.isEmpty();
    }

    public void setExtractFile(String extractFile) {
        this.extractFile = this.filterEmptyString(extractFile);
    }

    private String replaceTokens(String source) {
        String target = source;
        if (target == null) {
            return null;
        }
        if (target.isEmpty()) {
            return target;
        }
        if (this.getGroupId() != null) {
            target = target.replace("{groupId}", this.getGroupId());
        }
        if (this.getArtifactId() != null) {
            target = target.replace("{artifactId}", this.getArtifactId());
        }
        if (this.getVersion() != null) {
            target = target.replace("{version}", this.getVersion());
        }
        if (this.getVersion() != null) {
            target = target.replace("{_version}", this.getVersion().replace(".", "_"));
        }
        if (this.getPackaging() != null) {
            target = target.replace("{packaging}", this.getPackaging());
        }
        target = this.getClassifier() != null ? target.replace("{classifier}", this.getClassifier()) : target.replace("-{classifier}", "");
        if (this.getType() != null) {
            target = target.replace("{type}", this.getType());
        }
        return target;
    }

    public boolean isRepack() {
        return this.repack;
    }

    public void setRepack(boolean repack) {
        this.repack = repack;
    }
}

