/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import com.universalmediaserver.external.AbstractExternalDependencyMojo;
import com.universalmediaserver.external.ArtifactItem;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class DeployExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    private ArtifactDeployer artifactDeployer;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().info((CharSequence)"Starting to deploy external dependencies to distribution repository");
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info((CharSequence)("Resolving artifact in locale repository for deployment: " + artifactItem.toString()));
            Artifact artifact = this.createArtifact(artifactItem);
            File installedArtifactFile = this.getLocalRepoFile(artifact);
            if (installedArtifactFile.exists()) {
                if (!this.resolveArtifactItem(artifact)) {
                    throw new MojoExecutionException("Could not resolve artifact " + artifact.toString() + this.NEWLINE + "Make sure \"resolve\" and \"install\" goals has been executed first");
                }
                if (artifactItem.getDeploy()) {
                    File sshFolder;
                    ArtifactRepository repo = this.getDeploymentRepository();
                    String protocol = repo.getProtocol();
                    if (protocol.equalsIgnoreCase("scp") && !(sshFolder = new File(System.getProperty("user.home"), ".ssh")).exists() && !sshFolder.mkdirs()) {
                        throw new MojoExecutionException("Could not create folder: " + sshFolder.getAbsolutePath());
                    }
                    File generatedPomFile = null;
                    if (!"pom".equals(artifactItem.getPackaging())) {
                        ProjectArtifactMetadata pomMetadata;
                        if (artifactItem.getPomFile() != null) {
                            pomMetadata = new ProjectArtifactMetadata(artifact, artifactItem.getPomFile());
                            artifact.addMetadata((ArtifactMetadata)pomMetadata);
                        } else {
                            generatedPomFile = this.generatePomFile(artifactItem);
                            pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                            if (artifactItem.getGeneratePom()) {
                                artifact.addMetadata((ArtifactMetadata)pomMetadata);
                            }
                        }
                    }
                    this.getLog().info((CharSequence)("Deploying artifact to distribution repository: " + artifactItem.toString()));
                    try {
                        this.artifactDeployer.deploy(artifact.getFile(), artifact, repo, this.localRepository);
                        continue;
                    }
                    catch (ArtifactDeploymentException e) {
                        throw new MojoExecutionException("Deployment of external dependency failed with: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                this.getLog().debug((CharSequence)("Configured to not deploy artifact: " + artifactItem.toString()));
                continue;
            }
            throw new MojoExecutionException("Unable to find external dependency \"" + artifactItem.getArtifactId() + "\"; file not found in local repository: " + installedArtifactFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)"Finished deploying external dependencies to distribution repository");
    }

    private ArtifactRepository getDeploymentRepository() throws MojoExecutionException {
        ArtifactRepository repo = null;
        if (repo == null) {
            repo = this.project.getDistributionManagementArtifactRepository();
        }
        if (repo == null) {
            throw new MojoExecutionException("Deployment failed: Repository element was not specified in the POM inside distributionManagement element");
        }
        return repo;
    }
}

