/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import com.universalmediaserver.external.AbstractExternalDependencyMojo;
import com.universalmediaserver.external.ArtifactItem;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().info((CharSequence)"Installing external dependencies into local repository..");
        HashMap<URL, File> cachedDownloads = new HashMap<URL, File>();
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().debug((CharSequence)("Attempting to install external artifact: " + artifactItem.toString()));
            Artifact artifact = this.createArtifact(artifactItem);
            boolean artifactAlreadyInstalled = this.getLocalRepoFile(artifact).exists();
            File artifactFile = this.getFullyQualifiedArtifactFilePath(artifactItem);
            if (!artifactFile.exists() || artifact.isSnapshot() || this.force || artifactItem.getForce()) {
                if (this.getLog().isDebugEnabled()) {
                    String reason = !artifactFile.exists() ? "it's not in the staging directory" : (artifact.isSnapshot() ? "it's a snapshot" : "it is FORCED");
                    this.getLog().info((CharSequence)String.format("Downloading artifact %s as " + reason, artifactItem.toString()));
                }
                this.downloadArtifact(artifactItem, artifact, artifactFile, cachedDownloads);
                this.verifyArtifact(artifactItem, artifactFile);
            } else if (artifactFile.exists()) {
                this.getLog().debug((CharSequence)String.format("Artifact %s is already in the staging directory, no download is needed", artifactItem.toString()));
            }
            this.getLog().debug((CharSequence)String.format("Resolving artifact %s for installation", artifactItem.toString()));
            if (artifactItem.getInstall() && (!artifactAlreadyInstalled || artifact.isSnapshot() || this.force || artifactItem.getForce())) {
                if (artifactAlreadyInstalled && artifact.isSnapshot()) {
                    this.getLog().debug((CharSequence)String.format("Reinstalling artifact %s into local repository because it's a snapshot ", artifactItem.toString()));
                } else if (artifactAlreadyInstalled) {
                    this.getLog().debug((CharSequence)String.format("Reinstalling artifact %s into local repository as it is FORCED", artifactItem.toString()));
                } else {
                    this.getLog().debug((CharSequence)String.format("Installing artifact %s into local repository \"%s\"", artifactItem.toString(), this.localRepository.getId()));
                }
                this.installArtifact(artifactItem, artifact, artifactFile);
                continue;
            }
            if (!artifactItem.getInstall()) {
                this.getLog().info((CharSequence)("Configured not to install artifact: " + artifactItem.toString()));
                continue;
            }
            this.getLog().debug((CharSequence)String.format("Aritifact %s already exists in the local repository; no installation is needed", artifactItem.toString()));
        }
        if (cachedDownloads.size() > 0) {
            this.getLog().info((CharSequence)"Deleting temporary download files");
            for (File tempDownloadFile : cachedDownloads.values()) {
                this.getLog().debug((CharSequence)("Deleting file: " + tempDownloadFile.getAbsolutePath()));
                if (tempDownloadFile.delete()) continue;
                this.getLog().warn((CharSequence)("Could not delete temporary file: " + tempDownloadFile.getAbsolutePath()));
            }
        }
        this.getLog().info((CharSequence)"Finished installing all external dependencies into local repository");
    }
}

