/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import com.universalmediaserver.external.AbstractExternalDependencyMojo;
import com.universalmediaserver.external.ArtifactItem;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LocalInstallExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().info((CharSequence)"Installing external dependencies into local repository..");
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info((CharSequence)String.format("Resolving artifact %s for installation", artifactItem.toString()));
            Artifact artifact = this.createArtifact(artifactItem);
            boolean artifactAlreadyInstalled = this.getLocalRepoFile(artifact).exists();
            if (!artifactAlreadyInstalled || artifact.isSnapshot() || this.force || artifactItem.getForce()) {
                File stagedArtifactFile;
                if (artifactItem.getForce()) {
                    this.getLog().debug((CharSequence)String.format("Artifact %s is flagged as a FORCED install", artifactItem.toString()));
                }
                if ((stagedArtifactFile = this.getFullyQualifiedArtifactFilePath(artifactItem)).exists()) {
                    if (artifactItem.getInstall()) {
                        if (artifactAlreadyInstalled && artifact.isSnapshot()) {
                            this.getLog().debug((CharSequence)String.format("Reinstalling artifact %s into local repository because it's a snapshot ", artifactItem.toString()));
                        } else if (artifactAlreadyInstalled) {
                            this.getLog().debug((CharSequence)String.format("Reinstalling artifact %s into local repository as it is FORCED", artifactItem.toString()));
                        } else {
                            this.getLog().debug((CharSequence)String.format("Installing artifact %s into local repository \"%s\"", artifactItem.toString(), this.localRepository.getId()));
                        }
                        this.installArtifact(artifactItem, artifact, stagedArtifactFile);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Configured not to install artifact: " + artifactItem.toString()));
                    continue;
                }
                throw new MojoFailureException("Unable to install external dependency \"" + artifactItem.getArtifactId() + "\"; file not found in staging path: " + stagedArtifactFile.getAbsolutePath() + this.NEWLINE + "Make sure \"resolve\" goal has been executed before \"install\".");
            }
            this.getLog().info((CharSequence)String.format("Aritifact %s already exists in the local repository; no installation is needed", artifactItem.toString()));
        }
        this.getLog().info((CharSequence)"Finished installing all external dependencies into local repository");
    }
}

