/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.external;

import com.universalmediaserver.external.AbstractExternalDependencyMojo;
import com.universalmediaserver.external.ArtifactItem;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ResolveExternalDependencyMojo
extends AbstractExternalDependencyMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().info((CharSequence)"Resolving external dependencies..");
        HashMap<URL, File> cachedDownloads = new HashMap<URL, File>();
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info((CharSequence)("Attempting to resolve external artifact: " + artifactItem.toString()));
            Artifact artifact = this.createArtifact(artifactItem);
            File artifactFile = this.getFullyQualifiedArtifactFilePath(artifactItem);
            if (!artifactFile.exists() || artifact.isSnapshot() || this.force || artifactItem.getForce()) {
                if (artifactItem.getForce()) {
                    this.getLog().debug((CharSequence)String.format("Artifact %s is flagged as a FORCED download", artifactItem.toString()));
                }
                this.downloadArtifact(artifactItem, artifact, artifactFile, cachedDownloads);
                this.getLog().info((CharSequence)String.format("Artifact %s downloaded and staged", artifactItem.toString()));
                this.verifyArtifact(artifactItem, artifactFile);
                continue;
            }
            this.getLog().info((CharSequence)String.format("External artifact %s already exists in staging directory; no download needed.", artifactItem.toString()));
        }
        if (cachedDownloads.size() > 0) {
            this.getLog().info((CharSequence)"Deleting temporary download files");
            for (File tempDownloadFile : cachedDownloads.values()) {
                this.getLog().debug((CharSequence)("Deleting file: " + tempDownloadFile.getAbsolutePath()));
                if (tempDownloadFile.delete()) continue;
                this.getLog().warn((CharSequence)("Could not delete temporary file: " + tempDownloadFile.getAbsolutePath()));
            }
        }
        this.getLog().info((CharSequence)"Finished resolving all external dependencies");
    }
}

