/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.csv.CsvFormat;
import java.util.Arrays;
import java.util.Map;

public class CsvWriterSettings
extends CommonWriterSettings<CsvFormat> {
    private boolean escapeUnquotedValues = false;
    private boolean quoteAllFields = false;
    private boolean isInputEscaped = false;
    private boolean normalizeLineEndingsWithinQuotes = true;
    private char[] quotationTriggers = new char[0];
    private boolean quoteEscapingEnabled = false;

    public boolean getQuoteAllFields() {
        return this.quoteAllFields;
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.quoteAllFields = quoteAllFields;
    }

    public boolean isEscapeUnquotedValues() {
        return this.escapeUnquotedValues;
    }

    public void setEscapeUnquotedValues(boolean escapeUnquotedValues) {
        this.escapeUnquotedValues = escapeUnquotedValues;
    }

    public final boolean isInputEscaped() {
        return this.isInputEscaped;
    }

    public final void setInputEscaped(boolean isInputEscaped) {
        this.isInputEscaped = isInputEscaped;
    }

    public boolean isNormalizeLineEndingsWithinQuotes() {
        return this.normalizeLineEndingsWithinQuotes;
    }

    public void setNormalizeLineEndingsWithinQuotes(boolean normalizeLineEndingsWithinQuotes) {
        this.normalizeLineEndingsWithinQuotes = normalizeLineEndingsWithinQuotes;
    }

    @Override
    protected CsvFormat createDefaultFormat() {
        return new CsvFormat();
    }

    public char[] getQuotationTriggers() {
        return this.quotationTriggers;
    }

    public void setQuotationTriggers(char ... quotationTriggers) {
        this.quotationTriggers = quotationTriggers == null ? new char[]{} : quotationTriggers;
    }

    public boolean isQuotationTrigger(char ch) {
        for (int i = 0; i < this.quotationTriggers.length; ++i) {
            if (this.quotationTriggers[i] != ch) continue;
            return true;
        }
        return false;
    }

    public boolean isQuoteEscapingEnabled() {
        return this.quoteEscapingEnabled;
    }

    public void setQuoteEscapingEnabled(boolean quoteEscapingEnabled) {
        this.quoteEscapingEnabled = quoteEscapingEnabled;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Quote all fields", this.quoteAllFields);
        out.put("Escape unquoted values", this.escapeUnquotedValues);
        out.put("Normalize escaped line separators", this.normalizeLineEndingsWithinQuotes);
        out.put("Input escaped", this.isInputEscaped);
        out.put("Quote escaping enabled", this.quoteEscapingEnabled);
        out.put("Quotation triggers", Arrays.toString(this.quotationTriggers));
    }
}

