/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.conversions;

import com.univocity.parsers.conversions.Conversion;

public class TrimConversion
implements Conversion<String, String> {
    private final int length;

    public TrimConversion() {
        this.length = -1;
    }

    public TrimConversion(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Maximum trim length must be positive");
        }
        this.length = length;
    }

    @Override
    public String execute(String input) {
        if (input == null) {
            return null;
        }
        if (this.length != -1) {
            int begin = 0;
            while (input.charAt(begin) <= ' ') {
                ++begin;
            }
            int end = begin + (this.length < input.length() ? this.length : input.length()) - 1;
            if (end >= input.length()) {
                end = input.length() - 1;
            }
            while (input.charAt(end) <= ' ') {
                --end;
            }
            return input.substring(begin, end + 1);
        }
        return input.trim();
    }

    @Override
    public String revert(String input) {
        return this.execute(input);
    }
}

