/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.google.common.base.Strings;
import com.unvired.core.FrameworkManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DataManagerImpl;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.GlassDataManagerImpl;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.AttachmentItem;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.IndexMeta;
import com.unvired.model.StructureMeta;
import com.unvired.parser.ApplicationMetaDataParser;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.Utils;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ApplicationManager {
    private static ApplicationManager applicationManager = null;
    private IDataManager applicationDataManager = null;
    private String appName = null;
    private String appBuildNo = null;
    private Hashtable<String, FieldMeta[]> fieldMetasCache = new Hashtable();
    private Hashtable<String, BusinessEntityMeta> businessEntityMetaCache = new Hashtable();
    private Hashtable<String, StructureMeta> structureMetaCache = new Hashtable();
    private static Context applicationContext = null;

    private ApplicationManager() {
        if (this.fieldMetasCache == null) {
            this.fieldMetasCache = new Hashtable();
        }
        if (this.businessEntityMetaCache == null) {
            this.businessEntityMetaCache = new Hashtable();
        }
        if (this.structureMetaCache == null) {
            this.structureMetaCache = new Hashtable();
        }
    }

    public static ApplicationManager getInstance() {
        if (applicationManager == null) {
            applicationManager = new ApplicationManager();
        }
        return applicationManager;
    }

    public static boolean isRunnable(Activity currentActivity, Class applicationStartActivityClass) {
        boolean isFrameworkInitialized = RuntimeEngine.isFrameworkInitialized();
        if (isFrameworkInitialized) {
            return true;
        }
        if (currentActivity == null) {
            Logger.i("Applications stopped by Android. Current activity NULL");
            return false;
        }
        try {
            if (FrameworkHelper.applicationContext != null) {
                applicationContext = FrameworkHelper.applicationContext;
            } else {
                applicationContext = currentActivity.getApplicationContext();
                FrameworkHelper.setApplicationContext(applicationContext);
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while getting Application Context.", e);
            return false;
        }
        currentActivity.finish();
        Logger.i("Applications stopped by Android. Stopped the current activity: " + currentActivity);
        Intent intent = new Intent(applicationContext, applicationStartActivityClass);
        intent.setFlags(0x10000000);
        applicationContext.startActivity(intent);
        Logger.i("Applications stopped by Android. Started the base / first activity: " + applicationStartActivityClass.getName());
        return false;
    }

    public static void destroy() {
        if (applicationManager != null) {
            ApplicationManager.applicationManager.appBuildNo = null;
            ApplicationManager.applicationManager.applicationDataManager = null;
            ApplicationManager.applicationManager.appName = null;
            if (ApplicationManager.applicationManager.fieldMetasCache != null) {
                ApplicationManager.applicationManager.fieldMetasCache.clear();
            }
            if (ApplicationManager.applicationManager.businessEntityMetaCache != null) {
                ApplicationManager.applicationManager.businessEntityMetaCache.clear();
            }
            if (ApplicationManager.applicationManager.structureMetaCache != null) {
                ApplicationManager.applicationManager.structureMetaCache.clear();
            }
            applicationManager = null;
            Logger.i("Destroyed");
        } else {
            Logger.i("Destroy not required. Already null.");
        }
    }

    public void setAppBuild(String appBuildNo) {
        this.appBuildNo = appBuildNo;
    }

    public String getAppBuild() {
        return this.appBuildNo;
    }

    public void initialize(String appName, String key, int version) throws DBException {
        if (this.applicationDataManager != null) {
            return;
        }
        this.appName = appName;
        if (this.applicationDataManager == null) {
            boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
            String appDatabasePath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE);
            this.applicationDataManager = runningOnGlass ? new GlassDataManagerImpl(appDatabasePath, version) : new DataManagerImpl(appDatabasePath, version);
            this.applicationDataManager.openOrCreate(key);
        }
    }

    private void checkInitialization() throws DBException {
        if (Strings.isNullOrEmpty((String)this.appName)) {
            throw new DBException(this.getClass().getName(), "checkInitialization", "Application Name not initialized");
        }
    }

    public IDataManager getDataManager() throws DBException {
        this.checkInitialization();
        return this.applicationDataManager;
    }

    void deployApplication(String metaDataXml) throws DBException {
        ApplicationMeta applicationMeta = this.getApplicationMeta(this.appName);
        if (applicationMeta == null || applicationMeta.getVersion() == null) {
            ApplicationMetaDataParser applicationMetaDataHandler;
            try {
                applicationMetaDataHandler = new ApplicationMetaDataParser(metaDataXml);
            }
            catch (ApplicationException applicationException) {
                Logger.e("ApplicationException caught while parsing MetaData", applicationException);
                throw new DBException(this.getClass().getName(), "initializeApplication", "ApplicationException caught while parsing MetaData, " + applicationException.getMessage());
            }
            applicationMeta = applicationMetaDataHandler.getApplicationMeta();
            String tempAppName = applicationMeta.getName();
            if (!this.appName.equalsIgnoreCase(tempAppName)) {
                throw new DBException(this.getClass().getName(), "deployApplication", "Application does not match with the name in meta xml. App Name: " + this.appName + " Meta App Name: " + tempAppName);
            }
            Vector<BusinessEntityMeta> businessEntityMetas = applicationMetaDataHandler.getBusinessEntityMetas();
            Vector<StructureMeta> structureMetas = applicationMetaDataHandler.getStructureMetas();
            Vector<FieldMeta> fieldMetas = applicationMetaDataHandler.getFieldMetas();
            Vector<IndexMeta> indexMetas = applicationMetaDataHandler.getIndexMetas();
            this.registerApplication(applicationMeta);
            try {
                IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
                frameworkDataManager.execute("UPDATE " + ApplicationMeta.TABLE_NAME + " SET " + ApplicationMeta.VERSION + "= '" + applicationMeta.getVersion() + "'");
            }
            catch (DBException e) {
                Logger.e("DBException caught while updating App version in ApplicationMeta.", e);
            }
            this.createMetaData(businessEntityMetas, structureMetas, fieldMetas);
            this.createDatabase();
            this.createIndex(indexMetas);
        }
        this.mapApplicationTablesToStructures();
    }

    private void mapApplicationTablesToStructures() throws DBException {
        StructureMeta[] structureMetas = this.getStructureMeta();
        DataStructureTableMapping dataStructureTableMapping = DataStructureTableMapping.getInstance();
        if (structureMetas != null) {
            for (int i = 0; i < structureMetas.length; ++i) {
                StructureMeta structureMeta = structureMetas[i];
                String structureName = structureMeta.getStructName();
                String structureClassName = structureMeta.getClassName();
                dataStructureTableMapping.add(structureName, structureClassName);
            }
        }
    }

    public void activateApplication(String appId) throws DBException {
        this.checkInitialization();
        ApplicationMeta applicationMeta = this.getApplicationMeta(this.appName);
        applicationMeta.setID(appId);
        this.updateApplicationMeta(applicationMeta);
    }

    public void deactivateApplication(String appId) throws DBException {
        this.checkInitialization();
        ApplicationMeta applicationMeta = this.getApplicationMeta(this.appName);
        applicationMeta.setID("");
        this.updateApplicationMeta(applicationMeta);
    }

    public boolean isActive() throws DBException {
        this.checkInitialization();
        ApplicationMeta applicationMeta = this.getApplicationMeta(this.appName);
        String appId = applicationMeta.getID();
        return appId != null && !appId.equalsIgnoreCase("");
    }

    private void registerApplication(ApplicationMeta applicationMeta) throws DBException {
        this.checkInitialization();
        String name = applicationMeta.getName();
        ApplicationMeta appMeta = this.getApplicationMeta(name);
        if (appMeta == null) {
            this.createApplicationMeta(applicationMeta);
        }
    }

    void createApplicationMeta(ApplicationMeta applicationMeta) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        ApplicationMeta appMeta = applicationMeta;
        frameworkDataManager.insert(appMeta);
    }

    void updateApplicationMeta(ApplicationMeta applicationMeta) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        frameworkDataManager.update(applicationMeta);
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getApplicationId() {
        try {
            ApplicationMeta applicationMeta = this.getApplicationMeta();
            return applicationMeta.getID();
        }
        catch (DBException dbException) {
            Logger.e("Exception caught while retrieving application id from ApplicationMeta table", dbException);
            return null;
        }
    }

    public boolean isInDemoMode() throws DBException {
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        return userSettingsManager.getDemoMode();
    }

    public ApplicationMeta getApplicationMeta() throws DBException {
        if (this.appName != null && this.appName.compareTo("") != 0) {
            String whereClause = ApplicationMeta.APP_NAME + "= '" + this.appName + "'";
            IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            IDataStructure[] applicationMetas = frameworkDataManager.get(ApplicationMeta.TABLE_NAME, whereClause, ApplicationMeta.class);
            if (applicationMetas != null && applicationMetas.length > 0) {
                return (ApplicationMeta)applicationMetas[0];
            }
        }
        return null;
    }

    public ApplicationMeta getApplicationMeta(String appName) throws DBException {
        if (appName != null && appName.compareTo("") != 0) {
            String whereClause = ApplicationMeta.APP_NAME + " = '" + appName + "'";
            IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            IDataStructure[] applicationMetas = frameworkDataManager.get(ApplicationMeta.TABLE_NAME, whereClause, ApplicationMeta.class);
            if (applicationMetas != null && applicationMetas.length > 0) {
                return (ApplicationMeta)applicationMetas[0];
            }
        }
        return null;
    }

    public BusinessEntityMeta[] getBusinessEntitiesMeta() throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(BusinessEntityMeta.TABLE_NAME, BusinessEntityMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        BusinessEntityMeta[] businessEntityMetas = new BusinessEntityMeta[dataStructures.length];
        System.arraycopy(dataStructures, 0, businessEntityMetas, 0, dataStructures.length);
        return businessEntityMetas;
    }

    public BusinessEntityMeta getBusinessEntityMeta(String beName) throws DBException {
        if (beName == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("BE NAME is null");
            }
            return null;
        }
        if (this.businessEntityMetaCache == null) {
            this.businessEntityMetaCache = new Hashtable();
        }
        if (this.businessEntityMetaCache.containsKey(beName)) {
            return this.businessEntityMetaCache.get(beName);
        }
        String whereClause = BusinessEntityMeta.BE_NAME + " = '" + beName + "'";
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(BusinessEntityMeta.TABLE_NAME, whereClause, BusinessEntityMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        BusinessEntityMeta businessEntityMeta = (BusinessEntityMeta)dataStructures[0];
        this.businessEntityMetaCache.put(beName, businessEntityMeta);
        return businessEntityMeta;
    }

    public boolean isAttachmentSupported(String beName) throws DBException, ApplicationException {
        BusinessEntityMeta businessEntityMeta = this.getBusinessEntityMeta(beName);
        if (businessEntityMeta == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("Invalid BE: " + beName);
            }
            return false;
        }
        return businessEntityMeta.isAttachmentSupported();
    }

    public StructureMeta getHeaderStructureMeta(String beName) throws DBException {
        String whereClause;
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(StructureMeta.TABLE_NAME, whereClause = StructureMeta.BE_NAME + " = '" + beName + "' AND " + StructureMeta.IS_HEADER + " = 'true'", StructureMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        StructureMeta structureMeta = (StructureMeta)dataStructures[0];
        return structureMeta;
    }

    public StructureMeta getStructureMeta(String beName, String structureName) throws DBException {
        String whereClause;
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] structureMetas = frameworkDataManager.get(StructureMeta.TABLE_NAME, whereClause = StructureMeta.BE_NAME + " = '" + beName + "' AND " + StructureMeta.STRUCT_NAME + " = '" + structureName + "'", StructureMeta.class);
        if (structureMetas != null && structureMetas.length > 0) {
            return (StructureMeta)structureMetas[0];
        }
        return null;
    }

    public StructureMeta getStructureMeta(String structureName) throws DBException {
        if (this.structureMetaCache == null) {
            this.structureMetaCache = new Hashtable();
        }
        if (this.structureMetaCache.containsKey(structureName)) {
            return this.structureMetaCache.get(structureName);
        }
        String whereClause = StructureMeta.STRUCT_NAME + " = '" + structureName + "'";
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] structureMetas = frameworkDataManager.get(StructureMeta.TABLE_NAME, whereClause, StructureMeta.class);
        if (structureMetas == null || structureMetas.length == 0) {
            return null;
        }
        StructureMeta structureMeta = (StructureMeta)structureMetas[0];
        this.structureMetaCache.put(structureName, structureMeta);
        return structureMeta;
    }

    public StructureMeta[] getStructureMetas(String beName) throws DBException {
        String whereClause;
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(StructureMeta.TABLE_NAME, whereClause = StructureMeta.BE_NAME + " = '" + beName + "'", StructureMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        StructureMeta[] structureMetas = new StructureMeta[dataStructures.length];
        System.arraycopy(dataStructures, 0, structureMetas, 0, dataStructures.length);
        return structureMetas;
    }

    private StructureMeta[] getStructureMeta() throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(StructureMeta.TABLE_NAME, StructureMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        StructureMeta[] structureMetas = new StructureMeta[dataStructures.length];
        System.arraycopy(dataStructures, 0, structureMetas, 0, dataStructures.length);
        return structureMetas;
    }

    public FieldMeta[] getFieldsMeta(String structureName) throws DBException {
        FieldMeta[] fieldMetas;
        if (this.fieldMetasCache == null) {
            this.fieldMetasCache = new Hashtable();
        }
        if ((fieldMetas = this.fieldMetasCache.get(structureName)) != null) {
            return fieldMetas;
        }
        String whereClause = FieldMeta.STRUCT_NAME + " = '" + structureName + "'";
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(FieldMeta.TABLE_NAME, whereClause, FieldMeta.class);
        if (dataStructures == null || dataStructures.length == 0) {
            return null;
        }
        fieldMetas = new FieldMeta[dataStructures.length];
        System.arraycopy(dataStructures, 0, fieldMetas, 0, dataStructures.length);
        if (fieldMetas != null) {
            this.fieldMetasCache.put(structureName, fieldMetas);
        }
        return fieldMetas;
    }

    public FieldMeta getFieldMeta(String structureName, String fieldName) throws DBException {
        String whereClause = FieldMeta.STRUCT_NAME + " = '" + structureName + "' AND " + FieldMeta.FIELD_NAME + " = '" + fieldName + "'";
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] fieldMeta = frameworkDataManager.get(FieldMeta.TABLE_NAME, whereClause, FieldMeta.class);
        if (fieldMeta == null || fieldMeta.length == 0) {
            return null;
        }
        return (FieldMeta)fieldMeta[0];
    }

    public String[] getGIDFields(String structureName) throws DBException {
        String whereClause = FieldMeta.STRUCT_NAME + " = '" + structureName + "'" + " AND " + FieldMeta.IS_GID + " = '" + "true'";
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] fieldMetas = frameworkDataManager.get(FieldMeta.TABLE_NAME, whereClause, FieldMeta.class);
        if (fieldMetas != null && fieldMetas.length > 0) {
            String[] fieldNames = new String[fieldMetas.length];
            for (int i = 0; i < fieldMetas.length; ++i) {
                fieldNames[i] = ((FieldMeta)fieldMetas[i]).getFieldName();
            }
            return fieldNames;
        }
        return null;
    }

    void removeBusinessEntity(String beName) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        String whereClause = BusinessEntityMeta.BE_NAME + " = '" + beName + "'";
        frameworkDataManager.delete(BusinessEntityMeta.TABLE_NAME, whereClause);
    }

    void removeFieldMeta(String beName, String structureName, String fieldName) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        String whereClause = FieldMeta.BE_NAME + " = '" + beName + "' AND " + FieldMeta.STRUCT_NAME + " = '" + structureName + "' AND " + FieldMeta.FIELD_NAME + " = '" + fieldName + "'";
        frameworkDataManager.delete(FieldMeta.TABLE_NAME, whereClause);
    }

    void removeStructureMeta(String beName, String structureName) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        String whereClause = StructureMeta.BE_NAME + " = '" + beName + "' AND " + StructureMeta.STRUCT_NAME + " = '" + structureName + "'";
        frameworkDataManager.delete(StructureMeta.TABLE_NAME, whereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createMetaData(Vector<BusinessEntityMeta> businessEntityMetas, Vector<StructureMeta> structureMetas, Vector<FieldMeta> fieldMetas) throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        Vector<BusinessEntityMeta> beMetas = businessEntityMetas;
        Vector<StructureMeta> strMetas = structureMetas;
        Vector<FieldMeta> fldMetas = fieldMetas;
        String savePointName = Utils.getSavePointName();
        frameworkDataManager.createSavepoint(savePointName);
        try {
            int size = beMetas.size();
            BusinessEntityMeta businessEntityMeta = null;
            for (int i = 0; i < size; ++i) {
                businessEntityMeta = beMetas.elementAt(i);
                frameworkDataManager.insert(businessEntityMeta);
            }
            size = strMetas.size();
            StructureMeta structureMeta = null;
            for (int i = 0; i < size; ++i) {
                structureMeta = strMetas.elementAt(i);
                frameworkDataManager.insert(structureMeta);
            }
            size = fldMetas.size();
            FieldMeta fieldMeta = null;
            for (int i = 0; i < size; ++i) {
                fieldMeta = fldMetas.elementAt(i);
                frameworkDataManager.insert(fieldMeta);
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while saving BE/Structure/Field meta", e);
            frameworkDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            frameworkDataManager.releaseSavepoint(savePointName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabase() throws DBException {
        this.checkInitialization();
        String savePointName = Utils.getSavePointName();
        this.applicationDataManager.createSavepoint(savePointName);
        try {
            IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            IDataStructure[] structureMetas = frameworkDataManager.get(StructureMeta.TABLE_NAME, StructureMeta.class);
            int noOfStructureMetas = structureMetas.length;
            StructureMeta structureMeta = null;
            String[] foreignKeysForItemStructure = new String[]{"FID"};
            String[] parentsForForeignKeysInHeaderStructure = new String[]{"LID"};
            for (int i = 0; i < noOfStructureMetas; ++i) {
                structureMeta = (StructureMeta)structureMetas[i];
                BusinessEntityMeta businessEntityMeta = this.getBusinessEntityMeta(structureMeta.getBeName());
                if (!businessEntityMeta.getSAVE_BE()) continue;
                String whereClause = FieldMeta.APP_NAME + " = '" + structureMeta.getAppName() + "' AND " + FieldMeta.BE_NAME + " = '" + structureMeta.getBeName() + "' AND " + FieldMeta.STRUCT_NAME + " = '" + structureMeta.getStructName() + "'";
                IDataStructure[] fieldMetas = frameworkDataManager.get(FieldMeta.TABLE_NAME, whereClause, FieldMeta.class);
                int noOfFields = 0;
                int columnIndex = 0;
                String[] columnNames = null;
                String[] columnTypes = null;
                boolean[] mandatoryFields = null;
                String[] primaryKeys = new String[]{"LID"};
                Vector<String> gidsVector = new Vector<String>();
                boolean structureIsHeader = structureMeta.getIsHeader();
                if (structureIsHeader) {
                    noOfFields = fieldMetas.length + 5;
                    columnNames = new String[noOfFields];
                    columnTypes = new String[noOfFields];
                    mandatoryFields = new boolean[noOfFields];
                    columnNames[0] = "LID";
                    columnTypes[0] = "TEXT";
                    mandatoryFields[0] = true;
                    columnNames[1] = "TIME_STAMP";
                    columnTypes[1] = "INTEGER";
                    mandatoryFields[1] = true;
                    columnNames[2] = "OBJECT_STATUS";
                    columnTypes[2] = "INTEGER";
                    mandatoryFields[2] = false;
                    columnNames[3] = "SYNC_STATUS";
                    columnTypes[3] = "INTEGER";
                    mandatoryFields[3] = false;
                    columnNames[4] = "HAS_CONFLICT";
                    columnTypes[4] = "TEXT";
                    mandatoryFields[4] = false;
                    columnIndex = 5;
                } else {
                    if (structureMeta.getStructName().toLowerCase().endsWith("_attachment")) continue;
                    noOfFields = fieldMetas.length + 5;
                    columnNames = new String[noOfFields];
                    columnTypes = new String[noOfFields];
                    mandatoryFields = new boolean[noOfFields];
                    columnNames[0] = "LID";
                    columnTypes[0] = "TEXT";
                    mandatoryFields[0] = true;
                    columnNames[1] = "FID";
                    columnTypes[1] = "TEXT";
                    mandatoryFields[1] = true;
                    columnNames[2] = "TIME_STAMP";
                    columnTypes[2] = "INTEGER";
                    mandatoryFields[2] = true;
                    columnNames[3] = "OBJECT_STATUS";
                    columnTypes[3] = "INTEGER";
                    mandatoryFields[3] = false;
                    columnNames[4] = "SYNC_STATUS";
                    columnTypes[4] = "INTEGER";
                    mandatoryFields[4] = false;
                    columnIndex = 5;
                }
                FieldMeta fieldMeta = null;
                for (int j = 0; j < fieldMetas.length; ++j) {
                    fieldMeta = (FieldMeta)fieldMetas[j];
                    columnNames[columnIndex] = fieldMeta.getFieldName();
                    columnTypes[columnIndex] = fieldMeta.getSqlType();
                    if (fieldMeta.isGid()) {
                        gidsVector.addElement(fieldMeta.getFieldName());
                    }
                    mandatoryFields[columnIndex] = fieldMeta.isMandatory();
                    ++columnIndex;
                }
                int noOfGids = gidsVector.size();
                String[] uniqueKeys = new String[noOfGids];
                for (int j = 0; j < noOfGids; ++j) {
                    uniqueKeys[j] = (String)gidsVector.elementAt(j);
                }
                if (structureIsHeader) {
                    this.applicationDataManager.createTable(structureMeta.getStructName(), columnNames, columnTypes, primaryKeys, uniqueKeys, mandatoryFields, null, null, null);
                    if (!businessEntityMeta.isAttachmentSupported()) continue;
                    this.applicationDataManager.createTable(businessEntityMeta.getBeName() + "_ATTACHMENT", AttachmentItem.FIELD_NAMES, AttachmentItem.FIELD_TYPES, AttachmentItem.PRIMARY_KEYS, AttachmentItem.GID_FIELDS, AttachmentItem.MANDATORY_FIELDS, foreignKeysForItemStructure, structureMeta.getStructName(), parentsForForeignKeysInHeaderStructure);
                    StructureMeta attStrMeta = new StructureMeta();
                    attStrMeta.setAppName(this.appName);
                    attStrMeta.setBeName(businessEntityMeta.getBeName());
                    attStrMeta.setClassName(structureMeta.getClassName().replace("_HEADER", "_ATTACHMENT"));
                    attStrMeta.setIsHeader(false);
                    attStrMeta.setStructName(businessEntityMeta.getBeName() + "_ATTACHMENT");
                    attStrMeta.setDecription(structureMeta.getDecsription());
                    frameworkDataManager.insert(attStrMeta);
                    for (String fldName : AttachmentItem.FIELD_NAMES) {
                        FieldMeta attFldMeta = new FieldMeta();
                        attFldMeta.setAppName(this.appName);
                        attFldMeta.setBeName(businessEntityMeta.getBeName());
                        attFldMeta.setDescription(fldName);
                        attFldMeta.setFieldName(fldName);
                        attFldMeta.setIsGid(Arrays.asList(AttachmentItem.GID_FIELDS).contains(fldName));
                        attFldMeta.setLength(32);
                        attFldMeta.setMandatory(new Boolean(AttachmentItem.MANDATORY_FIELDS[Arrays.asList(AttachmentItem.FIELD_NAMES).indexOf(fldName)]).toString().toLowerCase());
                        attFldMeta.setSqlType(AttachmentItem.FIELD_TYPES[Arrays.asList(AttachmentItem.FIELD_NAMES).indexOf(fldName)]);
                        attFldMeta.setStructName(businessEntityMeta.getBeName() + "_ATTACHMENT");
                        frameworkDataManager.insert(attFldMeta);
                    }
                    continue;
                }
                StructureMeta headerStructure = this.getHeaderStructureMeta(structureMeta.getBeName());
                this.applicationDataManager.createTable(structureMeta.getStructName(), columnNames, columnTypes, primaryKeys, uniqueKeys, mandatoryFields, foreignKeysForItemStructure, headerStructure.getStructName(), parentsForForeignKeysInHeaderStructure);
            }
        }
        catch (Exception e) {
            this.applicationDataManager.rollbackToSavepoint(savePointName);
            Logger.e("Exception caught while creating database tables.", e);
        }
        finally {
            this.applicationDataManager.releaseSavepoint(savePointName);
        }
    }

    private void createIndex(Vector<IndexMeta> indexMetas) throws DBException {
        if (indexMetas == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.d("No index metas found in application meta data.");
            }
            return;
        }
        int noOfIndexs = indexMetas.size();
        for (int i = 0; i < noOfIndexs; ++i) {
            IndexMeta indexMeta = indexMetas.elementAt(i);
            String indexName = indexMeta.getIndexName();
            String structureName = indexMeta.getStructureName();
            String[] fieldNames = indexMeta.getFieldName();
            this.applicationDataManager.createIndex(indexName, structureName, fieldNames);
        }
    }

    public void closeDB() throws DBException {
        if (this.applicationDataManager != null) {
            this.applicationDataManager.close();
        }
    }

    public void dropDatabase() throws DBException {
        this.applicationDataManager.dropDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws DBException {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = frameworkDataManager.get(StructureMeta.TABLE_NAME, StructureMeta.class);
        if (dataStructures == null) {
            return;
        }
        int noOfDataStructures = dataStructures.length;
        if (noOfDataStructures <= 0) {
            return;
        }
        StructureMeta[] structureMetas = new StructureMeta[noOfDataStructures];
        try {
            System.arraycopy(dataStructures, 0, structureMetas, 0, noOfDataStructures);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.e("rest", indexOutOfBoundsException);
            throw new DBException(this.getClass().getName(), "reset", indexOutOfBoundsException.getMessage());
        }
        catch (ArrayStoreException arrayStoreException) {
            Logger.e("rest", arrayStoreException);
            throw new DBException(this.getClass().getName(), "reset", arrayStoreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            Logger.e("rest", nullPointerException);
            throw new DBException(this.getClass().getName(), "reset", nullPointerException.getMessage());
        }
        int noOfStructureMetas = structureMetas.length;
        String savePointName = Utils.getSavePointName();
        this.applicationDataManager.createSavepoint(savePointName);
        try {
            for (int i = 0; i < noOfStructureMetas; ++i) {
                this.applicationDataManager.delete(structureMetas[i].getStructName());
            }
        }
        catch (Exception e) {
            Logger.e("Exception caught while reseting application tables", e);
            this.applicationDataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.applicationDataManager.releaseSavepoint(savePointName);
        }
    }
}

