/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import com.google.common.base.Strings;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DataManagerImpl;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.GlassDataManagerImpl;
import com.unvired.database.IDataManager;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.AttachmentOutObject;
import com.unvired.model.AttachmentQObject;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.ConflictBEObject;
import com.unvired.model.FieldMeta;
import com.unvired.model.FrameworkAttachment;
import com.unvired.model.FrameworkSettings;
import com.unvired.model.InObject;
import com.unvired.model.InfoMessage;
import com.unvired.model.LocationTracking;
import com.unvired.model.MobileAppSettings;
import com.unvired.model.MobileUserSettings;
import com.unvired.model.OutObject;
import com.unvired.model.QueryFunction;
import com.unvired.model.SentItemObject;
import com.unvired.model.Settings;
import com.unvired.model.StructureMeta;
import com.unvired.model.SystemCredential;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.Utils;

public class FrameworkManager {
    private static FrameworkManager frameworkManager = null;
    private IDataManager dataManager = null;
    private static final int FRAMEWORK_DATABASE_VERSION = 1;
    private FrameworkSettingsManager frameworkSettingsManager = null;

    private FrameworkManager() {
        DataStructureTableMapping dataStructureTableMapping = DataStructureTableMapping.getInstance();
        dataStructureTableMapping.add("CLIENT_CREDENTIAL", SystemCredential.class.getName());
    }

    void initialize() throws DBException {
        if (this.dataManager != null) {
            return;
        }
        boolean runningOnGlass = FrameworkHelper.isRunningOnGlass();
        String fwDatabasePath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE);
        this.dataManager = runningOnGlass ? new GlassDataManagerImpl(fwDatabasePath, 1) : new DataManagerImpl(fwDatabasePath, 1);
    }

    public static FrameworkManager getInstance() {
        if (frameworkManager == null) {
            frameworkManager = new FrameworkManager();
        }
        return frameworkManager;
    }

    public static void destroy() {
        if (frameworkManager != null) {
            FrameworkManager.frameworkManager.dataManager = null;
            FrameworkManager.frameworkManager.frameworkSettingsManager = null;
            frameworkManager = null;
            Logger.i("Destroyed");
        } else {
            Logger.i("Destroy not required. Already null.");
        }
    }

    public IDataManager getDataManager() {
        return this.dataManager;
    }

    public FrameworkSettingsManager getFrameworkSettingsManager() throws DBException {
        this.frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        return this.frameworkSettingsManager;
    }

    public boolean isActive() throws DBException {
        return this.frameworkSettingsManager != null && !Strings.isNullOrEmpty((String)this.frameworkSettingsManager.getActId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openOrCreateDatabase(String key) throws DBException {
        boolean databaseExists = this.dataManager.exists();
        if (databaseExists) {
            Logger.i("Framework database exists. Opening it.");
            this.dataManager.openOrCreate(key);
            return;
        }
        Logger.i("Framework database does not exists. Creating it.");
        this.dataManager.openOrCreate(key);
        String savePointName = Utils.getSavePointName();
        this.dataManager.createSavepoint(savePointName);
        try {
            this.createFrameworkSettingsTable();
            this.createMetaDataTables();
            this.dataManager.createTable("INFO_MESSAGE", InfoMessage.FIELD_NAMES, InfoMessage.FIELD_TYPES, InfoMessage.PRIMARY_KEYS, InfoMessage.GID_FIELDS);
            this.createSyncTables();
        }
        catch (Exception e) {
            Logger.e("Exception caught while creating Framework tables", e);
            this.dataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.dataManager.releaseSavepoint(savePointName);
        }
    }

    public void dropDatabase() throws DBException {
        this.dataManager.dropDatabase();
    }

    private void createFrameworkSettingsTable() throws DBException {
        this.dataManager.createTable("FRAMEWORK_SETTINGS", FrameworkSettings.FIELD_NAMES, FrameworkSettings.FIELD_TYPES, FrameworkSettings.PRIMARY_KEYS, FrameworkSettings.GID_FIELDS);
    }

    private void createMetaDataTables() throws DBException {
        this.dataManager.createTable(ApplicationMeta.TABLE_NAME, ApplicationMeta.FIELD_NAMES, ApplicationMeta.FIELD_TYPES, ApplicationMeta.PRIMARY_KEYS, ApplicationMeta.GID_FIELDS);
        this.dataManager.createTable(BusinessEntityMeta.TABLE_NAME, BusinessEntityMeta.FIELD_NAMES, BusinessEntityMeta.FIELD_TYPES, BusinessEntityMeta.PRIMARY_KEYS, BusinessEntityMeta.GID_FIELDS);
        this.dataManager.createTable(StructureMeta.TABLE_NAME, StructureMeta.FIELD_NAMES, StructureMeta.FIELD_TYPES, StructureMeta.PRIMARY_KEYS, StructureMeta.GID_FIELDS);
        this.dataManager.createTable(FieldMeta.TABLE_NAME, FieldMeta.FIELD_NAMES, FieldMeta.FIELD_TYPES, FieldMeta.PRIMARY_KEYS, FieldMeta.GID_FIELDS);
        this.dataManager.createTable("CLIENT_CREDENTIAL", SystemCredential.FIELD_NAMES, SystemCredential.FIELD_TYPES, SystemCredential.PRIMARY_KEYS, SystemCredential.GID_FIELDS);
        this.dataManager.createTable(QueryFunction.TABLE_NAME, QueryFunction.FIELD_NAMES, QueryFunction.FIELD_TYPES, QueryFunction.PRIMARY_KEYS, QueryFunction.GID_FIELDS);
        this.dataManager.createTable("MOBILE_APP_SETTINGS", MobileAppSettings.FIELD_NAMES, MobileAppSettings.FIELD_TYPES, MobileAppSettings.PRIMARY_KEYS, MobileAppSettings.GID_FIELDS);
        this.dataManager.createTable("MOBILE_USER_SETTINGS", MobileUserSettings.FIELD_NAMES, MobileUserSettings.FIELD_TYPES, MobileUserSettings.PRIMARY_KEYS, MobileUserSettings.GID_FIELDS);
        this.dataManager.createTable("LOCATION_TRACKING", LocationTracking.FIELD_NAMES, LocationTracking.FIELD_TYPES, LocationTracking.PRIMARY_KEYS, LocationTracking.GID_FIELDS);
        this.dataManager.createTable(ConflictBEObject.TABLE_NAME, ConflictBEObject.FIELD_NAMES, ConflictBEObject.FIELD_TYPES, ConflictBEObject.PRIMARY_KEYS, ConflictBEObject.GID_FIELDS);
        this.dataManager.createTable("FRAMEWORK_ATTACHMENT", FrameworkAttachment.FIELD_NAMES, FrameworkAttachment.FIELD_TYPES, FrameworkAttachment.PRIMARY_KEYS, FrameworkAttachment.GID_FIELDS);
    }

    private void createSyncTables() throws DBException {
        this.dataManager.createTable(InObject.TABLE_NAME, InObject.FIELD_NAMES, InObject.FIELD_TYPES, InObject.PRIMARY_KEYS, InObject.GID_FIELDS);
        this.dataManager.createTable(OutObject.TABLE_NAME, OutObject.FIELD_NAMES, OutObject.FIELD_TYPES, OutObject.PRIMARY_KEYS, OutObject.GID_FIELDS);
        this.dataManager.createTable(SentItemObject.TABLE_NAME, SentItemObject.FIELD_NAMES, SentItemObject.FIELD_TYPES, SentItemObject.PRIMARY_KEYS, SentItemObject.GID_FIELDS);
        this.dataManager.createTable("SETTINGS", Settings.FIELD_NAMES, Settings.FIELD_TYPES, Settings.PRIMARY_KEYS, Settings.GID_FIELDS);
        this.dataManager.createTable(AttachmentQObject.TABLE_NAME, AttachmentQObject.FIELD_NAMES, AttachmentQObject.FIELD_TYPES, AttachmentQObject.PRIMARY_KEYS);
        this.dataManager.createTable(AttachmentOutObject.TABLE_NAME, AttachmentOutObject.FIELD_NAMES, AttachmentOutObject.FIELD_TYPES, AttachmentOutObject.PRIMARY_KEYS, AttachmentOutObject.GID_FIELDS);
    }

    public void resetSyncLayer() throws DBException {
        String savePointName = Utils.getSavePointName();
        this.dataManager.createSavepoint(savePointName);
        try {
            this.dataManager.delete(OutObject.TABLE_NAME);
            this.dataManager.delete(InObject.TABLE_NAME);
            this.dataManager.delete(SentItemObject.TABLE_NAME);
        }
        catch (Exception e) {
            Logger.e("Exception caught resetting Framework Sync tables", e);
            this.dataManager.rollbackToSavepoint(savePointName);
        }
        finally {
            this.dataManager.releaseSavepoint(savePointName);
        }
    }

    public void closeDB() throws DBException {
        if (this.dataManager != null) {
            this.dataManager.close();
        }
    }
}

