/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import com.google.common.base.Strings;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.FrameworkSettings;
import java.util.Hashtable;

public class FrameworkSettingsManager {
    private final String FIELD_SERVER_ID = "ServerId";
    private final String FIELD_SERVER_TYPE = "Server_Type";
    private final String FIELD_ACT_ID = "ACT_ID";
    private final String FIELD_FE_USER_ID = "FEUSERID";
    private final String FIELD_FE_ADAPTER_NAME = "FID";
    private final String FIELD_FE_ADAPTER_TYPE = "FID_TYPE";
    private final String FIELD_FE_USER_ID_IDENTIFIER = "FID_IDENTIFIER";
    private final String FIELD_ONE_TIME_SECRET = "ONE_TIME_SECRET";
    private final String FIELD_SEC_KEY = "SEC_KEY";
    private final String FIELD_SEC_LEVEL = "SEC_LEVEL";
    private final String FIELD_LOG_LEVEL = "LOG_LEVEL";
    private final String FIELD_URL = "URL";
    private final String FIELD_CSR_URL = "CSR_URL";
    private final String FIELD_LOCAL_PASSWORD = "LOCAL_PASSWORD";
    private final String FIELD_COMPANY_ALIAS = "COMPANY_ALIAS";
    private final String FIELD_IS_DEMO = "IS_DEMO";
    private final String FIELD_PUSH_NOTIFICATION_HOST = "PUSH_NOTIFICATION_HOST";
    private final String FIELD_PUSH_NOTIFICATION_RECEIVE_PORT = "PUSH_NOTIFICATION_RECEIVE_PORT";
    private final String FIELD_C2DM_SENDER_ID = "C2DM_SENDER_ID";
    private final String FIELD_NAMESPACE = "NAMESPACE";
    private final String FIELD_DATA_CONNECTION = "DATA_CONNECTION";
    private final String FIELD_ATTACHMENT_CONNECTION = "ATTACHMENT_CONNECTION";
    private final String FIELD_DATA_FORMAT = "DATA_FORMAT";
    private final String FIELD_COMPRESS_POST_DATA = "COMPRESS_POST_DATA";
    private final String FIELD_LOCATION_TRACKING = "LOCATION_TRACKING";
    private final String LOCATION_TRACKING_INTERVAL = "LOCATION_TRACKING_INTERVAL";
    private final String LOCATION_UPLOAD_INTERVAL = "LOCATION_UPLOAD_INTERVAL";
    private final String LOCATION_TRACKING_DAYS = "LOCATION_TRACKING_DAYS";
    private final String LOCATION_TRACKING_START = "LOCATION_TRACKING_START";
    private final String LOCATION_TRACKING_END = "LOCATION_TRACKING_END";
    private final String SSL_CERTIFICATE = "SSL_CERTIFICATE";
    private final String PUSH_TOKEN = "PUSH_TOKEN";
    public static int SECURITY_LEVEL_SHARED_KEY_WITH_HTTP = 100;
    public static int SECURITY_LEVEL_SHARED_KEY_WITH_HTTPS = 200;
    public static int SECURITY_LEVEL_CLIENT_CERTIFICATE_WITH_HTTPS = 300;
    private static FrameworkSettingsManager frameworkSettingsManager;
    private Hashtable<String, FrameworkSettings> frameworkSettingsHashtable = new Hashtable();

    private FrameworkSettingsManager() throws DBException {
    }

    public static FrameworkSettingsManager getInstance() throws DBException {
        if (frameworkSettingsManager == null) {
            frameworkSettingsManager = new FrameworkSettingsManager();
        }
        return frameworkSettingsManager;
    }

    public static void destroy() {
        if (frameworkSettingsManager != null) {
            FrameworkSettingsManager.frameworkSettingsManager.frameworkSettingsHashtable = null;
            frameworkSettingsManager = null;
        }
    }

    public String getC2DMSenderId() {
        String res = "";
        try {
            res = this.getField("C2DM_SENDER_ID");
        }
        catch (Exception e) {
            Logger.e("Exception caught while retrieving GCM Sender Id");
        }
        return res;
    }

    public void setC2DMSenderId(String c2dmSenderId) throws DBException {
        this.setField("C2DM_SENDER_ID", c2dmSenderId);
    }

    public String getPushNotificationHost() throws DBException {
        return this.getField("PUSH_NOTIFICATION_HOST");
    }

    public void setPushNotificationHost(String pushNotificationHost) throws DBException {
        this.setField("PUSH_NOTIFICATION_HOST", pushNotificationHost);
    }

    public String getPushNotificationReceiverPort() throws DBException {
        return this.getField("PUSH_NOTIFICATION_RECEIVE_PORT");
    }

    public void setPushNotificationReceiverPort(String pushNotificationReceiverPort) throws DBException {
        this.setField("PUSH_NOTIFICATION_RECEIVE_PORT", pushNotificationReceiverPort);
    }

    public boolean isDemo() throws DBException {
        String isDemo = this.getField("IS_DEMO");
        return "true".equalsIgnoreCase(isDemo);
    }

    public void setDemo(boolean isDemo) throws DBException {
        if (isDemo) {
            this.setField("IS_DEMO", "true");
        } else {
            this.setField("IS_DEMO", "false");
        }
    }

    public String getServerId() throws DBException {
        return this.getField("ServerId");
    }

    public void setServerId(String serverId) throws DBException {
        this.setField("ServerId", serverId);
    }

    public String getServerType() throws DBException {
        return this.getField("Server_Type");
    }

    public void setServerType(String serverType) throws DBException {
        this.setField("Server_Type", serverType);
    }

    public String getActId() throws DBException {
        return this.getField("ACT_ID");
    }

    public void setActId(String actId) throws DBException {
        this.setField("ACT_ID", actId);
    }

    public String getFEUserIDIdentifier() throws DBException {
        return this.getField("FID_IDENTIFIER");
    }

    public void setFEUserIDIdentifier(String feUserIdIdentifier) throws DBException {
        this.setField("FID_IDENTIFIER", feUserIdIdentifier);
    }

    public String getFEAdapterName() throws DBException {
        return this.getField("FID");
    }

    public void setFEAdapterName(String feAdapterName) throws DBException {
        this.setField("FID", feAdapterName);
    }

    public String getFEAdapterType() throws DBException {
        return this.getField("FID_TYPE");
    }

    public void setFEAdapterType(String feAdapterType) throws DBException {
        this.setField("FID_TYPE", feAdapterType);
    }

    public String getOneTimeSecret() throws DBException {
        return this.getField("ONE_TIME_SECRET");
    }

    public void setOneTimeSecret(String oneTimeSecret) throws DBException {
        this.setField("ONE_TIME_SECRET", oneTimeSecret);
    }

    public String getSecKey() throws DBException {
        return this.getField("SEC_KEY");
    }

    public void setSecKey(String secKey) throws DBException {
        this.setField("SEC_KEY", secKey);
    }

    public int getSecLevel() throws DBException {
        String value = this.getField("SEC_LEVEL");
        if (value == null || value.length() <= 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setSecLevel(int secLevel) throws DBException {
        this.setField("SEC_LEVEL", String.valueOf(secLevel));
    }

    public int getLogLevel() throws DBException {
        String value = this.getField("LOG_LEVEL");
        if (value == null || value.length() <= 0) {
            return Logger.getDefaultLogLevel();
        }
        return Integer.parseInt(value);
    }

    public void setLogLevel(int logLevel) throws DBException {
        this.setField("LOG_LEVEL", String.valueOf(logLevel));
    }

    public String getUrl() throws DBException {
        return this.getField("URL");
    }

    public void setUrl(String url) throws DBException {
        this.setField("URL", url);
    }

    public String getCsrUrl() throws DBException {
        return this.getField("CSR_URL");
    }

    public void setCsrUrl(String csrUrl) throws DBException {
        this.setField("CSR_URL", csrUrl);
    }

    public String getLocalPassword() throws DBException {
        return this.getField("LOCAL_PASSWORD");
    }

    public void setLocalPassword(String localPassword) throws DBException {
        this.setField("LOCAL_PASSWORD", localPassword);
    }

    public boolean isActive() throws DBException {
        return !Strings.isNullOrEmpty((String)this.getActId());
    }

    public void setFrontEndUserId(String frontEndUserId) throws DBException {
        this.setField("FEUSERID", frontEndUserId);
    }

    public String getFrontEndUserId() throws DBException {
        return this.getField("FEUSERID");
    }

    public String getCompanyAlias() throws DBException {
        return this.getField("COMPANY_ALIAS");
    }

    public void setCompanyAlias(String companyAlias) throws DBException {
        this.setField("COMPANY_ALIAS", companyAlias);
    }

    public String getNamespace() throws DBException {
        return this.getField("NAMESPACE");
    }

    public void setNamespace(String namespace) throws DBException {
        this.setField("NAMESPACE", namespace);
    }

    public String getDataConnection() throws DBException {
        return this.getField("DATA_CONNECTION");
    }

    public void setDataConnection(String dataConnection) throws DBException {
        this.setField("DATA_CONNECTION", dataConnection);
    }

    public String getAttachmentConnection() throws DBException {
        return this.getField("ATTACHMENT_CONNECTION");
    }

    public void setAttachmentConnection(String attachmentConnection) throws DBException {
        this.setField("ATTACHMENT_CONNECTION", attachmentConnection);
    }

    public String getLocationTracking() throws DBException {
        return this.getField("LOCATION_TRACKING");
    }

    public void setLocationTracking(String locationTracking) throws DBException {
        this.setField("LOCATION_TRACKING", locationTracking);
    }

    public String getLocationTrackingInterval() throws DBException {
        return this.getField("LOCATION_TRACKING_INTERVAL");
    }

    public void setLocationTrackingInterval(String locationTrackingInterval) throws DBException {
        this.setField("LOCATION_TRACKING_INTERVAL", locationTrackingInterval);
    }

    public String getLocationUoloadInterval() throws DBException {
        return this.getField("LOCATION_UPLOAD_INTERVAL");
    }

    public void setLocationUoloadInterval(String locationUploadInterval) throws DBException {
        this.setField("LOCATION_UPLOAD_INTERVAL", locationUploadInterval);
    }

    public String getLocationTrackingDays() throws DBException {
        return this.getField("LOCATION_TRACKING_DAYS");
    }

    public void setLocationTrackingDays(String locationTrackingDays) throws DBException {
        this.setField("LOCATION_TRACKING_DAYS", locationTrackingDays);
    }

    public String getLocationTrackingStart() throws DBException {
        return this.getField("LOCATION_TRACKING_START");
    }

    public void setLocationTrackingStart(String locationTrackingStart) throws DBException {
        this.setField("LOCATION_TRACKING_START", locationTrackingStart);
    }

    public String getLocationTrackingEnd() throws DBException {
        return this.getField("LOCATION_TRACKING_END");
    }

    public void setLocationTrackingEnd(String locationTrackingEnd) throws DBException {
        this.setField("LOCATION_TRACKING_END", locationTrackingEnd);
    }

    public String getDataFormat() throws DBException {
        String dataFormat = this.getField("DATA_FORMAT");
        if (Strings.isNullOrEmpty((String)dataFormat) || "XML".equalsIgnoreCase(dataFormat)) {
            return "XML";
        }
        return "JSON";
    }

    public void setDataFormat(String dataFormat) throws DBException {
        this.setField("DATA_FORMAT", dataFormat);
    }

    public boolean isCompressPostData() throws DBException {
        String isCompress = this.getField("COMPRESS_POST_DATA");
        return "YES".equalsIgnoreCase(isCompress);
    }

    public void setCompressPostData(boolean isCompress) throws DBException {
        if (isCompress) {
            this.setField("COMPRESS_POST_DATA", "YES");
        } else {
            this.setField("COMPRESS_POST_DATA", "NO");
        }
    }

    public String getPushToken() throws DBException {
        return this.getField("PUSH_TOKEN");
    }

    public void setPushToken(String token) throws DBException {
        this.setField("PUSH_TOKEN", token);
    }

    public void setField(String fieldName, String fieldValue) throws DBException {
        FrameworkSettings frameworkSettings = this.frameworkSettingsHashtable.get(fieldName);
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        if (frameworkSettings == null) {
            frameworkSettings = new FrameworkSettings();
            frameworkSettings.setFieldName(fieldName);
            frameworkSettings.setFieldValue(fieldValue);
            dataManager.insert(frameworkSettings);
        } else {
            frameworkSettings.setFieldValue(fieldValue);
            dataManager.update(frameworkSettings);
        }
        this.frameworkSettingsHashtable.put(fieldName, frameworkSettings);
    }

    public String getField(String fieldName) throws DBException {
        FrameworkManager.getInstance().initialize();
        FrameworkSettings frameworkSettings = this.frameworkSettingsHashtable.get(fieldName);
        String fieldValue = null;
        if (frameworkSettings != null) {
            fieldValue = frameworkSettings.getFieldValue();
        } else {
            IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
            IDataStructure[] frameworkSettingsStructures = dataManager.get("FRAMEWORK_SETTINGS", FrameworkSettings.class);
            if (frameworkSettingsStructures != null) {
                String tempFieldName = null;
                String tempFieldValue = null;
                for (int i = 0; i < frameworkSettingsStructures.length; ++i) {
                    frameworkSettings = (FrameworkSettings)frameworkSettingsStructures[i];
                    tempFieldName = frameworkSettings.getFieldName();
                    tempFieldValue = frameworkSettings.getFieldValue();
                    this.frameworkSettingsHashtable.put(tempFieldName, frameworkSettings);
                    if (!tempFieldName.equalsIgnoreCase(fieldName)) continue;
                    fieldValue = tempFieldValue;
                }
            }
        }
        return fieldValue;
    }
}

