/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.parser.ApplicationMetaDataParser;

public class FrameworkVersion {
    public static final String FRAMEWORK_VERSION = "R-4.000.0132";
    public static final String FRAMEWORK_BUILD_NUMBER = "129 - 2021-02-10_13-24-25";
    public static final String FRAMEWORK_SVN_REVISION = "5150";
    public static final String FRAMEWORK_SVN_URL = "https://intranet.indience.in/svn/UNI_Client/trunk/Android/KERNEL";
    public static final String X_DEVICE_OS_VERSION = "@OS_VERSION@";
    public static final String X_DEVICE_MODEL = "@DEVICE_MODEL@";

    public static String getFrameworkVersion() {
        return FRAMEWORK_VERSION;
    }

    public static String getFrameworkBuildNumber() {
        return FRAMEWORK_BUILD_NUMBER;
    }

    public static String getFrameworkSVNText() {
        return FRAMEWORK_SVN_REVISION;
    }

    public static String getApplicationVersion() {
        Context context = LoginParameters.getContext();
        String applicationVersion = "";
        try {
            if (context != null) {
                applicationVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.log(8, FrameworkVersion.class.getName(), "getKernelVersion", "NameNotFoundException caught while getting Application Version, " + e.getMessage());
        }
        return applicationVersion;
    }

    public static String getApplicationMetaVersion() {
        ApplicationMetaDataParser applicationMetaDataHandler = null;
        String metaDataXml = LoginParameters.getMetaData();
        String applicationVersion = "";
        try {
            applicationMetaDataHandler = new ApplicationMetaDataParser(metaDataXml);
            applicationVersion = applicationMetaDataHandler.getApplicationMeta().getVersion();
        }
        catch (ApplicationException applicationException) {
            Logger.log(8, FrameworkVersion.class.getName(), "getApplicationVersion", "ApplicationException caught while parsing MetaData, " + applicationException.getMessage());
        }
        return applicationVersion;
    }

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getDeviceModel() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return model.toUpperCase();
        }
        return manufacturer.toUpperCase() + " " + model;
    }
}

