/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import android.content.Context;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DataStructureTableMapping;
import com.unvired.database.IDataManager;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.model.FrameworkAttachment;
import com.unvired.model.InfoMessage;
import com.unvired.model.LocationTracking;
import com.unvired.model.MobileAppSettings;
import com.unvired.model.MobileUserSettings;
import com.unvired.utils.FrameworkHelper;

public class RuntimeEngine {
    private static RuntimeEngine runtimeEngine;
    private ApplicationManager applicationManager = null;
    private FrameworkManager frameworkManager = null;
    private static final String FRAMEWORK_TYPE_NATIVE = "NATIVE";
    private static final String FRAMEWORK_TYPE_HTML5 = "HTML5";
    private String frameworkType = "NATIVE";
    private static boolean FRAMEWORK_INITIALIZED;
    private static boolean APPLICATION_INITIALIZED;

    private RuntimeEngine() {
    }

    public static final RuntimeEngine getInstance() {
        if (runtimeEngine == null) {
            runtimeEngine = new RuntimeEngine();
        }
        return runtimeEngine;
    }

    public static boolean isFrameworkInitialized() {
        return FRAMEWORK_INITIALIZED;
    }

    public static final void destroy() {
        FRAMEWORK_INITIALIZED = false;
        APPLICATION_INITIALIZED = false;
        if (runtimeEngine != null) {
            RuntimeEngine.runtimeEngine.applicationManager = null;
            RuntimeEngine.runtimeEngine.frameworkManager = null;
            runtimeEngine = null;
            Logger.i("Destroyed");
        } else {
            Logger.i("Destroy not required. Already null.");
        }
    }

    public static void unInitializeApplication() {
        APPLICATION_INITIALIZED = false;
    }

    public final boolean isLocalPasswordRequired(Context context, String metaDataXml, String appName) throws DBException {
        String frameworkDatabaseKey = FrameworkHelper.getUniqueId();
        try {
            this.initializeFramework(context, appName, frameworkDatabaseKey);
        }
        catch (DBException e) {
            Logger.e("Cannot initialize framework with give key to check for local password required or not ", e);
            throw new DBException(this.getClass().getName(), "initializeFramework", "Cannot open database with given key");
        }
        Logger.i("Framework initialized");
        this.initializeApplication(context, appName, metaDataXml);
        Logger.i("Application initialized");
        FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        String localPassword = frameworkSettingsManager.getLocalPassword();
        return "YES".equalsIgnoreCase(localPassword);
    }

    public final void initialize(Context context, String appName, String metaDataXml, String frameworkKey) throws DBException, ApplicationException {
        if (appName == null || appName.length() <= 0) {
            throw new ApplicationException(this.getClass().getName(), "initialize", "App name is invalid: " + appName);
        }
        if (metaDataXml == null) {
            throw new ApplicationException(this.getClass().getName(), "initialize", "App Meta XML is invalid: " + metaDataXml);
        }
        if (context == null) {
            throw new ApplicationException(this.getClass().getName(), "initialize", "Context found as invalid: " + context);
        }
        if (frameworkKey == null) {
            throw new DBException(this.getClass().getName(), "initializeFramework", "Invalid key to open framework database " + frameworkKey);
        }
        FrameworkHelper.setApplicationContext(context);
        this.initializeFramework(context, appName, frameworkKey);
        this.initializeApplication(context, appName, metaDataXml);
    }

    public final void initializeFramework(Context context, String appName, String uniqueKey) throws DBException {
        if (FRAMEWORK_INITIALIZED) {
            Logger.i("Framework already initialized.");
            return;
        }
        if (appName == null || appName.length() <= 0) {
            throw new DBException(this.getClass().getName(), "initializeFramework", "App name is invalid: " + appName);
        }
        if (uniqueKey == null) {
            throw new DBException(this.getClass().getName(), "initializeFramework", "Invalid key to open database " + uniqueKey);
        }
        FrameworkHelper.setApplicationContext(context);
        DataStructureTableMapping dataStructureTableMapping = DataStructureTableMapping.getInstance();
        dataStructureTableMapping.add("INFO_MESSAGE", InfoMessage.class.getName());
        dataStructureTableMapping.add("MOBILE_APP_SETTINGS", MobileAppSettings.class.getName());
        dataStructureTableMapping.add("MOBILE_USER_SETTINGS", MobileUserSettings.class.getName());
        dataStructureTableMapping.add("LOCATION_TRACKING", LocationTracking.class.getName());
        dataStructureTableMapping.add("FRAMEWORK_ATTACHMENT", FrameworkAttachment.class.getName());
        this.frameworkManager = FrameworkManager.getInstance();
        this.frameworkManager.initialize();
        this.frameworkManager.openOrCreateDatabase(uniqueKey);
        FrameworkSettingsManager frameworkSettingsManager = this.frameworkManager.getFrameworkSettingsManager();
        int logLevel = frameworkSettingsManager.getLogLevel();
        Logger.setLogLevel(logLevel);
        FRAMEWORK_INITIALIZED = true;
        Logger.i("Framework initialized.");
    }

    public final void initializeApplication(Context context, String appName, String metaDataXml) throws DBException {
        float versionFloat;
        if (APPLICATION_INITIALIZED) {
            Logger.i("Application already initialized.");
            return;
        }
        if (Strings.isNullOrEmpty((String)appName)) {
            Logger.i("App name cannot be empty");
        }
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        String userName = userSettingsManager.getUnviredUserId();
        String companyAlias = userSettingsManager.getCompanyAlias();
        if (Strings.isNullOrEmpty((String)userName)) {
            Logger.i("User name not available to initialize application");
        }
        if (Strings.isNullOrEmpty((String)companyAlias)) {
            Logger.i("Company name not available to initialize application");
        }
        String keyForApplicationDatabase = FrameworkHelper.getUniqueId();
        String applicationVersionInMetaXml = LoginParameters.getAppVersion();
        try {
            versionFloat = Float.parseFloat(applicationVersionInMetaXml);
        }
        catch (NumberFormatException e) {
            String error = "Application version is not an integer, " + e.getMessage();
            Logger.e(error);
            throw new DBException(this.getClass().getName(), "initializeApplication", error);
        }
        this.applicationManager = ApplicationManager.getInstance();
        this.applicationManager.initialize(appName, keyForApplicationDatabase, (int)versionFloat);
        this.applicationManager.deployApplication(metaDataXml);
        APPLICATION_INITIALIZED = true;
        Logger.i("Application initialized");
        IDataManager dataManager = this.applicationManager.getDataManager();
        Logger.i("Application initialized - DataManager: " + dataManager);
    }

    public final boolean isHTML5Framework() {
        return FRAMEWORK_TYPE_HTML5.equalsIgnoreCase(this.frameworkType);
    }

    public final void setApplicationTypeAsHTML5() {
        this.frameworkType = FRAMEWORK_TYPE_HTML5;
    }

    static {
        FRAMEWORK_INITIALIZED = false;
        APPLICATION_INITIALIZED = false;
    }
}

