/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.SystemCredential;
import com.unvired.utils.Utils;

public class SystemCredentialManager {
    public static final SystemCredential[] getClientCredentials() throws DBException {
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        IDataStructure[] dataStructures = null;
        if (dataManager != null) {
            dataStructures = dataManager.get("CLIENT_CREDENTIAL", SystemCredential.class);
        }
        if (dataStructures == null || dataStructures.length <= 0) {
            return null;
        }
        SystemCredential[] systemCredentials = new SystemCredential[dataStructures.length];
        System.arraycopy(dataStructures, 0, systemCredentials, 0, dataStructures.length);
        return systemCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveOrUpdate(SystemCredential[] systemCredentials) throws DBException {
        if (systemCredentials == null || systemCredentials.length <= 0) {
            return;
        }
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        String savePointName = Utils.getSavePointName();
        dataManager.createSavepoint(savePointName);
        try {
            for (int i = 0; i < systemCredentials.length; ++i) {
                dataManager.insertOrUpdateBasedOnGID(systemCredentials[i]);
            }
        }
        catch (Exception e) {
            dataManager.rollbackToSavepoint(savePointName);
            Logger.e("DBException caught while saving client credentials in database", e);
        }
        finally {
            dataManager.releaseSavepoint(savePointName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void update(SystemCredential[] systemCredentials) throws DBException {
        if (systemCredentials == null || systemCredentials.length <= 0) {
            return;
        }
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        String savePointName = Utils.getSavePointName();
        dataManager.createSavepoint(savePointName);
        try {
            for (int i = 0; i < systemCredentials.length; ++i) {
                dataManager.update(systemCredentials[i]);
            }
        }
        catch (Exception e) {
            dataManager.rollbackToSavepoint(savePointName);
            Logger.e("DBException caught while updating client credentials in database", e);
        }
        finally {
            dataManager.releaseSavepoint(savePointName);
        }
    }
}

