/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.core;

import com.google.common.base.Strings;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.model.Settings;
import com.unvired.utils.UITheme;
import java.util.Hashtable;

public class UserSettingsManager {
    private static final String APP_LOGIN_TYPE = "LOGIN_TYPE";
    private static final String UNVIRED_USER_ID = "UNVIRED_USER_ID";
    private static final String UNVIRED_PASSWORD = "UNVIRED_PASSWORD";
    private static final String ADS_USER_ID = "ADS_USER_ID";
    private static final String ADS_PASSWORD = "ADS_PASSWORD";
    private static final String ADS_DOMAIN = "ADS_DOMAIN";
    private static final String MD5_PASSWORD = "MD5_PASSWORD";
    private static final String SERVER_URL = "URL";
    private static final String COMPANY_ALIAS = "COMPANY_ALIAS";
    private static final String DEVICE_TYPE = "DEVICE_TYPE";
    private static final String CUSTOM_DEVICE_ID = "CUSTOM_DEVICE_ID";
    private static final String CONNECTION_TIME_OUT = "CONNECTION_TIME_OUT";
    private static final String DEMO_MODE = "DEMO_MODE";
    private static final String UI_THEME = "UI_THEME";
    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String LAST_NAME = "LAST_NAME";
    private static final String EMAIL = "EMAIL";
    private static final String JWT_TOKEN = "JWT_TOKEN";
    private static UserSettingsManager userSettingsManager;
    private Hashtable<String, Settings> userSettings = new Hashtable();

    private UserSettingsManager() {
    }

    public static UserSettingsManager getInstance() {
        if (userSettingsManager == null) {
            userSettingsManager = new UserSettingsManager();
        }
        return userSettingsManager;
    }

    public static void destroy() {
        if (userSettingsManager != null) {
            UserSettingsManager.userSettingsManager.userSettings = null;
            userSettingsManager = null;
            Logger.log(7, UserSettingsManager.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, UserSettingsManager.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public LoginParameters.LOGIN_TYPE getLoginType() throws DBException {
        String loginType = this.getField(APP_LOGIN_TYPE);
        if (loginType != null && loginType.length() != 0) {
            return LoginParameters.LOGIN_TYPE.valueOf(loginType);
        }
        return LoginParameters.LOGIN_TYPE.UNVIRED_ID;
    }

    public void setLoginType(LoginParameters.LOGIN_TYPE loginType) throws DBException {
        if (loginType == null) {
            loginType = LoginParameters.LOGIN_TYPE.UNVIRED_ID;
        }
        this.setField(APP_LOGIN_TYPE, loginType.toString());
    }

    public String getUnviredUserId() throws DBException {
        return this.getField(UNVIRED_USER_ID);
    }

    public void setUnviredUserId(String userId) throws DBException {
        this.setField(UNVIRED_USER_ID, userId);
    }

    public String getUnviredPassword() throws DBException {
        return this.getField(UNVIRED_PASSWORD);
    }

    public void setUnviredPassword(String password) throws DBException {
        this.setField(UNVIRED_PASSWORD, password);
    }

    public String getADSUserId() throws DBException {
        return this.getField(ADS_USER_ID);
    }

    public void setADSUserId(String userId) throws DBException {
        this.setField(ADS_USER_ID, userId);
    }

    public String getADSPassword() throws DBException {
        return this.getField(ADS_PASSWORD);
    }

    public void setADSPassword(String password) throws DBException {
        this.setField(ADS_PASSWORD, password);
    }

    public String getADSDomain() throws DBException {
        return this.getField(ADS_DOMAIN);
    }

    public void setADSDomain(String domain) throws DBException {
        this.setField(ADS_DOMAIN, domain);
    }

    public String getMD5Password() throws DBException {
        return this.getField(MD5_PASSWORD);
    }

    public void setMD5Password(String password) throws DBException {
        this.setField(MD5_PASSWORD, password);
    }

    public void setServerUrl(String url) throws DBException {
        this.setField(SERVER_URL, url);
    }

    public String getServerUrl() throws DBException {
        return this.getField(SERVER_URL);
    }

    public void setCompanyAlias(String companyAlias) throws DBException {
        FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        frameworkSettingsManager.setCompanyAlias(companyAlias);
        this.setField(COMPANY_ALIAS, companyAlias);
    }

    public String getCompanyAlias() throws DBException {
        return this.getField(COMPANY_ALIAS);
    }

    public void setDeviceType(String deviceType) throws DBException {
        this.setField(DEVICE_TYPE, deviceType);
    }

    public String getDeviceType() throws DBException {
        return this.getField(DEVICE_TYPE);
    }

    public void setCustomDeviceId(String customDeviceId) throws DBException {
        this.setField(CUSTOM_DEVICE_ID, customDeviceId);
    }

    public String getCustomDeviceId() throws DBException {
        return this.getField(CUSTOM_DEVICE_ID);
    }

    public void setConnectionTimeout(int connectionTimeOut) throws DBException {
        String timeOut = String.valueOf(connectionTimeOut);
        this.setField(CONNECTION_TIME_OUT, timeOut);
    }

    public int getConnectionTimeout() throws DBException {
        String timeOut = this.getField(CONNECTION_TIME_OUT);
        if (!Strings.isNullOrEmpty((String)timeOut)) {
            try {
                return Integer.parseInt(timeOut);
            }
            catch (NumberFormatException e) {
                return 60;
            }
        }
        return 60;
    }

    public void setDemoMode(boolean demoMode) throws DBException {
        this.setField(DEMO_MODE, String.valueOf(demoMode));
    }

    public boolean getDemoMode() throws DBException {
        String demoMode = this.getField(DEMO_MODE);
        return "true".equalsIgnoreCase(demoMode);
    }

    public void setUITheme(UITheme.THEME theme) throws DBException {
        this.setField(UI_THEME, theme.toString());
    }

    public UITheme.THEME getUITheme() throws DBException {
        String theme = this.getField(UI_THEME);
        if (theme != null) {
            UITheme.THEME currentTheme = UITheme.THEME.valueOf(theme);
            return currentTheme;
        }
        return null;
    }

    public void setFirstName(String firstName) throws DBException {
        this.setField(FIRST_NAME, firstName);
    }

    public String getFirstName() throws DBException {
        return this.getField(FIRST_NAME);
    }

    public void setLastName(String lastName) throws DBException {
        this.setField(LAST_NAME, lastName);
    }

    public String getLastName() throws DBException {
        return this.getField(LAST_NAME);
    }

    public void setEmail(String email) throws DBException {
        this.setField(EMAIL, email);
    }

    public String getEmail() throws DBException {
        return this.getField(EMAIL);
    }

    public void setJwtToken(String jwtToken) throws DBException {
        this.setField(JWT_TOKEN, jwtToken);
    }

    public String getJwtToken() throws DBException {
        return this.getField(JWT_TOKEN);
    }

    public String getLocalUserId() throws DBException {
        String localUserId = "";
        LoginParameters.LOGIN_TYPE loginType = userSettingsManager.getLoginType();
        switch (loginType) {
            case SAML2: 
            case UNVIRED_ID: {
                localUserId = userSettingsManager.getUnviredUserId();
                break;
            }
            case EMAIL: {
                localUserId = userSettingsManager.getEmail();
                break;
            }
            case SAP: 
            case ADS: {
                localUserId = userSettingsManager.getADSUserId();
                break;
            }
        }
        return localUserId;
    }

    public void setField(String fieldName, String fieldValue) throws DBException {
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        Settings settings = this.userSettings.get(fieldName);
        if (settings == null) {
            settings = new Settings();
            settings.setFieldName(fieldName);
            settings.setFieldValue(fieldValue);
            dataManager.insertOrUpdateBasedOnGID(settings);
        } else {
            settings.setFieldValue(fieldValue);
            dataManager.update(settings);
        }
        this.userSettings.put(fieldName, settings);
    }

    public String getField(String fieldName) throws DBException {
        Settings settings = this.userSettings.get(fieldName);
        String fieldValue = null;
        if (settings != null) {
            fieldValue = settings.getFieldValue();
        } else {
            IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
            if (dataManager == null) {
                return null;
            }
            IDataStructure[] settingsStructures = dataManager.get("SETTINGS", Settings.class);
            if (settingsStructures != null) {
                for (int i = 0; i < settingsStructures.length; ++i) {
                    settings = (Settings)settingsStructures[i];
                    String tempFieldName = settings.getFieldName();
                    String tempFieldValue = settings.getFieldValue();
                    this.userSettings.put(tempFieldName, settings);
                    if (!tempFieldName.equalsIgnoreCase(fieldName)) continue;
                    fieldValue = tempFieldValue;
                    break;
                }
            }
        }
        return fieldValue;
    }
}

